/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl.javax;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.nio.channels.ServerSocketChannel;
import java.util.Collection;
import java.util.EventListener;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.provider.javax.crypto.JSSTrustManager;
import org.mozilla.jss.ssl.javax.JSSEngine;
import org.mozilla.jss.ssl.javax.JSSParameters;
import org.mozilla.jss.ssl.javax.JSSServerSocketChannel;
import org.mozilla.jss.ssl.javax.JSSSocket;

public class JSSServerSocket
extends SSLServerSocket {
    private String engineProviderProtocol = "TLS";
    private String engineProvider = "Mozilla-JSS";
    private SSLContext jssContext;
    private JSSEngine engine;
    private ServerSocket parent;
    private JSSServerSocketChannel channel;

    public void consumeSocket(ServerSocket parent) {
        this.parent = parent;
    }

    protected SSLContext getSSLContext() throws IOException {
        if (this.jssContext == null) {
            try {
                this.jssContext = SSLContext.getInstance(this.engineProviderProtocol, this.engineProvider);
            }
            catch (Exception e) {
                throw new IOException("Unable to create JSSSocket prior to Mozilla-JSS initialization! " + e.getMessage(), e);
            }
        }
        return this.jssContext;
    }

    public void setSSLContext(SSLContext ctx) throws IOException {
        this.jssContext = ctx;
    }

    private void init() throws IOException {
        ServerSocketChannel parentChannel;
        if (this.engine == null) {
            this.initEngine();
        }
        this.channel = (parentChannel = this.parent.getChannel()) == null ? new JSSServerSocketChannel(this, this.parent, this.engine) : new JSSServerSocketChannel(this, parentChannel, this.engine);
    }

    public void initEngine() throws IOException {
        this.engine = (JSSEngine)this.getSSLContext().createSSLEngine();
    }

    public void initEngine(String host, int port) throws IOException {
        this.engine = (JSSEngine)this.getSSLContext().createSSLEngine(host, port);
    }

    public JSSEngine getEngine() {
        return this.engine;
    }

    @Override
    public JSSServerSocketChannel getChannel() {
        if (this.parent.getChannel() == null) {
            return null;
        }
        return this.getInternalChannel();
    }

    protected JSSServerSocketChannel getInternalChannel() {
        if (this.channel == null) {
            try {
                this.init();
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected error trying to construct channel: " + e.getMessage(), e);
            }
        }
        return this.channel;
    }

    protected JSSSocket acceptSocket(Socket child) throws IOException {
        JSSSocket result = new JSSSocket();
        result.consumeSocket(child);
        result.setSSLContext(this.getSSLContext());
        result.initEngine();
        result.setKeyManagers(this.engine.key_managers);
        result.setTrustManagers(this.engine.trust_managers);
        JSSParameters params = this.getSSLParameters();
        result.setSSLParameters(params);
        return result;
    }

    public void setHostname(String name) {
        this.engine.setHostname(name);
    }

    public void setCertFromAlias(String alias) throws IllegalArgumentException {
        this.engine.setCertFromAlias(alias);
    }

    public void setKeyMaterials(PK11Cert our_cert, PK11PrivKey our_key) throws IllegalArgumentException {
        this.engine.setKeyMaterials(our_cert, our_key);
    }

    public void setKeyManager(X509KeyManager km) {
        this.engine.setKeyManager(km);
    }

    public void setKeyManagers(X509KeyManager[] xkms) {
        this.engine.setKeyManagers(xkms);
    }

    public void setTrustManager(JSSTrustManager tm) {
        this.engine.setTrustManager(tm);
    }

    public void setTrustManagers(X509TrustManager[] xtms) {
        this.engine.setTrustManagers(xtms);
    }

    public void setListeners(Collection<? extends EventListener> listeners) {
        this.engine.setListeners(listeners);
    }

    public Collection<? extends EventListener> getListeners() {
        return this.engine.getListeners();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.engine.getEnabledCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.engine.getSupportedCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.engine.setEnabledCipherSuites(suites);
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.engine.getEnabledProtocols();
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.engine.getSupportedProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.engine.setEnabledProtocols(protocols);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.engine.getEnableSessionCreation();
    }

    @Override
    public void setEnableSessionCreation(boolean enabled) {
        this.engine.setEnableSessionCreation(enabled);
    }

    @Override
    public boolean getUseClientMode() {
        return this.engine.getUseClientMode();
    }

    @Override
    public void setUseClientMode(boolean client) {
        this.engine.setUseClientMode(client);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.engine.getWantClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.engine.setWantClientAuth(want);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.engine.getNeedClientAuth();
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.engine.setNeedClientAuth(need);
    }

    @Override
    public JSSParameters getSSLParameters() {
        return this.engine.getSSLParameters();
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        this.engine.setSSLParameters(params);
    }

    @Override
    public JSSSocket accept() throws IOException {
        Socket child = this.parent.accept();
        return this.acceptSocket(child);
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        this.parent.bind(endpoint);
    }

    @Override
    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        this.parent.bind(endpoint, backlog);
    }

    @Override
    public void close() throws IOException {
        this.getInternalChannel().close();
        this.engine = null;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.parent.getInetAddress();
    }

    @Override
    public int getLocalPort() {
        return this.parent.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.parent.getLocalSocketAddress();
    }

    @Override
    public synchronized int getSoTimeout() throws IOException {
        return this.parent.getSoTimeout();
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.parent.setSoTimeout(timeout);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.parent.getReuseAddress();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.parent.setReuseAddress(on);
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.parent.getReceiveBufferSize();
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.parent.setReceiveBufferSize(size);
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.parent.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public boolean isBound() {
        return this.parent.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.parent.isClosed();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JSSServerSocket with ");
        builder.append(this.engine);
        builder.append(" over ");
        builder.append(this.parent);
        return builder.toString();
    }

    @Override
    public <T> ServerSocket setOption(SocketOption<T> name, T value) throws IOException {
        this.getInternalChannel().setOption((SocketOption)name, (Object)value);
        return this;
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.getInternalChannel().getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.getInternalChannel().supportedOptions();
    }
}

