/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyPair;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.Policy;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;

public class KeyWrapping {
    public static void main(String[] args) throws Exception {
        CryptoManager cm = CryptoManager.getInstance();
        CryptoToken token = cm.getInternalCryptoToken();
        CryptoToken keyToken = cm.getInternalKeyStorageToken();
        KeyGenerator kg = token.getKeyGenerator(KeyGenAlgorithm.AES);
        KeyGenerator keyKg = keyToken.getKeyGenerator(KeyGenAlgorithm.AES);
        kg.initialize(256);
        keyKg.initialize(256);
        SymmetricKey wrapped = kg.generate();
        SymmetricKey wrapper = kg.generate();
        SymmetricKey keyWrapper = keyKg.generate();
        SymmetricKey keyWrapped = keyKg.clone(wrapped);
        byte[] plaintextPre = new byte[]{115, 36, 81, 72, 50, -121, 35, 51, 101, 95, 115, -98, -117, -74, 105, -112};
        byte[] plaintext = Cipher.pad((byte[])plaintextPre, (int)EncryptionAlgorithm.AES_256_ECB.getBlockSize());
        System.out.println("plaintext length is " + plaintext.length);
        Cipher encryptor = token.getCipherContext(EncryptionAlgorithm.AES_256_ECB);
        encryptor.initEncrypt(wrapped);
        byte[] ciphertext = encryptor.doFinal(plaintext);
        System.out.println("ciphertext length is " + ciphertext.length);
        KeyWrapper keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.AES_ECB);
        keyWrap.initWrap(wrapper, null);
        byte[] wrappedKey = keyWrap.wrap(wrapped);
        keyWrap.initUnwrap(wrapper, null);
        SymmetricKey unwrapped = keyWrap.unwrapSymmetric(wrappedKey, SymmetricKey.AES, SymmetricKey.Usage.DECRYPT, 0);
        Cipher decryptor = token.getCipherContext(EncryptionAlgorithm.AES_256_ECB);
        decryptor.initDecrypt(unwrapped);
        byte[] recoveredPre = decryptor.doFinal(ciphertext);
        System.out.println("Decrypted " + recoveredPre.length + " bytes");
        byte[] recovered = Cipher.unPad((byte[])recoveredPre, (int)EncryptionAlgorithm.AES_256_ECB.getBlockSize());
        System.out.println("plaintext:");
        KeyWrapping.displayByteArray(plaintextPre);
        System.out.println("ciphertext:");
        KeyWrapping.displayByteArray(ciphertext);
        System.out.println("recovered:");
        KeyWrapping.displayByteArray(recovered);
        keyWrap = keyToken.getKeyWrapper(KeyWrapAlgorithm.AES_CBC_PAD);
        IVParameterSpec iv = new IVParameterSpec(recovered);
        keyWrap.initWrap(keyWrapper, (AlgorithmParameterSpec)iv);
        KeyPairGenerator kpg = keyToken.getKeyPairGenerator(KeyPairAlgorithm.RSA);
        kpg.initialize(Policy.RSA_MINIMUM_KEY_SIZE);
        kpg.temporaryPairs(true);
        KeyPair kp = kpg.genKeyPair();
        PublicKey pub = kp.getPublic();
        PrivateKey privk = (PrivateKey)kp.getPrivate();
        wrappedKey = keyWrap.wrap(privk);
        System.out.println("Original key:");
        KeyWrapping.displayByteArray(privk.getUniqueID());
        privk = null;
        kp = null;
        keyWrap.initUnwrap(keyWrapper, (AlgorithmParameterSpec)iv);
        PrivateKey newPrivk = keyWrap.unwrapTemporaryPrivate(wrappedKey, PrivateKey.RSA, pub);
        keyWrap = keyToken.getKeyWrapper(KeyWrapAlgorithm.AES_KEY_WRAP_PAD);
        keyWrap.initWrap(keyWrapper, null);
        KeyPairGenerator kpg2 = keyToken.getKeyPairGenerator(KeyPairAlgorithm.RSA);
        kpg2.initialize(Policy.RSA_MINIMUM_KEY_SIZE);
        kpg2.temporaryPairs(true);
        KeyPair kp2 = kpg2.genKeyPair();
        PublicKey pub2 = kp2.getPublic();
        PrivateKey privk2 = (PrivateKey)kp2.getPrivate();
        wrappedKey = keyWrap.wrap(privk2);
        System.out.println("Original key:");
        KeyWrapping.displayByteArray(privk2.getUniqueID());
        privk2 = null;
        kp2 = null;
        keyWrap.initUnwrap(keyWrapper, null);
        PrivateKey newPrivk2 = keyWrap.unwrapTemporaryPrivate(wrappedKey, PrivateKey.RSA, pub);
        System.out.println("New key:");
        KeyWrapping.displayByteArray(newPrivk2.getUniqueID());
        System.out.println("New key:");
        KeyWrapping.displayByteArray(newPrivk2.getUniqueID());
        keyWrap = keyToken.getKeyWrapper(KeyWrapAlgorithm.RSA);
        keyWrap.initWrap(pub, null);
        wrappedKey = keyWrap.wrap(keyWrapped);
        System.out.println("Wrapped key:");
        KeyWrapping.displayByteArray(wrappedKey);
        keyWrap.initUnwrap(newPrivk, null);
        unwrapped = keyWrap.unwrapSymmetric(wrappedKey, SymmetricKey.AES, SymmetricKey.Usage.DECRYPT, 0);
        unwrapped = kg.clone(unwrapped);
        decryptor = token.getCipherContext(EncryptionAlgorithm.AES_256_ECB);
        decryptor.initDecrypt(unwrapped);
        recovered = decryptor.doFinal(ciphertext);
        System.out.println("Recovered again:");
        KeyWrapping.displayByteArray(Cipher.unPad((byte[])recovered, (int)EncryptionAlgorithm.AES_256_ECB.getBlockSize()));
        keyWrap = keyToken.getKeyWrapper(KeyWrapAlgorithm.RSA_OAEP);
        OAEPParameterSpec config = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
        keyWrap.initWrap(pub, (AlgorithmParameterSpec)config);
        wrappedKey = keyWrap.wrap(keyWrapped);
        System.out.println("Wrapped key:");
        KeyWrapping.displayByteArray(wrappedKey);
        keyWrap.initUnwrap(newPrivk, (AlgorithmParameterSpec)config);
        unwrapped = keyWrap.unwrapSymmetric(wrappedKey, SymmetricKey.AES, SymmetricKey.Usage.DECRYPT, 0);
        unwrapped = kg.clone(unwrapped);
        decryptor = token.getCipherContext(EncryptionAlgorithm.AES_256_ECB);
        decryptor.initDecrypt(unwrapped);
        recovered = decryptor.doFinal(ciphertext);
        System.out.println("Recovered again:");
        KeyWrapping.displayByteArray(Cipher.unPad((byte[])recovered, (int)EncryptionAlgorithm.AES_256_ECB.getBlockSize()));
    }

    public static void displayByteArray(byte[] ba) {
        System.out.print("[" + ba.length + " bytes] ");
        for (int i = 0; i < ba.length; ++i) {
            System.out.print(Integer.toHexString(ba[i] & 0xFF) + " ");
            if (i % 26 != 25) continue;
            System.out.println("");
        }
        System.out.println("");
    }
}

