/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.Policy;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.IncorrectPasswordException;
import org.mozilla.jss.util.PasswordCallback;

public class JCAKeyWrap {
    protected static final String MOZ_PROVIDER_NAME = "Mozilla-JSS";
    protected boolean bFipsMode = false;
    protected byte[] plainText = "Firefox   rules!Firefox   rules!Firefox   rules!Firefox   rules!Firefox   rules!".getBytes();
    protected byte[] plainTextPad = "Thunderbird rules!Thunderbird rules!Thunderbird rules!Thunderbird rules!Thunderbird rules!".getBytes();

    public static void main(String[] args) {
        if (args.length != 2) {
            JCAKeyWrap.usage();
            System.exit(1);
        }
        String dbdir = args[0];
        String passwdfile = args[1];
        try {
            JCAKeyWrap keyWrap = new JCAKeyWrap(dbdir, passwdfile);
            String otherProvider = new String("IBMJCE");
            String otherRSAProvider = new String("IBMJCE");
            Provider p = null;
            p = Security.getProvider(otherProvider);
            if (p == null) {
                otherProvider = new String("SunJCE");
                otherRSAProvider = new String("SunRsaSign");
                p = Security.getProvider(otherProvider);
                if (p == null) {
                    System.out.println("unable to find IBMJCE or SunJCE providers");
                    Provider[] providers = Security.getProviders();
                    for (int i = 0; i < providers.length; ++i) {
                        System.out.println("Provider " + i + ": " + providers[i].getName());
                    }
                    System.exit(1);
                }
            }
            KeyPairGenerator kpgen = KeyPairGenerator.getInstance("RSA", MOZ_PROVIDER_NAME);
            kpgen.initialize(Policy.RSA_MINIMUM_KEY_SIZE);
            KeyPair rsaKeyPairNSS = kpgen.generateKeyPair();
            kpgen = KeyPairGenerator.getInstance("RSA", otherRSAProvider);
            kpgen.initialize(Policy.RSA_MINIMUM_KEY_SIZE);
            KeyPair rsaKeyPairOtherProvider = kpgen.generateKeyPair();
            KeyGenerator keyGen = KeyGenerator.getInstance("DESede", MOZ_PROVIDER_NAME);
            SecretKey tripleDESKey = keyGen.generateKey();
            keyWrap.wrapSymetricKeyWithRSA(tripleDESKey, rsaKeyPairNSS, MOZ_PROVIDER_NAME, MOZ_PROVIDER_NAME);
            if (!keyWrap.isBFipsMode()) {
                keyWrap.wrapSymetricKeyWithRSA(tripleDESKey, rsaKeyPairNSS, MOZ_PROVIDER_NAME, otherProvider);
            }
            keyGen = KeyGenerator.getInstance("AES", MOZ_PROVIDER_NAME);
            keyGen.init(128);
            SecretKey aesKeyToWrap = keyGen.generateKey();
            keyGen = KeyGenerator.getInstance("AES", MOZ_PROVIDER_NAME);
            int[] AESKeySize = new int[]{128, 192, 256};
            for (int k = 0; k < AESKeySize.length; ++k) {
                keyGen.init(AESKeySize[k]);
                SecretKey aesKey = keyGen.generateKey();
                keyGen = KeyGenerator.getInstance("AES", MOZ_PROVIDER_NAME);
                int keyStrength = ((SecretKeyFacade)aesKey).key.getStrength();
                if (keyStrength == 128 && !keyWrap.isBFipsMode()) {
                    keyWrap.wrapSymetricKey(tripleDESKey, "AES/CBC/PKCS5Padding", aesKey, MOZ_PROVIDER_NAME, otherProvider);
                    keyWrap.wrapSymetricKey(aesKeyToWrap, "AES/CBC/PKCS5Padding", aesKey, MOZ_PROVIDER_NAME, otherProvider);
                    keyWrap.wrapSymetricKeyWithRSA(aesKey, rsaKeyPairNSS, MOZ_PROVIDER_NAME, otherProvider);
                } else {
                    keyWrap.wrapSymetricKey(tripleDESKey, "AES/CBC/PKCS5Padding", aesKey);
                    keyWrap.wrapSymetricKey(aesKeyToWrap, "AES/CBC/PKCS5Padding", aesKey);
                    keyWrap.wrapSymetricKeyWithRSA(aesKey, rsaKeyPairNSS);
                }
                aesKeyToWrap = aesKey;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static void usage() {
        System.out.println("Usage: java org.mozilla.jss.tests.JCAKeyWrap <dbdir> <passwordFile>");
    }

    public JCAKeyWrap(String certDbLoc, String passwdFile) {
        try {
            CryptoManager cm = CryptoManager.getInstance();
            CryptoToken token = cm.getInternalKeyStorageToken();
            FilePasswordCallback cb = new FilePasswordCallback(passwdFile);
            token.login((PasswordCallback)cb);
            if (cm.FIPSEnabled()) {
                this.bFipsMode = true;
                System.out.println("in Fipsmode.");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (IncorrectPasswordException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (TokenException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (NotInitializedException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public boolean isBFipsMode() {
        return this.bFipsMode;
    }

    public String testCipher(String symKeyType) throws Exception {
        String[] cipherDESede = new String[]{"DESede/ECB/NoPadding", "DESede/CBC/PKCS5Padding", "DESede/CBC/NoPadding"};
        String[] cipherAES = new String[]{"AES/ECB/NoPadding", "AES/CBC/NoPadding", "AES/CBC/PKCS5Padding"};
        SecureRandom r = SecureRandom.getInstance("pkcs11prng", MOZ_PROVIDER_NAME);
        if (symKeyType.equalsIgnoreCase("AES")) {
            return cipherAES[r.nextInt(cipherAES.length)];
        }
        if (symKeyType.equalsIgnoreCase("DESede")) {
            return cipherDESede[r.nextInt(cipherDESede.length)];
        }
        throw new Exception("no support for " + symKeyType);
    }

    public void wrapSymetricKeyWithRSA(Key symKey, KeyPair keyPair) throws Exception {
        this.wrapSymetricKeyWithRSA(symKey, keyPair, MOZ_PROVIDER_NAME, MOZ_PROVIDER_NAME);
    }

    public void wrapSymetricKeyWithRSA(Key symKey, KeyPair keyPair, String providerA, String providerB) throws Exception {
        try {
            String symKeyType = new String(symKey.getAlgorithm());
            System.out.print("Wrap " + symKeyType + " " + ((SecretKeyFacade)symKey).key.getStrength() + " with RSA. ");
            Cipher cipher2 = Cipher.getInstance("RSA", providerA);
            cipher2.init(3, keyPair.getPublic());
            byte[] wrappedData = cipher2.wrap(symKey);
            cipher2 = Cipher.getInstance("RSA", providerA);
            cipher2.init(4, keyPair.getPrivate());
            SecretKey unwrappedKey = (SecretKey)cipher2.unwrap(wrappedData, symKeyType, 3);
            this.testKeys(symKey, unwrappedKey, providerA, providerB);
        }
        catch (BadPaddingException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (IllegalBlockSizeException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (InvalidKeyException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchPaddingException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public void wrapSymetricKey(Key symKey, String wrapperAlg, Key wrapperKey) throws Exception {
        this.wrapSymetricKey(symKey, wrapperAlg, wrapperKey, MOZ_PROVIDER_NAME, MOZ_PROVIDER_NAME);
    }

    static boolean keysEqual(Key key1, Key key2) {
        if (key1.equals(key2)) {
            return true;
        }
        return Arrays.equals(key1.getEncoded(), key2.getEncoded());
    }

    protected void testKeys(Key keyA, Key keyB, String providerA, String providerB) throws Exception {
        if (this.bFipsMode) {
            if (((SecretKeyFacade)keyA).key.getStrength() != ((SecretKeyFacade)keyB).key.getStrength()) {
                throw new Exception("unwrapped key strength does not match orginal");
            }
        } else if (!JCAKeyWrap.keysEqual(keyA, keyB)) {
            throw new Exception("unwrapped key does not match original");
        }
        String cipherAlg = this.testCipher(keyA.getAlgorithm());
        System.out.println("Test " + cipherAlg + " encrypt with " + providerA + " decrypt " + providerB);
        byte[] plaintext = this.plainText;
        if (cipherAlg.endsWith("PKCS5Padding")) {
            plaintext = this.plainTextPad;
        }
        Cipher cipher2 = Cipher.getInstance(cipherAlg, providerA);
        cipher2.init(1, keyA);
        byte[] encryptedText = cipher2.doFinal(plaintext);
        AlgorithmParameters ap = null;
        byte[] encodedAlgParams = null;
        ap = cipher2.getParameters();
        if (ap != null) {
            encodedAlgParams = ap.getEncoded();
        }
        cipher2 = Cipher.getInstance(cipherAlg, providerB);
        if (encodedAlgParams == null) {
            cipher2.init(2, keyB);
        } else {
            AlgorithmParameters aps = AlgorithmParameters.getInstance(keyB.getAlgorithm());
            aps.init(encodedAlgParams);
            cipher2.init(2, keyB, aps);
        }
        byte[] recovered = new byte[plaintext.length];
        int rLen = cipher2.update(encryptedText, 0, encryptedText.length, recovered, 0);
        rLen += cipher2.doFinal(recovered, rLen);
        if (!Arrays.equals(plaintext, recovered)) {
            throw new Exception("key do not match. unable to encrypt/decrypt.");
        }
    }

    public void wrapSymetricKey(Key symKey, String wrapperAlg, Key wrapperKey, String providerA, String providerB) throws Exception {
        try {
            System.out.print("Wrap " + symKey.getAlgorithm() + " " + ((SecretKeyFacade)symKey).key.getStrength() + " with " + wrapperKey.getAlgorithm() + " " + ((SecretKeyFacade)wrapperKey).key.getStrength() + " symmetric key. ");
            Cipher cipher2 = Cipher.getInstance(wrapperAlg, providerA);
            cipher2.init(3, wrapperKey);
            byte[] wrappedData = cipher2.wrap(symKey);
            byte[] encodedKeyWrapAP = null;
            AlgorithmParameters ap = null;
            ap = cipher2.getParameters();
            if (ap != null) {
                encodedKeyWrapAP = ap.getEncoded();
            }
            cipher2 = Cipher.getInstance(wrapperAlg, providerA);
            if (encodedKeyWrapAP == null) {
                cipher2.init(4, wrapperKey);
            } else {
                AlgorithmParameters aps = AlgorithmParameters.getInstance(wrapperKey.getAlgorithm());
                aps.init(encodedKeyWrapAP);
                cipher2.init(4, wrapperKey, aps);
            }
            SecretKey unwrappedKey = (SecretKey)cipher2.unwrap(wrappedData, symKey.getAlgorithm(), 3);
            this.testKeys(symKey, unwrappedKey, providerA, providerB);
        }
        catch (BadPaddingException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (IllegalBlockSizeException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (InvalidKeyException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchPaddingException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

