import React from 'react';
import PropTypes from 'prop-types';

const UilFileExclamationAlt = (props) => {
  const { color, size, ...otherProps } = props
  return React.createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React.createElement('path', {
    d: 'M9,10h1a1,1,0,0,0,0-2H9a1,1,0,0,0,0,2Zm6,2H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm0,4H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm4.71,4.29a1.58,1.58,0,0,0-.15-.12.76.76,0,0,0-.18-.09L19.2,20a1,1,0,0,0-.58.06.9.9,0,0,0-.54.54A.84.84,0,0,0,18,21a1,1,0,1,0,1.92-.38A1.15,1.15,0,0,0,19.71,20.29ZM20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0A.88.88,0,0,0,13.05,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3h8a1,1,0,0,0,0-2H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3v2a1,1,0,0,0,2,0V9S20,9,20,8.94ZM15,8a1,1,0,0,1-1-1V5.41L16.59,8Zm4,7a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0V16A1,1,0,0,0,19,15Z'
  }));
};

UilFileExclamationAlt.propTypes = {
  color: PropTypes.string,
  size: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
};

UilFileExclamationAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

export default UilFileExclamationAlt;