/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import com.netscape.certsrv.base.PKIException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.dogtagpki.acme.server.ACMEEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class ACMEWebListener
implements ServletContextListener {
    public static final Logger logger = LoggerFactory.getLogger(ACMEWebListener.class);

    public ACMEEngine createEngine() {
        return new ACMEEngine();
    }

    public void contextInitialized(ServletContextEvent event) {
        String path = event.getServletContext().getContextPath();
        String id = "".equals(path) ? "ROOT" : path.substring(1);
        ACMEEngine engine = this.createEngine();
        engine.setID(id);
        try {
            engine.start();
        }
        catch (Exception e) {
            logger.error("Unable to start ACME engine: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to start ACME engine: " + e.getMessage(), (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ACMEEngine engine = ACMEEngine.getInstance();
        try {
            engine.stop();
        }
        catch (Exception e) {
            logger.error("Unable to stop ACME engine: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to stop ACME engine: " + e.getMessage(), (Throwable)e);
        }
    }
}

