/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dogtagpki.acme.ACMEAccount;
import org.dogtagpki.acme.ACMEAuthorization;
import org.dogtagpki.acme.ACMEHeader;
import org.dogtagpki.acme.ACMEIdentifier;
import org.dogtagpki.acme.ACMENonce;
import org.dogtagpki.acme.ACMEOrder;
import org.dogtagpki.acme.JWS;
import org.dogtagpki.acme.ValidationResult;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.acme.server.ACMEIdentifierValidator;
import org.dogtagpki.acme.server.ACMEManagedService;
import org.dogtagpki.acme.server.ACMEService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="new-order")
@ACMEManagedService
public class ACMENewOrderService
extends ACMEService {
    public static Logger logger = LoggerFactory.getLogger(ACMENewOrderService.class);
    @Context
    UriInfo uriInfo;

    @POST
    @Produces(value={"application/json"})
    public Response createNewOrder(JWS jws) throws Exception {
        logger.info("Creating new order");
        Date currentTime = new Date();
        String protectedHeader = new String(jws.getProtectedHeaderAsBytes(), "UTF-8");
        logger.info("Header: " + protectedHeader);
        ACMEHeader header = ACMEHeader.fromJSON((String)protectedHeader);
        ACMEEngine engine = ACMEEngine.getInstance();
        engine.validateNonce(header.getNonce());
        URI kid = header.getKid();
        String kidPath = kid.getPath();
        String accountID = kidPath.substring(kidPath.lastIndexOf(47) + 1);
        logger.info("Account ID: " + accountID);
        ACMEAccount account = engine.getAccount(accountID);
        engine.validateJWS(jws, header.getAlg(), account.getJWK());
        String payload = new String(jws.getPayloadAsBytes(), "UTF-8");
        logger.info("Payload: " + payload);
        ACMEOrder request = ACMEOrder.fromJSON((String)payload);
        ArrayList<String> authzIDs = new ArrayList<String>();
        logger.info("Generating authorization for each identifiers");
        for (ACMEIdentifier identifier : request.getIdentifiers()) {
            boolean wildcard;
            String type = identifier.getType();
            String value = identifier.getValue();
            logger.info("Identifier " + (String)type + ": " + value);
            ValidationResult r = ACMEIdentifierValidator.validateSyntax(identifier);
            if (!r.isOK()) {
                this.throwError(Response.Status.BAD_REQUEST, r.getError());
            }
            engine.getPolicy().validateIdentifier(identifier);
            if ("dns".equals(type) && value.startsWith("*.")) {
                wildcard = true;
                value = value.substring(2);
            } else {
                wildcard = false;
            }
            identifier = new ACMEIdentifier();
            identifier.setType(type);
            identifier.setValue(value);
            String authzID = engine.randomAlphanumeric(10);
            logger.info("- authorization ID: " + authzID);
            ACMEAuthorization authorization = new ACMEAuthorization();
            authorization.setID(authzID);
            authorization.setCreationTime(currentTime);
            authorization.setIdentifier(identifier);
            authorization.setWildcard(Boolean.valueOf(wildcard));
            authorization.setStatus("pending");
            Date expirationTime = engine.getPolicy().getPendingAuthorizationExpirationTime(currentTime);
            authorization.setExpirationTime(expirationTime);
            engine.addAuthorization(account, authorization);
            authzIDs.add(authzID);
        }
        String orderID = engine.randomAlphanumeric(10);
        logger.info("Order ID: " + orderID);
        ACMEOrder order = new ACMEOrder();
        order.setID(orderID);
        order.setCreationTime(currentTime);
        order.setIdentifiers(request.getIdentifiers());
        order.setNotBefore(request.getNotBefore());
        order.setNotAfter(request.getNotAfter());
        order.setAuthzIDs(authzIDs.toArray(new String[authzIDs.size()]));
        order.setStatus("pending");
        Date expirationTime = engine.getPolicy().getPendingOrderExpirationTime(currentTime);
        order.setExpirationTime(expirationTime);
        engine.addOrder(account, order);
        ArrayList<URI> authzURLs = new ArrayList<URI>();
        for (String authzID : authzIDs) {
            URI authzURI = this.uriInfo.getBaseUriBuilder().path("authz").path(authzID).build(new Object[0]);
            authzURLs.add(authzURI);
        }
        order.setAuthorizations(authzURLs.toArray(new URI[authzURLs.size()]));
        URI finalizeURL = this.uriInfo.getBaseUriBuilder().path("order").path(orderID).path("finalize").build(new Object[0]);
        order.setFinalize(finalizeURL);
        URI orderURL = this.uriInfo.getBaseUriBuilder().path("order").path(orderID).build(new Object[0]);
        Response.ResponseBuilder builder = Response.created((URI)orderURL);
        ACMENonce nonce = engine.createNonce();
        builder.header("Replay-Nonce", (Object)nonce.getID());
        URI directoryURL = this.uriInfo.getBaseUriBuilder().path("directory").build(new Object[0]);
        builder.link(directoryURL, "index");
        builder.entity((Object)order);
        return builder.build();
    }
}

