/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Optional;
import java.util.Properties;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.acme.server.ACMEEngineConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ACMEEngineConfigFileSource
extends ACMEEngineConfigSource
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(ACMEEngine.class);
    String filename;
    boolean monitor = true;
    Thread monitorThread = null;
    Optional<Boolean> cacheEnabled = Optional.empty();
    Optional<Boolean> cacheWildcard = Optional.empty();

    ACMEEngineConfigFileSource() {
    }

    @Override
    public void init(Properties cfg) throws Exception {
        this.filename = cfg.getProperty("engine.filename");
        if (null == this.filename) {
            throw new IllegalArgumentException("'engine.filename' parameter must not be null");
        }
        this.loadFile();
        this.monitor = true;
        this.monitorThread = new Thread((Runnable)this, "ACMEEngineConfigFileSource");
        this.monitorThread.start();
    }

    void loadFile() throws IOException {
        Optional<Boolean> v;
        Boolean enabled = true;
        Boolean wildcard = true;
        File f = new File(this.filename);
        if (f.exists()) {
            Properties props = new Properties();
            try (FileReader reader = new FileReader(f);){
                props.load(reader);
            }
            String s = props.getProperty("enabled");
            if (s != null) {
                enabled = !"0".equals(s) && !"false".equalsIgnoreCase(s);
            }
            if ((s = props.getProperty("policy.wildcard")) != null) {
                wildcard = !"0".equals(s) && !"false".equalsIgnoreCase(s);
            }
        }
        if (!this.cacheEnabled.equals(v = Optional.of(enabled))) {
            this.enabledConsumer.accept(enabled);
            this.cacheEnabled = v;
        }
        if (!this.cacheWildcard.equals(v = Optional.of(wildcard))) {
            this.wildcardConsumer.accept(wildcard);
            this.cacheWildcard = v;
        }
    }

    @Override
    public void run() {
        Path path = FileSystems.getDefault().getPath(this.filename, new String[0]);
        int delay_ms = 0;
        while (this.monitor) {
            if (delay_ms > 0) {
                try {
                    logger.info("ACMEEngineConfigSource: sleeping for " + delay_ms + "ms");
                    Thread.sleep(delay_ms);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    this.loadFile();
                }
                catch (Throwable e) {
                    logger.warn("ACMEEngineConfigSource: Unable to load " + this.filename + ": " + e.getMessage());
                }
            }
            try (WatchService watchService = FileSystems.getDefault().newWatchService();){
                WatchKey wk;
                path.getParent().register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
                logger.info("ACMEEngineConfigSource: watching " + this.filename);
                delay_ms = 0;
                do {
                    logger.debug("ACMEEngineConfigSource: something happened");
                    wk = watchService.take();
                    for (WatchEvent<?> event : wk.pollEvents()) {
                        if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY && event.kind() != StandardWatchEventKinds.ENTRY_CREATE || !(event.context() instanceof Path) || !((Path)event.context()).endsWith(path.getFileName())) continue;
                        logger.debug("ACMEEngineConfigSource: file modified");
                        Thread.sleep(1000L);
                        this.loadFile();
                    }
                } while (wk.reset());
                logger.warn("ACMEEngineConfigSource: watch key could not be reset");
            }
            catch (InterruptedException e) {
                logger.info("ACMEEngineConfigSource: file monitoring interrupted");
            }
            catch (Throwable e) {
                logger.error("ACMEEngineConfigFileSource: caught exception while monitoring file", e);
            }
            if (delay_ms == 0) {
                delay_ms = 1000;
                continue;
            }
            delay_ms = Math.min(delay_ms * 2, 300000);
        }
        logger.info("ACMEConfigFileSource: watch thread exiting");
        this.monitorThread = null;
    }

    @Override
    public void shutdown() {
        this.monitor = false;
        if (this.monitorThread != null) {
            logger.info("ACMEEngineConfigSource.shutdown(): interrupting monitor thread");
            this.monitorThread.interrupt();
            this.monitorThread = null;
        }
    }
}

