/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.issuer;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.NotImplementedException;
import org.dogtagpki.acme.ACMEError;
import org.dogtagpki.acme.ACMERevocation;
import org.dogtagpki.acme.issuer.ACMEIssuerConfig;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;

public class ACMEIssuer {
    protected ACMEIssuerConfig config;

    public ACMEIssuerConfig getConfig() {
        return this.config;
    }

    public void setConfig(ACMEIssuerConfig config) {
        this.config = config;
    }

    public void init() throws Exception {
    }

    public void close() throws Exception {
    }

    public String getCertificateID(X509Certificate cert) throws Exception {
        BigInteger serialNumber = cert.getSerialNumber();
        return Base64.encodeBase64URLSafeString((byte[])serialNumber.toByteArray());
    }

    public X509Certificate generateCertificate(PKCS10 pkcs10) throws Exception {
        throw new NotImplementedException("ACMEIssuer.generateCertificate() must be overridden by specific implementation");
    }

    public String issueCertificate(PKCS10 pkcs10) throws Exception {
        X509Certificate cert = this.generateCertificate(pkcs10);
        return this.getCertificateID(cert);
    }

    public String getCertificateChain(String certID) throws Exception {
        throw new NotImplementedException("ACMEIssuer.getCertificateChain() must be overridden by specific implementation");
    }

    public void revokeCertificate(ACMERevocation revocation) throws Exception {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED);
        builder.type("application/problem+json");
        ACMEError error = new ACMEError();
        error.setType("urn:ietf:params:acme:error:unsupported");
        error.setDetail("Certificate revocation not supported");
        builder.entity((Object)error);
        throw new WebApplicationException(builder.build());
    }
}

