/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.est;

import com.netscape.cms.servlet.base.PKIService;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@PreMatching
public class HandleBadAcceptHeaderRequestFilter
implements ContainerRequestFilter {
    private static Logger logger = LoggerFactory.getLogger(HandleBadAcceptHeaderRequestFilter.class);
    private static List<MediaType> RESPONSE_TYPES = Arrays.asList(MediaType.valueOf((String)"application/pkcs7-mime"), MediaType.valueOf((String)"multipart/mixed"), MediaType.valueOf((String)"application/csrattrs"));

    public void filter(ContainerRequestContext requestContext) {
        logger.debug("HandleBadAcceptHeaderRequestFilter: inspecting request");
        List acceptTypes = requestContext.getAcceptableMediaTypes();
        MediaType match = PKIService.resolveFormat((List)acceptTypes, RESPONSE_TYPES);
        if (match == null) {
            logger.info("HandleBadAcceptHeaderRequestFilter: no matching Accept header; removing it and proceeding");
            requestContext.getHeaders().remove((Object)"Accept");
        }
    }
}

