/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cms.servlet.base.PKIService;
import com.netscape.cmscore.apps.CMS;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.dogtagpki.common.Info;
import org.dogtagpki.common.InfoResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoService
extends PKIService
implements InfoResource {
    private static Logger logger = LoggerFactory.getLogger(InfoService.class);

    public Response getInfo() throws Exception {
        HttpSession session = this.servletRequest.getSession();
        logger.debug("InfoService.getInfo(): session: " + session.getId());
        Info info = new Info();
        boolean bannerDisplayed = session.getAttribute("bannerDisplayed") != null;
        boolean bannerEnabled = InfoService.isBannerEnabled();
        if (!bannerDisplayed && bannerEnabled) {
            String banner = InfoService.getBanner();
            info.setBanner(banner);
            try {
                String jsonInfo = info.toJSON();
                info = (Info)JSONSerializer.fromJSON((String)jsonInfo, Info.class);
            }
            catch (Exception e) {
                logger.error("InfoService: Invalid access banner: " + e.getMessage(), (Throwable)e);
                throw new PKIException("Invalid access banner: " + e.getMessage(), (Throwable)e);
            }
        }
        info.setName(CMS.getProductName());
        info.setVersion(CMS.getProductVersion());
        return this.createOKResponse(info);
    }
}

