/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.rest;

import com.netscape.ca.CASigningUnit;
import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.system.KRAConnectorInfo;
import com.netscape.cms.servlet.admin.KRAConnectorProcessor;
import com.netscape.cms.servlet.base.PKIService;
import java.security.cert.X509Certificate;
import javax.ws.rs.core.Response;
import org.dogtagpki.ca.CASystemCertResource;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.pkcs.ContentInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.pkcs.SignerInfo;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CASystemCertService
extends PKIService
implements CASystemCertResource {
    public static Logger logger = LoggerFactory.getLogger(CASystemCertService.class);

    public Response getSigningCert() throws Exception {
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        CASigningUnit su = ca.getSigningUnit();
        org.mozilla.jss.crypto.X509Certificate signingCert = su.getCert();
        X509CertImpl cert = new X509CertImpl(signingCert.getEncoded());
        X509Certificate[] certChain = engine.getCertChain((X509Certificate)cert);
        PKCS7 pkcs7 = new PKCS7(new AlgorithmId[0], new ContentInfo(new byte[0]), certChain, new SignerInfo[0]);
        CertData certData = CertData.fromCertChain((PKCS7)pkcs7);
        return this.sendConditionalGetResponse(1000, certData, this.request);
    }

    public Response getTransportCert() throws Exception {
        CAEngine engine = CAEngine.getInstance();
        KRAConnectorProcessor processor = new KRAConnectorProcessor(this.getLocale(this.headers));
        processor.setCMSEngine(engine);
        processor.init();
        KRAConnectorInfo info = processor.getConnectorInfo();
        String encodedCert = info.getTransportCert();
        byte[] bytes = Utils.base64decode((String)encodedCert);
        X509CertImpl cert = new X509CertImpl(bytes);
        X509Certificate[] certChain = engine.getCertChain((X509Certificate)cert);
        PKCS7 pkcs7 = new PKCS7(new AlgorithmId[0], new ContentInfo(new byte[0]), certChain, new SignerInfo[0]);
        CertData certData = CertData.fromCertChain((PKCS7)pkcs7);
        return this.sendConditionalGetResponse(1000, certData, this.request);
    }
}

