/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.constraints;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.util.Vector;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.provider.DSAPublicKey;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSAKeyConstraints
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(DSAKeyConstraints.class);
    private int mMinSize;
    private int mMaxSize;
    private static final int INCREMENT = 64;
    private static final int DEF_MIN_SIZE = 512;
    private static final int DEF_MAX_SIZE = 1024;
    private static final String DSA = "DSA";
    private static final String PROP_MIN_SIZE = "minSize";
    private static final String PROP_MAX_SIZE = "maxSize";
    private static final Vector<String> defConfParams = new Vector();
    private ConfigStore mConfig;

    public DSAKeyConstraints() {
        this.NAME = "DSAKeyConstraints";
        this.DESC = "Enforces DSA Key Constraints.";
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"minSize;number;Minimum key size", "maxSize;number;Maximum key size", "HELP_TOKEN;configuration-policyrules-dsakeyconstraints", "HELP_TEXT;Rejects request if DSA key size is out of range"};
        return params;
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EPolicyException {
        this.mConfig = config;
        try {
            this.mMinSize = config.getInteger(PROP_MIN_SIZE, 512);
            this.mMaxSize = config.getInteger(PROP_MAX_SIZE, 1024);
            if (this.mMaxSize > 1024) {
                String msg = "cannot be more than 1024";
                logger.error("maxSize " + msg);
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{PROP_MAX_SIZE, msg}));
            }
            if (this.mMinSize < 512) {
                String msg = "cannot be less than 512";
                logger.error("minSize " + msg);
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{PROP_MIN_SIZE, msg}));
            }
            if (this.mMaxSize % 64 != 0) {
                String msg = "must be in increments of 64";
                logger.error("maxSize " + msg);
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{PROP_MIN_SIZE, msg}));
            }
            if (this.mMaxSize % 64 != 0) {
                String msg = "must be in increments of 64";
                logger.error("minSize " + msg);
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{PROP_MIN_SIZE, msg}));
            }
            config.putInteger(PROP_MIN_SIZE, this.mMinSize);
            config.putInteger(PROP_MAX_SIZE, this.mMaxSize);
        }
        catch (Exception e) {
            throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_INVALID_POLICY_CONFIG", (String[])new String[]{this.getInstanceName(), e.toString()}));
        }
    }

    public PolicyResult apply(Request req) {
        PolicyResult result = PolicyResult.ACCEPTED;
        try {
            X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
            if (ci == null || ci[0] == null) {
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[]{this.NAME}), "");
                return PolicyResult.REJECTED;
            }
            for (int i = 0; i < ci.length; ++i) {
                CertificateX509Key certKey = (CertificateX509Key)ci[i].get("key");
                X509Key key = (X509Key)certKey.get("value");
                String alg = key.getAlgorithmId().toString();
                if (!alg.equalsIgnoreCase(DSA)) continue;
                DSAPublicKey dsaKey = new DSAPublicKey(key.getEncoded());
                DSAParams keyParams = dsaKey.getParams();
                if (keyParams == null) {
                    this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_KEY_PARAMS", (String[])new String[]{this.getInstanceName(), String.valueOf(i + 1)}), "");
                    return PolicyResult.REJECTED;
                }
                BigInteger p = keyParams.getP();
                int len = p.bitLength();
                if (len >= this.mMinSize && len <= this.mMaxSize && len % 64 == 0) continue;
                String[] parms = new String[]{this.getInstanceName(), String.valueOf(len), String.valueOf(this.mMinSize), String.valueOf(this.mMaxSize), String.valueOf(64)};
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_KEY_SIZE_VIOLATION_1", (String[])parms), "");
                return PolicyResult.REJECTED;
            }
        }
        catch (Exception e) {
            String[] params = new String[]{this.getInstanceName(), e.toString()};
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])params), "");
            result = PolicyResult.REJECTED;
        }
        return result;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> confParams = new Vector<String>();
        try {
            confParams.addElement("minSize=" + this.mConfig.getInteger(PROP_MIN_SIZE, 512));
            confParams.addElement("maxSize=" + this.mConfig.getInteger(PROP_MAX_SIZE, 1024));
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        return confParams;
    }

    public Vector<String> getDefaultParams() {
        return defConfParams;
    }

    static {
        defConfParams.addElement("minSize=512");
        defConfParams.addElement("maxSize=1024");
    }
}

