/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldap;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.publish.Mapper;
import com.netscape.certsrv.publish.MapperPlugin;
import com.netscape.certsrv.publish.MapperProxy;
import com.netscape.certsrv.publish.Publisher;
import com.netscape.certsrv.publish.PublisherPlugin;
import com.netscape.certsrv.publish.PublisherProxy;
import com.netscape.certsrv.publish.RulePlugin;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldap.LdapConnModule;
import com.netscape.cmscore.ldap.LdapExpression;
import com.netscape.cmscore.ldap.LdapRule;
import com.netscape.cmscore.ldap.PublishingConfig;
import com.netscape.cmscore.ldap.PublishingMapperConfig;
import com.netscape.cmscore.ldap.PublishingPublisherConfig;
import com.netscape.cmscore.ldap.PublishingRuleConfig;
import com.netscape.cmscore.request.Request;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PublisherProcessor {
    public static Logger logger = LoggerFactory.getLogger(PublisherProcessor.class);
    public static final String PROP_LDAP_PUBLISH_SUBSTORE = "ldappublish";
    public static final String PROP_QUEUE_PUBLISH_SUBSTORE = "queue";
    public static final String PROP_CLASS = "class";
    public static final String PROP_IMPL = "impl";
    public static final String PROP_PLUGIN = "pluginName";
    public static final String PROP_INSTANCE = "instance";
    public static final String PROP_ENABLE = "enable";
    public static final String PROP_LDAP = "ldap";
    public Hashtable<String, PublisherPlugin> mPublisherPlugins = new Hashtable();
    public Hashtable<String, PublisherProxy> mPublisherInsts = new Hashtable();
    public Hashtable<String, MapperPlugin> mMapperPlugins = new Hashtable();
    public Hashtable<String, MapperProxy> mMapperInsts = new Hashtable();
    public Hashtable<String, RulePlugin> mRulePlugins = new Hashtable();
    public Hashtable<String, LdapRule> mRuleInsts = new Hashtable();
    protected LdapConnModule mLdapConnModule;
    protected PublishingConfig mConfig;
    protected ConfigStore mLdapConfig;
    protected String mId;
    protected RequestListener requestListener;
    protected boolean mInited;

    public PublisherProcessor(String id) {
        this.mId = id;
    }

    public String getId() {
        return this.mId;
    }

    public void setId(String id) {
        this.mId = id;
    }

    public PublishingConfig getConfigStore() {
        return this.mConfig;
    }

    public RequestListener getRequestListener() {
        return this.requestListener;
    }

    public void setRequestListener(RequestListener requestListener) {
        this.requestListener = requestListener;
    }

    public void init(PublishingConfig config) throws EBaseException {
        MapperPlugin plugin;
        this.mConfig = config;
        PublishingPublisherConfig publisherConfig = config.getPublisherConfig();
        ConfigStore c = publisherConfig.getSubStore(PROP_IMPL, ConfigStore.class);
        Enumeration mImpls = c.getSubStoreNames().elements();
        while (mImpls.hasMoreElements()) {
            String id = (String)mImpls.nextElement();
            logger.info("PublisherProcessor: Loading publisher plugin " + id);
            String pluginPath = c.getString(id + ".class");
            PublisherPlugin plugin2 = new PublisherPlugin(id, pluginPath);
            this.mPublisherPlugins.put(id, plugin2);
        }
        c = publisherConfig.getSubStore(PROP_INSTANCE, ConfigStore.class);
        Enumeration instances = c.getSubStoreNames().elements();
        while (instances.hasMoreElements()) {
            String insName = (String)instances.nextElement();
            logger.info("PublisherProcessor: Loading publisher instance " + insName);
            String implName = c.getString(insName + ".pluginName");
            PublisherPlugin plugin3 = this.mPublisherPlugins.get(implName);
            if (plugin3 == null) {
                logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_PLUGIN_NOT_FIND", (Object[])new Object[]{implName}));
                throw new ELdapException(implName);
            }
            String className = plugin3.getClassPath();
            boolean isEnable = false;
            Publisher publisherInst = null;
            try {
                publisherInst = (Publisher)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ConfigStore pConfig = c.getSubStore(insName, ConfigStore.class);
                publisherInst.init(pConfig);
                isEnable = true;
            }
            catch (ClassNotFoundException e) {
                logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_PUBLISHER_INIT_FAILED", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}));
            }
            catch (IllegalAccessException e) {
                logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_PUBLISHER_INIT_FAILED", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}));
            }
            catch (InstantiationException e) {
                logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_PUBLISHER_INIT_FAILED", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}));
            }
            catch (Throwable e) {
                logger.warn("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_SKIP_PUBLISHER", (Object[])new Object[]{insName, e.toString()}), e);
            }
            if (publisherInst == null) {
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}));
            }
            if (insName == null) {
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{insName}));
            }
            this.mPublisherInsts.put(insName, new PublisherProxy(isEnable, publisherInst));
        }
        PublishingMapperConfig mapperConfig = config.getMapperConfig();
        c = mapperConfig.getSubStore(PROP_IMPL, ConfigStore.class);
        mImpls = c.getSubStoreNames().elements();
        while (mImpls.hasMoreElements()) {
            String id = (String)mImpls.nextElement();
            logger.info("PublisherProcessor: Loading mapper plugin " + id);
            String pluginPath = c.getString(id + ".class");
            plugin = new MapperPlugin(id, pluginPath);
            this.mMapperPlugins.put(id, plugin);
        }
        c = mapperConfig.getSubStore(PROP_INSTANCE, ConfigStore.class);
        instances = c.getSubStoreNames().elements();
        while (instances.hasMoreElements()) {
            String insName = (String)instances.nextElement();
            logger.info("PublisherProcessor: Loading mapper instance " + insName);
            String implName = c.getString(insName + ".pluginName");
            plugin = this.mMapperPlugins.get(implName);
            if (plugin == null) {
                logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_MAPPER_NOT_FIND", (Object[])new Object[]{implName}));
                throw new ELdapException(implName);
            }
            String className = plugin.getClassPath();
            boolean isEnable = false;
            Mapper mapperInst = null;
            try {
                mapperInst = (Mapper)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ConfigStore mConfig = c.getSubStore(insName, ConfigStore.class);
                mapperInst.init(mConfig);
                isEnable = true;
            }
            catch (ClassNotFoundException e) {
                logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_PUBLISHER_INIT_FAILED", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}));
            }
            catch (IllegalAccessException e) {
                logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_PUBLISHER_INIT_FAILED", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}));
            }
            catch (InstantiationException e) {
                logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_PUBLISHER_INIT_FAILED", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}));
            }
            catch (Throwable e) {
                logger.warn("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_SKIP_MAPPER", (Object[])new Object[]{insName, e.toString()}), e);
            }
            if (mapperInst == null) {
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}));
            }
            this.mMapperInsts.put(insName, new MapperProxy(isEnable, mapperInst));
        }
        PublishingRuleConfig ruleConfig = config.getRuleConfig();
        c = ruleConfig.getSubStore(PROP_IMPL, ConfigStore.class);
        mImpls = c.getSubStoreNames().elements();
        while (mImpls.hasMoreElements()) {
            String id = (String)mImpls.nextElement();
            logger.info("PublisherProcessor: Loading rule plugin " + id);
            String pluginPath = c.getString(id + ".class");
            RulePlugin plugin4 = new RulePlugin(id, pluginPath);
            this.mRulePlugins.put(id, plugin4);
        }
        c = ruleConfig.getSubStore(PROP_INSTANCE, ConfigStore.class);
        instances = c.getSubStoreNames().elements();
        while (instances.hasMoreElements()) {
            String insName = (String)instances.nextElement();
            logger.info("PublisherProcessor: Loading rule instance " + insName);
            String implName = c.getString(insName + ".pluginName");
            RulePlugin plugin5 = this.mRulePlugins.get(implName);
            if (plugin5 == null) {
                logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_RULE_NOT_FIND", (Object[])new Object[]{implName}));
                throw new ELdapException(implName);
            }
            String className = plugin5.getClassPath();
            ConfigStore mConfig = null;
            try {
                LdapRule ruleInst = null;
                ruleInst = (LdapRule)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                mConfig = c.getSubStore(insName, ConfigStore.class);
                ruleInst.init(this.mMapperInsts, this.mPublisherInsts, mConfig);
                ruleInst.setInstanceName(insName);
                this.mRuleInsts.put(insName, ruleInst);
            }
            catch (ClassNotFoundException e) {
                logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_PUBLISHER_INIT_FAILED", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}));
            }
            catch (IllegalAccessException e) {
                logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_PUBLISHER_INIT_FAILED", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}));
            }
            catch (InstantiationException e) {
                logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_PUBLISHER_INIT_FAILED", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}));
            }
            catch (Throwable e) {
                if (mConfig == null) {
                    throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}));
                }
                mConfig.putString(PROP_ENABLE, "false");
                logger.warn("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_SKIP_RULE", (Object[])new Object[]{insName, e.toString()}), e);
            }
        }
        this.startup();
        this.mInited = true;
    }

    public LdapConnModule getLdapConnModule() {
        return this.mLdapConnModule;
    }

    public void setLdapConnModule(LdapConnModule m) {
        this.mLdapConnModule = m;
    }

    private void initLdapConn(ConfigStore ldapConfig) throws EBaseException {
        ConfigStore c = ldapConfig;
        try {
            if (c == null || c.size() <= 0) {
                logger.error("PublisherProcessor: No Ldap Module configuration found");
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_LDAP_PUBLISH_CONFIG_FOUND", (String[])new String[0]));
            }
            this.mLdapConnModule = new LdapConnModule();
            this.mLdapConnModule.init(c);
            logger.debug("LdapPublishing connection inited");
        }
        catch (ELdapException e) {
            logger.error("PublisherProcessor: Ldap Publishing Module failed: " + e.getMessage(), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INIT_LDAP_PUBLISH_MODULE_FAILED", (String[])new String[]{e.toString()}));
        }
    }

    public void startup() throws EBaseException {
        logger.debug("PublisherProcessor: startup()");
        this.mLdapConfig = this.mConfig.getSubStore(PROP_LDAP_PUBLISH_SUBSTORE, ConfigStore.class);
        if (this.mLdapConfig.getBoolean(PROP_ENABLE, false)) {
            logger.debug("PublisherProcessor: about to initLdapConn");
            this.initLdapConn(this.mLdapConfig);
        } else {
            logger.debug("No LdapPublishing enabled");
        }
    }

    public void shutdown() {
        logger.debug("Shuting down publishing.");
        try {
            if (this.mLdapConnModule != null) {
                this.mLdapConnModule.getLdapConnFactory().reset();
            }
        }
        catch (ELdapException e) {
            logger.warn("Unable to shutdown publishing: " + e.getMessage(), (Throwable)e);
        }
    }

    public Hashtable<String, RulePlugin> getRulePlugins() {
        return this.mRulePlugins;
    }

    public Hashtable<String, LdapRule> getRuleInsts() {
        return this.mRuleInsts;
    }

    public Hashtable<String, MapperPlugin> getMapperPlugins() {
        return this.mMapperPlugins;
    }

    public Hashtable<String, PublisherPlugin> getPublisherPlugins() {
        return this.mPublisherPlugins;
    }

    public Hashtable<String, MapperProxy> getMapperInsts() {
        return this.mMapperInsts;
    }

    public Hashtable<String, PublisherProxy> getPublisherInsts() {
        return this.mPublisherInsts;
    }

    public Enumeration<LdapRule> getRules(String publishingType) {
        logger.info("PublisherProcessor: Getting " + publishingType + " publishing rules");
        Vector<LdapRule> rules = new Vector<LdapRule>();
        Enumeration<String> e = this.mRuleInsts.keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            if (name == null) {
                logger.warn("Missing publishing rule name");
                return null;
            }
            logger.info("PublisherProcessor: - name: " + name);
            LdapRule rule = this.mRuleInsts.get(name);
            logger.info("PublisherProcessor:   enabled: " + rule.enabled());
            if (!rule.enabled()) continue;
            logger.info("PublisherProcessor:   type: " + rule.getType());
            if (!publishingType.equals(rule.getType())) continue;
            LdapExpression exp = rule.getPredicate();
            logger.info("PublisherProcessor:   predicate: " + exp);
            try {
                SessionContext sc = SessionContext.getContext();
                if (exp != null && !exp.evaluate(sc)) {
                    logger.info("PublisherProcessor:   predicate => false");
                    continue;
                }
            }
            catch (Exception ex) {
                logger.warn("PublisherProcessor: " + ex.getMessage(), (Throwable)ex);
            }
            rules.addElement(rule);
        }
        return rules.elements();
    }

    public Enumeration<LdapRule> getRules(String publishingType, Request req) {
        if (req == null) {
            return this.getRules(publishingType);
        }
        logger.info("PublisherProcessor: Getting " + publishingType + " publishing rules for request " + req.getRequestId().toHexString());
        Vector<LdapRule> rules = new Vector<LdapRule>();
        Enumeration<LdapRule> e = this.mRuleInsts.elements();
        while (e.hasMoreElements()) {
            LdapRule rule = e.nextElement();
            logger.info("PublisherProcessor: - name: " + rule.getInstanceName());
            logger.debug("PublisherProcessor:   enabled: " + rule.enabled());
            if (!rule.enabled()) {
                logger.info("PublisherProcessor:   rule disabled");
                continue;
            }
            logger.debug("PublisherProcessor:   type: " + rule.getType());
            if (!publishingType.equals(rule.getType())) {
                logger.info("PublisherProcessor:   type doesn't match");
                continue;
            }
            LdapExpression exp = rule.getPredicate();
            logger.debug("PublisherProcessor:   predicate: " + exp);
            try {
                if (exp != null && !exp.evaluate(req)) {
                    logger.info("PublisherProcessor:   predicate => false");
                    continue;
                }
            }
            catch (Exception ex) {
                logger.warn("PublisherProcessor: " + ex.getMessage(), (Throwable)ex);
            }
            rules.addElement(rule);
        }
        return rules.elements();
    }

    public Vector<String> getMapperDefaultParams(String implName) throws ELdapException {
        MapperPlugin plugin = this.mMapperPlugins.get(implName);
        if (plugin == null) {
            logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_MAPPER_NOT_FIND", (Object[])new Object[]{implName}));
            throw new ELdapException(implName);
        }
        Mapper mapperInst = null;
        String className = plugin.getClassPath();
        try {
            mapperInst = (Mapper)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Vector v = mapperInst.getDefaultParams();
            return v;
        }
        catch (Exception e) {
            logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_NO_NEW_MAPPER", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}), (Throwable)e);
        }
    }

    public Vector<String> getMapperInstanceParams(String insName) throws ELdapException {
        Mapper mapperInst = null;
        MapperProxy proxy = this.mMapperInsts.get(insName);
        if (proxy == null) {
            return null;
        }
        mapperInst = proxy.getMapper();
        if (mapperInst == null) {
            return null;
        }
        Vector v = mapperInst.getInstanceParams();
        return v;
    }

    public Vector<String> getPublisherDefaultParams(String implName) throws ELdapException {
        PublisherPlugin plugin = this.mPublisherPlugins.get(implName);
        if (plugin == null) {
            logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_PLUGIN_NOT_FIND", (Object[])new Object[]{implName}));
            throw new ELdapException(implName);
        }
        Publisher publisherInst = null;
        String className = plugin.getClassPath();
        try {
            publisherInst = (Publisher)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Vector v = publisherInst.getDefaultParams();
            return v;
        }
        catch (Exception e) {
            logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_NO_NEW_PUBLISHER", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}), (Throwable)e);
        }
    }

    public boolean isMapperInstanceEnable(String insName) {
        MapperProxy proxy = this.mMapperInsts.get(insName);
        if (proxy == null) {
            return false;
        }
        return proxy.isEnable();
    }

    public Mapper getActiveMapperInstance(String insName) {
        MapperProxy proxy = this.mMapperInsts.get(insName);
        if (proxy == null) {
            return null;
        }
        return proxy.isEnable() ? proxy.getMapper() : null;
    }

    public Mapper getMapperInstance(String insName) {
        MapperProxy proxy = this.mMapperInsts.get(insName);
        if (proxy == null) {
            return null;
        }
        return proxy.getMapper();
    }

    public boolean isPublisherInstanceEnable(String insName) {
        PublisherProxy proxy = this.mPublisherInsts.get(insName);
        if (proxy == null) {
            return false;
        }
        return proxy.isEnable();
    }

    public Publisher getActivePublisherInstance(String insName) {
        PublisherProxy proxy = this.mPublisherInsts.get(insName);
        if (proxy == null) {
            return null;
        }
        return proxy.isEnable() ? proxy.getPublisher() : null;
    }

    public Publisher getPublisherInstance(String insName) {
        PublisherProxy proxy = this.mPublisherInsts.get(insName);
        if (proxy == null) {
            return null;
        }
        return proxy.getPublisher();
    }

    public Vector<String> getPublisherInstanceParams(String insName) throws ELdapException {
        Publisher publisherInst = this.getPublisherInstance(insName);
        if (publisherInst == null) {
            return null;
        }
        Vector v = publisherInst.getInstanceParams();
        return v;
    }

    public Vector<String> getRuleDefaultParams(String implName) throws ELdapException {
        RulePlugin plugin = this.mRulePlugins.get(implName);
        if (plugin == null) {
            logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_RULE_NOT_FIND", (Object[])new Object[]{implName}));
            throw new ELdapException(implName);
        }
        LdapRule ruleInst = null;
        String className = plugin.getClassPath();
        try {
            ruleInst = (LdapRule)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Vector<String> v = ruleInst.getDefaultParams();
            return v;
        }
        catch (Exception e) {
            logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_NO_NEW_RULE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}), (Throwable)e);
        }
    }

    public Vector<String> getRuleInstanceParams(String implName) throws ELdapException {
        RulePlugin plugin = this.mRulePlugins.get(implName);
        if (plugin == null) {
            logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_RULE_NOT_FIND", (Object[])new Object[]{implName}));
            throw new ELdapException(implName);
        }
        LdapRule ruleInst = null;
        String className = plugin.getClassPath();
        try {
            ruleInst = (LdapRule)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Vector<String> v = ruleInst.getInstanceParams();
            return v;
        }
        catch (Exception e) {
            logger.error("PublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_NO_NEW_RULE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className}), (Throwable)e);
        }
    }

    public boolean ldapEnabled() {
        try {
            return this.mInited && this.mLdapConfig.getBoolean(PROP_ENABLE, false);
        }
        catch (EBaseException e) {
            return false;
        }
    }
}

