/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldap;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.dbs.ModificationSet;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.publish.Mapper;
import com.netscape.certsrv.publish.Publisher;
import com.netscape.cms.publish.mappers.LdapCertSubjMap;
import com.netscape.cms.publish.publishers.FileBasedPublisher;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.ldap.LdapRule;
import com.netscape.cmscore.ldap.PublisherProcessor;
import com.netscape.cmscore.ldap.PublishingConfig;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestNotifier;
import java.math.BigInteger;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAPublisherProcessor
extends PublisherProcessor {
    public static Logger logger = LoggerFactory.getLogger(CAPublisherProcessor.class);
    public static final String PROP_LOCAL_CA = "cacert";
    public static final String PROP_LOCAL_CRL = "crl";
    public static final String PROP_CERTS = "certs";
    public static final String PROP_XCERT = "xcert";
    protected CertificateAuthority ca;
    private boolean createOwnDNEntry;

    public CAPublisherProcessor(String id) {
        super(id);
    }

    public CertificateAuthority getAuthority() {
        return this.ca;
    }

    public void init(CertificateAuthority ca, PublishingConfig config) throws EBaseException {
        this.ca = ca;
        this.createOwnDNEntry = config.getBoolean("createOwnDNEntry", false);
        super.init(config);
    }

    @Override
    public void startup() throws EBaseException {
        super.startup();
        CAEngine engine = CAEngine.getInstance();
        if (this.mConfig.isEnabled()) {
            ConfigStore queueConfig;
            if (this.requestListener != null) {
                engine.registerRequestListener(this.requestListener);
            }
            if ((queueConfig = this.mConfig.getSubStore("queue", ConfigStore.class)) != null) {
                logger.info("CAPublisherProcessor: Publishing queue:");
                boolean isPublishingQueueEnabled = queueConfig.getBoolean("enable", false);
                logger.info("CAPublisherProcessor: - enabled: " + isPublishingQueueEnabled);
                int publishingQueuePriorityLevel = queueConfig.getInteger("priorityLevel", 0);
                logger.info("CAPublisherProcessor: - priority level: " + publishingQueuePriorityLevel);
                int maxNumberOfPublishingThreads = queueConfig.getInteger("maxNumberOfThreads", 1);
                logger.info("CAPublisherProcessor: - max threads: " + maxNumberOfPublishingThreads);
                int publishingQueuePageSize = queueConfig.getInteger("pageSize", 100);
                logger.info("CAPublisherProcessor: - page size: " + publishingQueuePageSize);
                int savePublishingStatus = queueConfig.getInteger("saveStatus", 0);
                logger.info("CAPublisherProcessor: - save status: " + savePublishingStatus);
                RequestNotifier requestNotifier = engine.getRequestNotifier();
                requestNotifier.setPublishingQueue(isPublishingQueueEnabled, publishingQueuePriorityLevel, maxNumberOfPublishingThreads, publishingQueuePageSize, savePublishingStatus);
            }
        }
    }

    @Override
    public void shutdown() {
        logger.debug("Shuting down CA publishing");
        if (this.requestListener != null) {
            CAEngine engine = CAEngine.getInstance();
            engine.removeRequestListener(this.requestListener);
        }
        super.shutdown();
    }

    public void setPublishedFlag(BigInteger serialNo, boolean published) {
        try {
            CAEngine engine = CAEngine.getInstance();
            CertificateRepository certdb = engine.getCertificateRepository();
            CertRecord certRec = certdb.readCertificateRecord(serialNo);
            MetaInfo metaInfo = certRec.getMetaInfo();
            if (metaInfo == null) {
                metaInfo = new MetaInfo();
            }
            metaInfo.set("inLdapPublishDir", (Object)String.valueOf(published));
            ModificationSet modSet = new ModificationSet();
            modSet.add("certMetaInfo", 2, (Object)metaInfo);
            certdb.modifyCertificateRecord(serialNo, modSet);
        }
        catch (EBaseException e) {
            logger.warn("CAPublisherProcessor: Cannot mark cert 0x" + serialNo.toString(16) + " published as " + published + " in the ldap directory.");
            logger.warn("CAPublisherProcessor: Cert Record not found: " + e.getMessage(), (Throwable)e);
            logger.warn("CAPublisherProcessor: Don't be alarmed if it's a subordinate ca or clone's ca siging cert.");
            logger.warn("CAPublisherProcessor: Otherwise your internal db may be corrupted.");
        }
    }

    public void publishCACert(X509Certificate cert) throws ELdapException {
        boolean error = false;
        StringBuffer errorRule = new StringBuffer();
        if (!this.isCertPublishingEnabled()) {
            return;
        }
        logger.debug("PublishProcessor::publishCACert");
        Enumeration<LdapRule> rules = this.getRules(PROP_LOCAL_CA);
        if (rules == null || !rules.hasMoreElements()) {
            if (this.ca.isClone()) {
                logger.warn("CAPublisherProcessor: No rule is found for publishing: cacert in this clone.");
                return;
            }
            logger.warn(CMS.getLogMessage((String)"CMSCORE_LDAP_NO_RULE_FOUND", (Object[])new Object[]{PROP_LOCAL_CA}));
            return;
        }
        while (rules.hasMoreElements()) {
            LdapRule rule = rules.nextElement();
            if (rule == null) {
                logger.error("CAPublisherProcessor: Missing publishing rule");
                throw new ELdapException("Missing publishing rule");
            }
            logger.info("CAPublisherProcessor: publish certificate type=cacert rule=" + rule.getInstanceName() + " publisher=" + rule.getPublisher());
            try {
                Mapper mapper = null;
                String mapperName = rule.getMapper();
                if (mapperName != null && !mapperName.trim().equals("")) {
                    mapper = this.getActiveMapperInstance(mapperName);
                }
                this.publishNow(mapper, this.getActivePublisherInstance(rule.getPublisher()), null, cert);
                logger.info("CAPublisherProcessor: published certificate using rule " + rule.getInstanceName());
            }
            catch (Exception e) {
                logger.warn("CAPublisherProcessor::publishCACert returned error: " + e.getMessage(), (Throwable)e);
                error = true;
                errorRule.append(" " + rule.getInstanceName() + " error:" + e);
            }
        }
        if (error) {
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_PUBLISH_FAILED", (String[])new String[]{errorRule.toString()}));
        }
        this.setPublishedFlag(cert.getSerialNumber(), true);
    }

    public void unpublishCACert(X509Certificate cert) throws ELdapException {
        boolean error = false;
        StringBuffer errorRule = new StringBuffer();
        if (!this.isCertPublishingEnabled()) {
            return;
        }
        Enumeration<LdapRule> rules = this.getRules(PROP_LOCAL_CA);
        if (rules == null || !rules.hasMoreElements()) {
            if (this.ca.isClone()) {
                logger.warn("CAPublisherProcessor: No rule is found for unpublishing: cacert in this clone.");
                return;
            }
            logger.error("CAPublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_NO_UNPUBLISHING_RULE_FOUND", (Object[])new Object[]{PROP_LOCAL_CA}));
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_RULE_MATCHED", (String[])new String[]{PROP_LOCAL_CA}));
        }
        while (rules.hasMoreElements()) {
            LdapRule rule = rules.nextElement();
            if (rule == null) {
                logger.error("CAPublisherProcessor::unpublishCACert() - rule is null!");
                throw new ELdapException("rule is null");
            }
            try {
                logger.info("CAPublisherProcessor: unpublish certificate type=cacert rule=" + rule.getInstanceName() + " publisher=" + rule.getPublisher());
                Mapper mapper = null;
                String mapperName = rule.getMapper();
                if (mapperName != null && !mapperName.trim().equals("")) {
                    mapper = this.getActiveMapperInstance(mapperName);
                }
                this.unpublishNow(mapper, this.getActivePublisherInstance(rule.getPublisher()), null, cert);
                logger.warn("CAPublisherProcessor: unpublished certificate using rule " + rule.getInstanceName());
            }
            catch (Exception e) {
                logger.warn("CAPublisherProcessor: " + e.getMessage(), (Throwable)e);
                error = true;
                errorRule.append(" " + rule.getInstanceName());
            }
        }
        if (error) {
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_UNPUBLISH_FAILED", (String[])new String[]{errorRule.toString()}));
        }
        this.setPublishedFlag(cert.getSerialNumber(), false);
    }

    public void publishXCertPair(byte[] pair) throws ELdapException {
        Object errorRule = "";
        if (!this.isCertPublishingEnabled()) {
            return;
        }
        logger.debug("CAPublisherProcessor: in publishXCertPair()");
        Enumeration<LdapRule> rules = this.getRules(PROP_XCERT);
        if (rules == null || !rules.hasMoreElements()) {
            if (this.ca.isClone()) {
                logger.warn("CAPublisherProcessor: No rule is found for publishing: cacert in this clone.");
                return;
            }
            logger.error("CAPublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_NO_RULE_FOUND", (Object[])new Object[]{PROP_XCERT}));
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_RULE_MATCHED", (String[])new String[]{PROP_XCERT}));
        }
        while (rules.hasMoreElements()) {
            LdapRule rule = rules.nextElement();
            if (rule == null) {
                logger.error("CAPublisherProcessor: Missing publishing rule");
                throw new ELdapException("Missing publishing rule");
            }
            logger.info("CAPublisherProcessor: publish certificate type=xcert rule=" + rule.getInstanceName() + " publisher=" + rule.getPublisher());
            try {
                Mapper mapper = null;
                String mapperName = rule.getMapper();
                if (mapperName != null && !mapperName.trim().equals("")) {
                    mapper = this.getActiveMapperInstance(mapperName);
                }
                this.publishNow(mapper, this.getActivePublisherInstance(rule.getPublisher()), (Request)null, pair);
                logger.info("CAPublisherProcessor: published Xcertificates using rule " + rule.getInstanceName());
            }
            catch (Exception e) {
                logger.warn("CAPublisherProcessor: " + e.getMessage(), (Throwable)e);
                errorRule = (String)errorRule + " " + rule.getInstanceName() + " error:" + e;
                logger.warn("CAPublisherProcessor::publishXCertPair: error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void publishCert(X509Certificate cert, Request req) throws ELdapException {
        CertId certID = new CertId(cert.getSerialNumber());
        logger.info("CAPublisherProcessor: Publishing cert " + certID.toHexString());
        if (!this.isCertPublishingEnabled()) {
            logger.info("CAPublisherProcessor: Cert publishing disabled");
            return;
        }
        boolean error = false;
        StringBuffer errorRule = new StringBuffer();
        Enumeration<LdapRule> rules = this.getRules(PROP_CERTS, req);
        if (rules == null || !rules.hasMoreElements()) {
            logger.info("CAPublisherProcessor: No rules enabled");
            error = true;
            errorRule.append("No rules enabled");
        }
        while (rules != null && rules.hasMoreElements()) {
            LdapRule rule = rules.nextElement();
            logger.info("CAPublisherProcessor: Publishing cert with rule " + rule.getInstanceName());
            try {
                String publisherName = rule.getPublisher();
                logger.info("CAPublisherProcessor: - publisher: " + publisherName);
                Publisher p = this.getActivePublisherInstance(publisherName);
                String mapperName = rule.getMapper();
                logger.info("CAPublisherProcessor: - mapper: " + mapperName);
                Mapper m = null;
                if (mapperName != null) {
                    m = this.getActiveMapperInstance(mapperName);
                }
                this.publishNow(m, p, req, cert);
                logger.info("CAPublisherProcessor: Published cert using rule " + rule.getInstanceName());
            }
            catch (Exception e) {
                logger.warn("CAPublisherProcessor: " + e.getMessage(), (Throwable)e);
                error = true;
                errorRule.append(" " + rule.getInstanceName());
            }
        }
        if (error) {
            logger.error("PublishProcessor::publishCert : " + CMS.getUserMessage((String)"CMS_LDAP_PUBLISH_FAILED", (String[])new String[]{errorRule.toString()}));
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_PUBLISH_FAILED", (String[])new String[]{errorRule.toString()}));
        }
        this.setPublishedFlag(cert.getSerialNumber(), true);
    }

    public void unpublishCert(X509Certificate cert, Request req) throws ELdapException {
        CertId certID = new CertId(cert.getSerialNumber());
        logger.info("CAPublisherProcessor: Unpublishing cert " + certID.toHexString());
        if (!this.isCertPublishingEnabled()) {
            logger.info("CAPublisherProcessor: Cert publishing disabled");
            return;
        }
        boolean error = false;
        StringBuffer errorRule = new StringBuffer();
        Enumeration<LdapRule> rules = this.getRules(PROP_CERTS, req);
        if (rules == null || !rules.hasMoreElements()) {
            logger.error("CAPublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_NO_UNPUBLISHING_RULE_FOUND_FOR_REQUEST", (Object[])new Object[]{PROP_CERTS, req.getRequestId().toHexString()}));
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_RULE_MATCHED", (String[])new String[]{req.getRequestId().toString()}));
        }
        while (rules.hasMoreElements()) {
            LdapRule rule = rules.nextElement();
            if (rule == null) {
                logger.error("CAPublisherProcessor: Missing publishing rule");
                throw new ELdapException("Missing publishing rule");
            }
            try {
                logger.info("CAPublisherProcessor: Unpublishing cert (with request) type=certs rule=" + rule.getInstanceName() + " publisher=" + rule.getPublisher());
                Mapper mapper = null;
                String mapperName = rule.getMapper();
                if (mapperName != null && !mapperName.trim().equals("")) {
                    mapper = this.getActiveMapperInstance(mapperName);
                }
                this.unpublishNow(mapper, this.getActivePublisherInstance(rule.getPublisher()), req, cert);
                logger.info("CAPublisherProcessor: Unpublished cert using rule " + rule.getInstanceName());
            }
            catch (Exception e) {
                logger.warn("CAPublisherProcessor: " + e.getMessage(), (Throwable)e);
                error = true;
                errorRule.append(" " + rule.getInstanceName());
            }
        }
        if (error) {
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_UNPUBLISH_FAILED", (String[])new String[]{errorRule.toString()}));
        }
        this.setPublishedFlag(cert.getSerialNumber(), false);
    }

    public void publishCRL(X509CRLImpl crl, String crlIssuingPointId) throws ELdapException {
        if (!this.isCRLPublishingEnabled()) {
            return;
        }
        logger.info("CAPublisherProcessor: Publishing CRL " + crl.getCRLNumber() + " to " + crlIssuingPointId);
        boolean error = false;
        Object errorRule = "";
        Enumeration<LdapRule> rules = this.getRules(PROP_LOCAL_CRL);
        if (rules == null || !rules.hasMoreElements()) {
            logger.error("CAPublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_NO_RULE_FOR_CRL", (Object[])new Object[0]));
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_RULE_MATCHED", (String[])new String[]{PROP_LOCAL_CRL}));
        }
        LDAPConnection conn = null;
        String dn = null;
        try {
            if (this.mLdapConnModule != null) {
                conn = this.mLdapConnModule.getConn();
            }
            logger.info("CAPublisherProcessor: Publishing rules:");
            while (rules.hasMoreElements()) {
                LdapRule rule = rules.nextElement();
                logger.info("CAPublisherProcessor: - rule: " + rule.getInstanceName());
                Mapper mapper = null;
                dn = null;
                try {
                    String mapperName = rule.getMapper();
                    logger.info("CAPublisherProcessor:   mapper: " + mapperName);
                    if (mapperName != null && !mapperName.trim().equals("")) {
                        mapper = this.getActiveMapperInstance(mapperName);
                    }
                    if (mapper == null || mapper.getImplName().equals("NoMap")) {
                        dn = ((X500Name)crl.getIssuerDN()).toLdapDNString();
                    } else {
                        dn = mapper.map(conn, (Object)crl);
                        if (!this.createOwnDNEntry && dn == null) {
                            logger.error("CAPublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_MAPPER_NOT_MAP", (Object[])new Object[]{rule.getMapper()}));
                            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH", (String[])new String[]{crl.getIssuerDN().toString()}));
                        }
                    }
                    logger.info("CAPublisherProcessor: Publishing to " + dn);
                    String publisherName = rule.getPublisher();
                    logger.info("CAPublisherProcessor: - publisher: " + publisherName);
                    Publisher publisher = this.getActivePublisherInstance(publisherName);
                    if (publisher == null) continue;
                    if (publisher instanceof FileBasedPublisher) {
                        ((FileBasedPublisher)publisher).setIssuingPointId(crlIssuingPointId);
                    }
                    publisher.publish(conn, dn, (Object)crl);
                    logger.info("CAPublisherProcessor: Published CRL");
                }
                catch (Exception e) {
                    logger.warn("Unable to publish CRL to " + dn + ": " + e.getMessage(), (Throwable)e);
                    error = true;
                    errorRule = (String)errorRule + " " + rule.getInstanceName();
                }
            }
        }
        catch (ELdapException e) {
            logger.error("Error publishing CRL to " + dn + ": " + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (conn != null) {
                this.mLdapConnModule.returnConn(conn);
            }
        }
        if (error) {
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_PUBLISH_FAILED", (String[])new String[]{errorRule}));
        }
    }

    public void publishCRL(String dn, X509CRL crl) throws ELdapException {
        boolean error = false;
        Object errorRule = "";
        if (!this.isCRLPublishingEnabled()) {
            return;
        }
        Enumeration<LdapRule> rules = this.getRules(PROP_LOCAL_CRL);
        if (rules == null || !rules.hasMoreElements()) {
            logger.error("CAPublisherProcessor: " + CMS.getLogMessage((String)"CMSCORE_LDAP_NO_RULE_FOR_CRL", (Object[])new Object[0]));
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_RULE_MATCHED", (String[])new String[]{PROP_LOCAL_CRL}));
        }
        LDAPConnection conn = null;
        Publisher publisher = null;
        try {
            if (this.mLdapConnModule != null) {
                conn = this.mLdapConnModule.getConn();
            }
            while (rules.hasMoreElements()) {
                LdapRule rule = rules.nextElement();
                logger.info("CAPublisherProcessor: publish crl dn=" + dn + " rule=" + rule.getInstanceName() + " publisher=" + rule.getPublisher());
                try {
                    publisher = this.getActivePublisherInstance(rule.getPublisher());
                    if (publisher == null) continue;
                    publisher.publish(conn, dn, (Object)crl);
                    logger.info("CAPublisherProcessor: published crl using rule=" + rule.getInstanceName());
                }
                catch (Exception e) {
                    logger.warn("Error publishing CRL to " + dn + ": " + e.getMessage(), (Throwable)e);
                    error = true;
                    errorRule = (String)errorRule + " " + rule.getInstanceName();
                }
            }
        }
        catch (ELdapException e) {
            logger.error("Error publishing CRL to " + dn + ": " + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (conn != null) {
                this.mLdapConnModule.returnConn(conn);
            }
        }
        if (error) {
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_PUBLISH_FAILED", (String[])new String[]{errorRule}));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void publishNow(Mapper mapper, Publisher publisher, Request r, Object obj) throws ELdapException {
        if (!this.isCertPublishingEnabled()) {
            return;
        }
        logger.info("CAPublisherProcessor: Running publisher " + publisher.getImplName());
        LDAPConnection conn = null;
        try {
            X509Certificate cert;
            block17: {
                Object dirdn = null;
                if (mapper != null) {
                    logger.info("CAPublisherProcessor: LDAP connection module: " + this.mLdapConnModule);
                    if (this.mLdapConnModule != null) {
                        conn = this.mLdapConnModule.getConn();
                    }
                    try {
                        dirdn = mapper instanceof LdapCertSubjMap && ((LdapCertSubjMap)mapper).useAllEntries() ? ((LdapCertSubjMap)mapper).mapAll(conn, r, obj) : mapper.map(conn, r, obj);
                    }
                    catch (Throwable e1) {
                        logger.error("CAPublisherProcessor: " + e1.getMessage(), e1);
                        throw e1;
                    }
                }
                cert = (X509Certificate)obj;
                try {
                    if (dirdn instanceof Vector) {
                        Vector dirdnVector = (Vector)dirdn;
                        logger.info("CAPublisherProcessor: Dir DN:");
                        int n = dirdnVector.size();
                        for (int i = 0; i < n; ++i) {
                            String dn = (String)dirdnVector.elementAt(i);
                            logger.info("CAPublisherProcessor: Publishing to " + dn);
                            publisher.publish(conn, dn, (Object)cert);
                        }
                        break block17;
                    }
                    if (dirdn instanceof String || publisher instanceof FileBasedPublisher) {
                        logger.info("CAPublisherProcessor: Publishing to " + dirdn);
                        publisher.publish(conn, (String)dirdn, (Object)cert);
                    }
                }
                catch (Throwable e1) {
                    logger.error("CAPublisherProcessor: " + e1.getMessage(), e1);
                    throw e1;
                }
            }
            logger.info("CAPublisherProcessor: Published cert 0x" + cert.getSerialNumber().toString(16));
            if (conn == null) return;
        }
        catch (ELdapException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH", (String[])new String[]{e2.toString()}));
                }
            }
            catch (Throwable throwable) {
                if (conn == null) throw throwable;
                this.mLdapConnModule.returnConn(conn);
                throw throwable;
            }
        }
        this.mLdapConnModule.returnConn(conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void publishNow(Mapper mapper, Publisher publisher, Request r, byte[] bytes) throws EBaseException {
        if (!this.isCertPublishingEnabled()) {
            return;
        }
        logger.info("CAPublisherProcessor: in publishNow() for xcerts");
        X509CertImpl caCert = this.ca.getCACert();
        LDAPConnection conn = null;
        try {
            String dirdn = null;
            if (mapper != null) {
                if (this.mLdapConnModule != null) {
                    conn = this.mLdapConnModule.getConn();
                }
                try {
                    dirdn = mapper.map(conn, r, (Object)caCert);
                    logger.debug("CAPublisherProcessor: dirdn=" + dirdn);
                }
                catch (Throwable e1) {
                    logger.error("Error mapping: mapper=" + mapper + " error=" + e1.getMessage(), e1);
                    throw e1;
                }
            }
            try {
                logger.debug("CAPublisherProcessor: publisher impl name=" + publisher.getImplName());
                publisher.publish(conn, dirdn, (Object)bytes);
            }
            catch (Throwable e1) {
                logger.error("Error publishing: publisher=" + publisher + " error=" + e1.getMessage(), e1);
                throw e1;
            }
            logger.info("CAPublisherProcessor: published crossCertPair");
            if (conn == null) return;
        }
        catch (ELdapException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH", (String[])new String[]{e2.toString()}));
                }
            }
            catch (Throwable throwable) {
                if (conn == null) throw throwable;
                this.mLdapConnModule.returnConn(conn);
                throw throwable;
            }
        }
        this.mLdapConnModule.returnConn(conn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unpublishNow(Mapper mapper, Publisher publisher, Request r, Object obj) throws ELdapException {
        if (!this.isCertPublishingEnabled()) {
            return;
        }
        X509Certificate cert = (X509Certificate)obj;
        logger.info("CAPublisherProcessor: Unpublishing cert 0x" + cert.getSerialNumber().toString(16));
        LDAPConnection conn = null;
        try {
            String dirdn = null;
            if (mapper != null) {
                if (this.mLdapConnModule != null) {
                    conn = this.mLdapConnModule.getConn();
                }
                dirdn = mapper.map(conn, r, obj);
            }
            publisher.unpublish(conn, dirdn, (Object)cert);
            logger.info("CAPublisherProcessor: Unpublished cert 0x" + cert.getSerialNumber().toString(16));
            if (conn == null) return;
        }
        catch (ELdapException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (conn == null) throw throwable;
                this.mLdapConnModule.returnConn(conn);
                throw throwable;
            }
        }
        this.mLdapConnModule.returnConn(conn);
        return;
    }

    public boolean isCertPublishingEnabled() {
        if (!this.mInited) {
            return false;
        }
        try {
            if (!this.mConfig.isEnabled()) {
                return false;
            }
            return this.mConfig.isCertEnabled();
        }
        catch (EBaseException e) {
            logger.error("Error getting publishing config: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isCRLPublishingEnabled() {
        if (!this.mInited) {
            return false;
        }
        try {
            if (!this.mConfig.isEnabled()) {
                return false;
            }
            return this.mConfig.isCRLEnabled();
        }
        catch (EBaseException e) {
            logger.error("Error getting publishing config: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

