/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EAuthUserError;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLClientCertAuthentication
extends AuthManager {
    public static Logger logger = LoggerFactory.getLogger(SSLClientCertAuthentication.class);
    public static final String CRED_CERT = "sslClientCert";
    public static final String SERIALNUMBER = "serialNumber";
    public static final String ISSUERDN = "issuerDN";
    protected static String[] mRequiredCreds = new String[]{"sslClientCert"};
    private CertificateRepository mCertDB;

    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        this.authenticationConfig = authenticationConfig;
        this.mName = name;
        this.mImplName = implName;
        this.mConfig = config;
    }

    public void init(ConfigStore config) throws EProfileException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AuthToken authenticate(AuthCredentials authCred) throws EMissingCredential, EInvalidCredentials, EBaseException {
        AuthToken authToken = new AuthToken((AuthManager)this);
        logger.debug("SSLCertAuth: Retrieving client certificates");
        X509Certificate[] x509Certs = (X509Certificate[])authCred.get(CRED_CERT);
        if (x509Certs == null) {
            logger.error("SSLCertAuth: No client certificate found");
            logger.error(CMS.getLogMessage((String)"CMSCORE_AUTH_MISSING_CERT", (Object[])new Object[0]));
            throw new EMissingCredential(CMS.getUserMessage((String)"CMS_AUTHENTICATION_NULL_CREDENTIAL", (String[])new String[]{CRED_CERT}));
        }
        logger.debug("SSLCertAuth: Got client certificate");
        CAEngine caEngine = (CAEngine)this.engine;
        this.mCertDB = caEngine.getCertificateRepository();
        X509CertImpl clientCert = (X509CertImpl)x509Certs[0];
        BigInteger serialNum = null;
        try {
            serialNum = clientCert.getSerialNumber();
        }
        catch (NumberFormatException e) {
            throw new EAuthUserError(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_ATTRIBUTE_VALUE", (String[])new String[]{"Invalid serial number."}));
        }
        String clientCertIssuerDN = clientCert.getIssuerName().toString();
        CertRecord record = null;
        try {
            record = this.mCertDB.readCertificateRecord(serialNum);
        }
        catch (EBaseException ee) {
            logger.warn("SSLClientCertAuthentication: " + ee.getMessage(), (Throwable)ee);
        }
        if (record == null) throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_NOT_FOUND", (String[])new String[0]));
        String status = record.getStatus();
        if (!status.equals("VALID")) throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_CERT_STATUS", (String[])new String[]{status}));
        CertificateAuthority ca = caEngine.getCA();
        X509CertImpl cacert = ca.getCACert();
        X500Name p = cacert.getSubjectName();
        if (!p.toString().equals(clientCertIssuerDN)) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ISSUER_NAME", (String[])new String[0]));
        }
        authToken.set("tokenCert", clientCert);
        return authToken;
    }

    public void populate(AuthToken token, Request request) throws EProfileException {
    }

    public void shutdown() {
    }

    public String[] getRequiredCreds() {
        return mRequiredCreds;
    }

    public String getText(Locale locale) {
        return null;
    }

    public Enumeration<String> getValueNames() {
        return null;
    }

    public IDescriptor getValueDescriptor(Locale locale, String name) {
        return null;
    }

    public boolean isValueWriteable(String name) {
        return false;
    }

    public boolean isSSLClientRequired() {
        return false;
    }
}

