/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.ParseException;
import java.util.Date;
import org.dogtagpki.acme.ACME;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ACMECertificate {
    @JsonIgnore
    private String id;
    @JsonIgnore
    private Date creationTime;
    byte[] data;
    @JsonIgnore
    private Date expirationTime;

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getExpires() {
        return this.expirationTime == null ? null : ACME.DATE_FORMAT.format(this.expirationTime);
    }

    public void setExpires(String expires) throws ParseException {
        this.expirationTime = ACME.DATE_FORMAT.parse(expires);
    }

    public String toJSON() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this);
    }

    public static ACMECertificate fromJSON(String json) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (ACMECertificate)mapper.readValue(json, ACMECertificate.class);
    }

    public String toString() {
        try {
            return this.toJSON();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

