/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.profile;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.util.JSONSerializer;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProfileOutput
implements JSONSerializer {
    private String id;
    private String name;
    private String text;
    private String classId;
    private List<ProfileAttribute> attrs = new ArrayList<ProfileAttribute>();

    @JsonProperty
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ProfileOutput() {
    }

    public ProfileOutput(String id, String name, String classId) {
        this.id = id;
        this.name = name;
        this.classId = classId;
    }

    @JsonProperty
    public String getClassId() {
        return this.classId;
    }

    public void setClassId(String classId) {
        this.classId = classId;
    }

    @JsonProperty(value="attributes")
    public List<ProfileAttribute> getAttrs() {
        return this.attrs;
    }

    public void setAttrs(List<ProfileAttribute> attrs) {
        this.attrs = attrs;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void addAttribute(ProfileAttribute attr) {
        this.attrs.add(attr);
    }

    public void removeAttribute(ProfileAttribute attr) {
        this.attrs.remove(attr);
    }

    public void clearAttributes() {
        this.attrs.clear();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attrs == null ? 0 : this.attrs.hashCode());
        result = 31 * result + (this.classId == null ? 0 : this.classId.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfileOutput other = (ProfileOutput)obj;
        if (this.attrs == null ? other.attrs != null : !this.attrs.equals(other.attrs)) {
            return false;
        }
        if (this.classId == null ? other.classId != null : !this.classId.equals(other.classId)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public Element toDOM(Document document, String poElementName) {
        Element poElement = document.createElement(poElementName);
        this.toDOM(document, poElement);
        return poElement;
    }

    public void toDOM(Document document, Element poElement) {
        poElement.setAttribute("id", this.id);
        if (this.name != null) {
            Element nameElement = document.createElement("name");
            nameElement.appendChild(document.createTextNode(this.name));
            poElement.appendChild(nameElement);
        }
        if (this.text != null) {
            Element textElement = document.createElement("text");
            textElement.appendChild(document.createTextNode(this.text));
            poElement.appendChild(textElement);
        }
        if (this.classId != null) {
            Element classIdElement = document.createElement("classId");
            classIdElement.appendChild(document.createTextNode(this.classId));
            poElement.appendChild(classIdElement);
        }
        if (!this.attrs.isEmpty()) {
            for (ProfileAttribute attr : this.attrs) {
                Element attrElement = document.createElement("attributes");
                attr.toDOM(document, attrElement);
                poElement.appendChild(attrElement);
            }
        }
    }

    public static ProfileOutput fromDOM(Element profileOutputElement) {
        NodeList classIdList;
        NodeList textList;
        ProfileOutput profileOutput = new ProfileOutput();
        profileOutput.setId(profileOutputElement.getAttribute("id"));
        NodeList nameList = profileOutputElement.getElementsByTagName("name");
        if (nameList.getLength() > 0) {
            profileOutput.setName(nameList.item(0).getTextContent());
        }
        if ((textList = profileOutputElement.getElementsByTagName("text")).getLength() > 0) {
            profileOutput.setText(textList.item(0).getTextContent());
        }
        if ((classIdList = profileOutputElement.getElementsByTagName("classId")).getLength() > 0) {
            profileOutput.setClassId(classIdList.item(0).getTextContent());
        }
        NodeList paList = profileOutputElement.getElementsByTagName("attributes");
        int paCount = paList.getLength();
        for (int i = 0; i < paCount; ++i) {
            Element paElement = (Element)paList.item(i);
            ProfileAttribute pa = ProfileAttribute.fromDOM(paElement);
            profileOutput.addAttribute(pa);
        }
        return profileOutput;
    }

    public String toXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element pdElement = this.toDOM(document, "profileOutput");
        document.appendChild(pdElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource domSource = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        transformer.transform(domSource, streamResult);
        return sw.toString();
    }

    public static ProfileOutput fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element profileParameterElement = document.getDocumentElement();
        return ProfileOutput.fromDOM(profileParameterElement);
    }
}

