/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.dbs.DBVirtualList;
import com.netscape.certsrv.dbs.EDBException;
import com.netscape.certsrv.ldap.LDAPExceptionConverter;
import com.netscape.certsrv.tps.token.TokenCollection;
import com.netscape.certsrv.tps.token.TokenData;
import com.netscape.certsrv.tps.token.TokenResource;
import com.netscape.certsrv.tps.token.TokenStatus;
import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cms.servlet.base.SubsystemService;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.usrgrp.User;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.ws.rs.core.Response;
import netscape.ldap.LDAPException;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSEngineConfig;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.dogtagpki.server.tps.dbs.TokenDatabase;
import org.dogtagpki.server.tps.dbs.TokenRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenService
extends SubsystemService
implements TokenResource {
    public static Logger logger = LoggerFactory.getLogger(TokenService.class);

    public void setTokenStatus(TokenRecord tokenRecord, TokenStatus tokenState, String ipAddress, String remoteUser, Map<String, String> auditModParams) throws Exception {
        String method = "TPSService:setTokenStatus: ";
        String msg = "";
        List<String> authorizedProfiles = this.getAuthorizedProfiles();
        if (authorizedProfiles == null) {
            msg = "authorizedProfiles null";
            logger.debug(method + msg);
            throw new PKIException(method + msg);
        }
        String type = tokenRecord.getType();
        if (!(authorizedProfiles.contains("All Profiles") || type != null && !type.isEmpty() && authorizedProfiles.contains(type))) {
            throw new PKIException(method + "Token record restricted");
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig config = engine.getConfig();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem("tps");
        TokenStatus oldStatus = tokenRecord.getTokenStatus();
        String oldReason = tokenRecord.getReason();
        TokenStatus newStatus = tokenState;
        String newReason = null;
        boolean clearOnUnformatUserID = config.getBoolean("tokenservice.status.unformatted.clearUserID", true);
        boolean clearOnUnformatType = config.getBoolean("tokenservice.status.unformatted.clearType", true);
        boolean clearOnUnformatAppletID = config.getBoolean("tokenservice.status.unformatted.clearAppletID", true);
        boolean clearOnUnformatKeyInfo = config.getBoolean("tokenservice.status.unformatted.clearKeyInfo", true);
        boolean clearOnUnformatPolicy = config.getBoolean("tokenservice.status.unformatted.clearPolicy", true);
        auditModParams.put("UserID", tokenRecord.getUserID());
        switch (tokenState.getValue()) {
            case 7: {
                if (clearOnUnformatUserID) {
                    tokenRecord.setUserID(null);
                }
                if (clearOnUnformatType) {
                    tokenRecord.setType(null);
                }
                if (clearOnUnformatAppletID) {
                    tokenRecord.setAppletID(null);
                }
                if (clearOnUnformatKeyInfo) {
                    tokenRecord.setKeyInfo(null);
                }
                if (clearOnUnformatPolicy) {
                    tokenRecord.setPolicy(null);
                }
                tokenRecord.setTokenStatus(tokenState);
                tokenRecord.setReason(null);
                break;
            }
            case 0: {
                tokenRecord.setTokenStatus(tokenState);
                tokenRecord.setReason(null);
                break;
            }
            case 4: {
                if (tokenRecord.getTokenStatus() == TokenStatus.SUSPENDED) {
                    tps.tdb.unRevokeCertsByCUID(tokenRecord.getId(), ipAddress, remoteUser);
                }
                tokenRecord.setTokenStatus(tokenState);
                tokenRecord.setReason(null);
                break;
            }
            case 2: 
            case 5: {
                tokenRecord.setTokenStatus(tokenState);
                tokenRecord.setReason("keyCompromise");
                newReason = "keyCompromise";
                tps.tdb.revokeCertsByCUID(tokenRecord.getId(), "keyCompromise", ipAddress, remoteUser);
                break;
            }
            case 1: {
                tokenRecord.setTokenStatus(tokenState);
                tokenRecord.setReason("destroyed");
                newReason = "destroyed";
                tps.tdb.revokeCertsByCUID(tokenRecord.getId(), "destroyed", ipAddress, remoteUser);
                break;
            }
            case 3: {
                tokenRecord.setTokenStatus(tokenState);
                tokenRecord.setReason("onHold");
                newReason = "onHold";
                tps.tdb.revokeCertsByCUID(tokenRecord.getId(), "onHold", ipAddress, remoteUser);
                break;
            }
            case 6: {
                String reason = "terminated";
                tokenRecord.setTokenStatus(tokenState);
                tokenRecord.setReason(reason);
                newReason = reason;
                tps.tdb.revokeCertsByCUID(tokenRecord.getId(), reason, ipAddress, remoteUser);
                break;
            }
            default: {
                PKIException e = new PKIException("Unsupported token state: " + tokenState);
                this.auditTokenStateChange("Failure", oldStatus, newStatus, oldReason, newReason, auditModParams, e.toString());
                throw e;
            }
        }
        this.auditTokenStateChange("Success", oldStatus, newStatus, oldReason, newReason, auditModParams, null);
    }

    public TokenData createTokenData(TokenRecord tokenRecord) throws Exception {
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        ResourceBundle labels = this.getResourceBundle("token-states");
        TokenData tokenData = new TokenData();
        tokenData.setID(tokenRecord.getId());
        tokenData.setTokenID(tokenRecord.getId());
        tokenData.setUserID(tokenRecord.getUserID());
        tokenData.setType(tokenRecord.getType());
        TokenStatus status = tokenRecord.getTokenStatus();
        TokenData.TokenStatusData statusData = new TokenData.TokenStatusData();
        statusData.name = status;
        try {
            statusData.label = labels.getString(status.toString());
        }
        catch (MissingResourceException e) {
            statusData.label = status.toString();
        }
        tokenData.setStatus(statusData);
        Collection<TokenStatus> nextStates = subsystem.getUINextTokenStates(tokenRecord);
        if (nextStates != null) {
            ArrayList<TokenData.TokenStatusData> nextStatesData = new ArrayList<TokenData.TokenStatusData>();
            for (TokenStatus nextState : nextStates) {
                TokenData.TokenStatusData nextStateData = new TokenData.TokenStatusData();
                nextStateData.name = nextState;
                try {
                    nextStateData.label = labels.getString(status + "." + nextState);
                }
                catch (MissingResourceException e) {
                    nextStateData.label = nextState.toString();
                }
                nextStatesData.add(nextStateData);
            }
            tokenData.setNextStates(nextStatesData);
        }
        tokenData.setAppletID(tokenRecord.getAppletID());
        tokenData.setKeyInfo(tokenRecord.getKeyInfo());
        tokenData.setPolicy(tokenRecord.getPolicy());
        tokenData.setCreateTimestamp(tokenRecord.getCreateTimestamp());
        tokenData.setModifyTimestamp(tokenRecord.getModifyTimestamp());
        String tokenID = tokenRecord.getId();
        try {
            tokenID = URLEncoder.encode(tokenID, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("TokenService: " + e.getMessage(), (Throwable)e);
            throw new PKIException((Throwable)e);
        }
        return tokenData;
    }

    public TokenData createRestrictedTokenData() throws Exception {
        TokenData tokenData = new TokenData();
        tokenData.setID("<restricted>");
        tokenData.setTokenID("<restricted>");
        tokenData.setUserID("<restricted>");
        tokenData.setType("<restricted>");
        TokenData.TokenStatusData statusData = new TokenData.TokenStatusData();
        statusData.name = TokenStatus.valueOf(null);
        statusData.label = "<restricted>";
        tokenData.setStatus(statusData);
        tokenData.setAppletID("<restricted>");
        tokenData.setKeyInfo("<restricted>");
        tokenData.setPolicy("<restricted>");
        tokenData.setCreateTimestamp(new Date(0L));
        tokenData.setModifyTimestamp(new Date(0L));
        return tokenData;
    }

    public Response findTokens(String filter, String tokenID, String userID, String type, TokenStatus status, Integer start, Integer size) {
        logger.info("TokenService: Searching for tokens with filter " + filter);
        if (filter != null && filter.length() < 3) {
            throw new BadRequestException("Filter too short");
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)tokenID)) {
            attributes.put("id", tokenID);
        }
        if (StringUtils.isNotEmpty((CharSequence)userID)) {
            attributes.put("userID", userID);
        }
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            attributes.put("type", type);
        }
        if (status != null) {
            attributes.put("status", status.toString());
        }
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            TokenDatabase database = subsystem.getTokenDatabase();
            TokenCollection response = new TokenCollection();
            if (filter == null && attributes.isEmpty()) {
                this.retrieveTokensWithVLV(database, start, size, response);
            } else {
                this.retrieveTokensWithoutVLV(database, filter, attributes, start, size, response);
            }
            return this.createOKResponse(response);
        }
        catch (EDBException e) {
            Throwable t = e.getCause();
            if (t instanceof LDAPException) {
                throw LDAPExceptionConverter.toPKIException((LDAPException)((LDAPException)t));
            }
            throw new PKIException((Throwable)e);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("TokenService: " + e.getMessage(), (Throwable)e);
            throw new PKIException((Throwable)e);
        }
    }

    protected void retrieveTokensWithVLV(TokenDatabase database, Integer start, Integer size, TokenCollection response) throws Exception {
        String method = "TokenService.retrieveTokensWithVLV: ";
        DBVirtualList list = database.findRecords(null, null, new String[]{"-modifyTimestamp", "-createTimestamp"}, size);
        List<String> authorizedProfiles = this.getAuthorizedProfiles();
        int total = list.getSize();
        int retTotal = 0;
        if (authorizedProfiles != null) {
            if (authorizedProfiles.contains("All Profiles")) {
                for (int i = start.intValue(); i < start + size && i < total; ++i) {
                    TokenRecord record = (TokenRecord)list.getElementAt(i);
                    response.addEntry((Object)this.createTokenData(record));
                    ++retTotal;
                }
            } else {
                for (int i = start.intValue(); i < start + size && i < total; ++i) {
                    TokenRecord record = (TokenRecord)list.getElementAt(i);
                    String type = record.getType();
                    if (type == null || type.isEmpty() || authorizedProfiles.contains(type)) {
                        ++retTotal;
                        response.addEntry((Object)this.createTokenData(record));
                        continue;
                    }
                    response.addEntry((Object)this.createRestrictedTokenData());
                }
            }
        } else {
            logger.debug(method + "authorized profiles is null");
        }
        logger.debug(method + "retTotal = " + retTotal);
        response.setTotal(total);
    }

    protected void retrieveTokensWithoutVLV(TokenDatabase database, String filter, Map<String, String> attributes, Integer start, Integer size, TokenCollection response) throws Exception {
        String method = "TokenService.retrieveTokensWithoutVLV: ";
        List tokens = (List)database.findRecords(filter, attributes);
        int total = tokens.size();
        logger.debug(method + "total: " + total);
        List<String> authorizedProfiles = this.getAuthorizedProfiles();
        int retTotal = 0;
        int i = 0;
        if (authorizedProfiles != null) {
            if (authorizedProfiles.contains("All Profiles")) {
                for (i = start.intValue(); i < start + size && i < total; ++i) {
                    TokenRecord record = (TokenRecord)((Object)tokens.get(i));
                    response.addEntry((Object)this.createTokenData(record));
                    ++retTotal;
                }
            } else {
                for (i = start.intValue(); i < start + size && i < total; ++i) {
                    TokenRecord record = (TokenRecord)((Object)tokens.get(i));
                    String type = record.getType();
                    if (type == null || type.isEmpty() || authorizedProfiles.contains(type)) {
                        ++retTotal;
                        response.addEntry((Object)this.createTokenData(record));
                        continue;
                    }
                    response.addEntry((Object)this.createRestrictedTokenData());
                }
            }
        } else {
            logger.debug(method + "authorized profiles is null");
        }
        logger.debug(method + "retTotal = " + retTotal);
        response.setTotal(total);
    }

    public Response getToken(String tokenID) {
        String method = "TokenService.getToken: ";
        String msg = "";
        if (tokenID == null) {
            throw new BadRequestException(method + "Missing token ID");
        }
        logger.info(method + "Retrieving token " + tokenID);
        TPSEngine engine = TPSEngine.getInstance();
        try {
            List<String> authorizedProfiles = this.getAuthorizedProfiles();
            if (authorizedProfiles == null) {
                msg = "authorizedProfiles null";
                logger.debug(method + msg);
                throw new PKIException(method + msg);
            }
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            TokenDatabase database = subsystem.getTokenDatabase();
            TokenRecord record = (TokenRecord)database.getRecord(tokenID);
            if (record == null) {
                msg = "Token record not found";
                logger.debug(method + msg);
                throw new PKIException(method + msg);
            }
            String type = record.getType();
            if (type == null || type.isEmpty() || authorizedProfiles.contains("All Profiles") || authorizedProfiles.contains(type)) {
                return this.createOKResponse(this.createTokenData(record));
            }
            throw new PKIException(method + "Token record restricted");
        }
        catch (EDBException e) {
            Throwable t = e.getCause();
            if (t instanceof LDAPException) {
                throw LDAPExceptionConverter.toPKIException((LDAPException)((LDAPException)t));
            }
            throw new PKIException((Throwable)e);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug(method, (Throwable)e);
            throw new PKIException((Throwable)e);
        }
    }

    public Response addToken(TokenData tokenData) {
        String method = "TokenService.addToken: ";
        logger.info(method);
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        if (tokenData == null) {
            BadRequestException ex = new BadRequestException(method + "Missing token data");
            this.auditConfigTokenGeneral("Failure", method, null, ex.toString());
            throw ex;
        }
        String tokenID = tokenData.getTokenID();
        logger.info(method + "Token ID: " + tokenID);
        auditModParams.put("tokenID", tokenID);
        String remoteUser = this.servletRequest.getRemoteUser();
        String ipAddress = this.servletRequest.getRemoteAddr();
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        TokenRecord tokenRecord = null;
        Object msg = "add token";
        try {
            String policy;
            TokenDatabase database = subsystem.getTokenDatabase();
            tokenRecord = new TokenRecord();
            tokenRecord.setId(tokenID);
            String userID = tokenData.getUserID();
            if (StringUtils.isNotEmpty((CharSequence)userID)) {
                tokenRecord.setUserID(userID);
                auditModParams.put("userID", userID);
            }
            if (StringUtils.isNotEmpty((CharSequence)(policy = tokenData.getPolicy()))) {
                tokenRecord.setPolicy(policy);
                auditModParams.put("Policy", policy);
            }
            tokenRecord.setTokenStatus(TokenStatus.UNFORMATTED);
            auditModParams.put("Status", TokenStatus.UNFORMATTED.toString());
            database.addRecord(tokenID, tokenRecord);
            subsystem.tdb.tdbActivity("add", tokenRecord, ipAddress, (String)msg, "success", remoteUser);
            tokenData = this.createTokenData((TokenRecord)database.getRecord(tokenID));
            this.auditConfigTokenRecord("Success", method, tokenID, auditModParams, null);
            String encodedTokenID = URLEncoder.encode(tokenID, "UTF-8");
            URI uri = this.uriInfo.getBaseUriBuilder().path(TokenResource.class).path("{tokenID}").build(new Object[]{encodedTokenID});
            return this.createCreatedResponse(tokenData, uri);
        }
        catch (Exception e) {
            Throwable t;
            msg = (String)msg + ": " + e.getMessage();
            logger.error((String)msg, (Throwable)e);
            subsystem.tdb.tdbActivity("add", tokenRecord, ipAddress, (String)msg, "failure", remoteUser);
            if (e instanceof EDBException && (t = e.getCause()) instanceof LDAPException) {
                PKIException ex = LDAPExceptionConverter.toPKIException((LDAPException)((LDAPException)t));
                this.auditConfigTokenRecord("Failure", method, tokenID, auditModParams, ex.toString());
                throw ex;
            }
            if (e instanceof PKIException) {
                this.auditConfigTokenRecord("Failure", method, tokenID, auditModParams, e.toString());
                throw (PKIException)((Object)e);
            }
            this.auditConfigTokenRecord("Failure", method, tokenID, auditModParams, e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    public Response replaceToken(String tokenID, TokenData tokenData) {
        String method = "TokenService.replaceToken: ";
        logger.info(method + "Replacing token " + tokenID);
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        if (tokenID == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Missing token ID");
            throw new BadRequestException(method + "Missing token ID");
        }
        if (tokenData == null) {
            this.auditConfigTokenGeneral("Failure", method, auditModParams, "Missing token data");
            throw new BadRequestException("Missing token data");
        }
        String remoteUser = this.servletRequest.getRemoteUser();
        String ipAddress = this.servletRequest.getRemoteAddr();
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        TokenRecord tokenRecord = null;
        Object msg = "replace token";
        try {
            List<String> authorizedProfiles = this.getAuthorizedProfiles();
            if (authorizedProfiles == null) {
                msg = "authorizedProfiles null";
                logger.debug(method + (String)msg);
                throw new PKIException(method + (String)msg);
            }
            TokenDatabase database = subsystem.getTokenDatabase();
            tokenRecord = (TokenRecord)database.getRecord(tokenID);
            if (tokenRecord == null) {
                msg = "Token record not found";
                logger.debug(method + (String)msg);
                throw new PKIException(method + (String)msg);
            }
            String type = tokenRecord.getType();
            if (!(type == null || type.isEmpty() || authorizedProfiles.contains("All Profiles") || authorizedProfiles.contains(type))) {
                throw new PKIException(method + "Token record restricted");
            }
            tokenRecord.setUserID(remoteUser);
            auditModParams.put("userID", remoteUser);
            tokenRecord.setType(tokenData.getType());
            auditModParams.put("type", tokenData.getType());
            tokenRecord.setAppletID(tokenData.getAppletID());
            auditModParams.put("appletID", tokenData.getAppletID());
            tokenRecord.setKeyInfo(tokenData.getKeyInfo());
            auditModParams.put("keyInfo", tokenData.getKeyInfo());
            tokenRecord.setPolicy(tokenData.getPolicy());
            auditModParams.put("Policy", tokenData.getPolicy());
            database.updateRecord(tokenID, tokenRecord);
            subsystem.tdb.tdbActivity("token_modify", tokenRecord, ipAddress, (String)msg, "success", remoteUser);
            tokenData = this.createTokenData((TokenRecord)database.getRecord(tokenID));
            this.auditConfigTokenRecord("Success", method, tokenID, auditModParams, null);
            return this.createOKResponse(tokenData);
        }
        catch (Exception e) {
            Throwable t;
            msg = (String)msg + ": " + e.getMessage();
            logger.error((String)msg, (Throwable)e);
            subsystem.tdb.tdbActivity("token_modify", tokenRecord, ipAddress, (String)msg, "failure", remoteUser);
            if (e instanceof EDBException && (t = e.getCause()) instanceof LDAPException) {
                PKIException ex = LDAPExceptionConverter.toPKIException((LDAPException)((LDAPException)t));
                this.auditConfigTokenRecord("Failure", method, tokenID, auditModParams, ex.toString());
                throw ex;
            }
            if (e instanceof PKIException) {
                this.auditConfigTokenRecord("Failure", method, tokenID, auditModParams, e.toString());
                throw (PKIException)((Object)e);
            }
            this.auditConfigTokenRecord("Failure", method, tokenID, auditModParams, e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    public Response modifyToken(String tokenID, TokenData tokenData) {
        String method = "TokenService.modifyToken: ";
        logger.info(method + "Modifying token " + tokenID);
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        if (tokenID == null) {
            BadRequestException e = new BadRequestException(method + "Missing token ID");
            this.auditConfigTokenRecord("Failure", "modify", tokenID, auditModParams, e.toString());
            throw e;
        }
        if (tokenData == null) {
            BadRequestException e = new BadRequestException("Missing token data");
            this.auditConfigTokenRecord("Failure", "modify", tokenID, auditModParams, e.toString());
            throw e;
        }
        String remoteUser = this.servletRequest.getRemoteUser();
        String ipAddress = this.servletRequest.getRemoteAddr();
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        TokenRecord tokenRecord = null;
        Object msg = "modify token";
        try {
            String policy;
            List<String> authorizedProfiles = this.getAuthorizedProfiles();
            if (authorizedProfiles == null) {
                msg = "authorizedProfiles null";
                logger.debug(method + (String)msg);
                throw new PKIException(method + (String)msg);
            }
            TokenDatabase database = subsystem.getTokenDatabase();
            tokenRecord = (TokenRecord)database.getRecord(tokenID);
            if (tokenRecord == null) {
                logger.debug(method + "Token record not found");
                throw new PKIException(method + "Token record not found");
            }
            String type = tokenRecord.getType();
            if (!(type == null || type.isEmpty() || authorizedProfiles.contains("All Profiles") || authorizedProfiles.contains(type))) {
                logger.debug(method + "token record restricted");
                throw new PKIException("token record restricted");
            }
            String userID = tokenData.getUserID();
            if (userID != null) {
                if (userID.equals("")) {
                    tokenRecord.setUserID(null);
                } else {
                    tokenRecord.setUserID(userID);
                    auditModParams.put("userID", userID);
                }
            }
            if ((policy = tokenData.getPolicy()) != null) {
                if (policy.equals("")) {
                    tokenRecord.setPolicy(null);
                } else {
                    tokenRecord.setPolicy(policy);
                    auditModParams.put("Policy", policy);
                }
            }
            database.updateRecord(tokenID, tokenRecord);
            subsystem.tdb.tdbActivity("token_modify", tokenRecord, ipAddress, (String)msg, "success", remoteUser);
            tokenData = this.createTokenData((TokenRecord)database.getRecord(tokenID));
            this.auditConfigTokenRecord("Success", method, tokenID, auditModParams, null);
            return this.createOKResponse(tokenData);
        }
        catch (Exception e) {
            Throwable t;
            msg = (String)msg + ": " + e.getMessage();
            logger.error((String)msg, (Throwable)e);
            subsystem.tdb.tdbActivity("token_modify", tokenRecord, ipAddress, (String)msg, "failure", remoteUser);
            if (e instanceof EDBException && (t = e.getCause()) instanceof LDAPException) {
                PKIException ex = LDAPExceptionConverter.toPKIException((LDAPException)((LDAPException)t));
                this.auditConfigTokenRecord("Failure", method, tokenID, auditModParams, ex.toString());
                throw ex;
            }
            if (e instanceof PKIException) {
                this.auditConfigTokenRecord("Failure", method, tokenID, auditModParams, e.toString());
                throw (PKIException)((Object)e);
            }
            this.auditConfigTokenRecord("Failure", method, tokenID, auditModParams, e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    public Response changeTokenStatus(String tokenID, TokenStatus tokenStatus) {
        String method = "TokenService.changeTokenStatus: ";
        logger.debug(method + "begins: with tokenStatus=" + tokenStatus);
        if (tokenID == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Missing token ID");
            throw new BadRequestException(method + "Missing token ID");
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        if (tokenStatus == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Missing token status");
            throw new BadRequestException("Missing token status");
        }
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        auditModParams.put("tokenID", tokenID);
        auditModParams.put("tokenStatus", tokenStatus.toString());
        String remoteUser = this.servletRequest.getRemoteUser();
        String ipAddress = this.servletRequest.getRemoteAddr();
        TokenStatus oldStatus = null;
        String oldReason = null;
        TokenStatus newStatus = null;
        String newReason = null;
        TokenRecord tokenRecord = null;
        Object msg = "change token status";
        try {
            List<String> authorizedProfiles = this.getAuthorizedProfiles();
            if (authorizedProfiles == null) {
                msg = "authorizedProfiles null";
                logger.debug(method + (String)msg);
                throw new PKIException(method + (String)msg);
            }
            TokenDatabase database = subsystem.getTokenDatabase();
            database = subsystem.getTokenDatabase();
            tokenRecord = (TokenRecord)database.getRecord(tokenID);
            if (tokenRecord == null) {
                logger.debug(method + "Token record not found");
                throw new PKIException(method + "Token record not found");
            }
            String type = tokenRecord.getType();
            if (!(type == null || type.isEmpty() || authorizedProfiles.contains("All Profiles") || authorizedProfiles.contains(type))) {
                logger.debug(method + "token record restricted: " + type);
                throw new PKIException("token record restricted");
            }
            TokenStatus currentTokenStatus = tokenRecord.getTokenStatus();
            logger.debug(method + "current status: " + currentTokenStatus);
            oldStatus = tokenRecord.getTokenStatus();
            oldReason = tokenRecord.getReason();
            newStatus = tokenStatus;
            if (currentTokenStatus == tokenStatus) {
                logger.debug(method + "no status change, no activity log generated");
                TokenData tokenData = this.createTokenData(tokenRecord);
                return this.createOKResponse(tokenData);
            }
            msg = (String)msg + " from " + currentTokenStatus + " to " + tokenStatus;
            logger.debug(method + (String)msg);
            if (!oldStatus.isValid()) {
                logger.debug(method + "current status is invalid: " + oldStatus);
                BadRequestException ex = new BadRequestException("Cannot change status of token with current status: " + oldStatus);
                this.auditTokenStateChange("Failure", oldStatus, newStatus, oldReason, newReason, auditModParams, ex.toString());
                throw ex;
            }
            if (!subsystem.isUITransitionAllowed(tokenRecord, tokenStatus)) {
                logger.error(method + "next status not allowed: " + tokenStatus);
                BadRequestException ex = new BadRequestException("Invalid token status transition");
                this.auditTokenStateChange("Failure", oldStatus, newStatus, oldReason, newReason, auditModParams, ex.toString());
                throw ex;
            }
            logger.debug(method + "next status allowed: " + tokenStatus);
            this.setTokenStatus(tokenRecord, tokenStatus, ipAddress, remoteUser, auditModParams);
            database.updateRecord(tokenID, tokenRecord);
            subsystem.tdb.tdbActivity("token_status_change", tokenRecord, ipAddress, (String)msg, "success", remoteUser);
            TokenData tokenData = this.createTokenData((TokenRecord)database.getRecord(tokenID));
            return this.createOKResponse(tokenData);
        }
        catch (Exception e) {
            Throwable t;
            msg = (String)msg + ": " + e.getMessage();
            logger.error((String)msg, (Throwable)e);
            subsystem.tdb.tdbActivity("token_status_change", tokenRecord, ipAddress, (String)msg, "failure", remoteUser);
            if (e instanceof EDBException && (t = e.getCause()) instanceof LDAPException) {
                PKIException ex = LDAPExceptionConverter.toPKIException((LDAPException)((LDAPException)t));
                this.auditTokenStateChange("Failure", oldStatus, newStatus, oldReason, newReason, auditModParams, ex.toString());
                throw ex;
            }
            if (e instanceof PKIException) {
                this.auditTokenStateChange("Failure", oldStatus, newStatus, oldReason, newReason, auditModParams, e.toString());
                throw (PKIException)((Object)e);
            }
            this.auditTokenStateChange("Failure", oldStatus, newStatus, oldReason, newReason, auditModParams, e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    public Response removeToken(String tokenID) {
        String method = "TokenService.removeToken: ";
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        if (tokenID == null) {
            BadRequestException ex = new BadRequestException(method + "Missing token ID");
            this.auditConfigTokenRecord("Failure", method, tokenID, auditModParams, ex.toString());
            throw ex;
        }
        logger.info(method + "Removing token " + tokenID);
        String remoteUser = this.servletRequest.getRemoteUser();
        String ipAddress = this.servletRequest.getRemoteAddr();
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        TokenRecord tokenRecord = null;
        Object msg = "remove token";
        try {
            List<String> authorizedProfiles = this.getAuthorizedProfiles();
            if (authorizedProfiles == null) {
                msg = "authorizedProfiles null";
                logger.debug(method + (String)msg);
                throw new PKIException(method + (String)msg);
            }
            TokenDatabase database = subsystem.getTokenDatabase();
            tokenRecord = (TokenRecord)database.getRecord(tokenID);
            if (tokenRecord == null) {
                msg = "Token record not found";
                logger.debug(method + (String)msg);
                throw new PKIException(method + (String)msg);
            }
            String type = tokenRecord.getType();
            if (!(type == null || type.isEmpty() || authorizedProfiles.contains("All Profiles") || authorizedProfiles.contains(type))) {
                throw new PKIException(method + "Token record restricted");
            }
            logger.debug(method + "about to remove all certificates associated with the token first");
            subsystem.tdb.tdbRemoveCertificatesByCUID(tokenRecord.getId());
            database.removeRecord(tokenID);
            this.auditConfigTokenRecord("Success", method, tokenID, auditModParams, null);
            subsystem.tdb.tdbActivity("delete", tokenRecord, ipAddress, (String)msg, "success", remoteUser);
            return this.createNoContentResponse();
        }
        catch (Exception e) {
            Throwable t;
            msg = (String)msg + ": " + e.getMessage();
            logger.error((String)msg, (Throwable)e);
            subsystem.tdb.tdbActivity("delete", tokenRecord, ipAddress, (String)msg, "failure", remoteUser);
            if (e instanceof EDBException && (t = e.getCause()) instanceof LDAPException) {
                PKIException ex = LDAPExceptionConverter.toPKIException((LDAPException)((LDAPException)t));
                this.auditConfigTokenRecord("Failure", method, tokenID, auditModParams, ex.toString());
                throw ex;
            }
            if (e instanceof PKIException) {
                this.auditConfigTokenRecord("Failure", method, tokenID, auditModParams, e.toString());
                throw (PKIException)((Object)e);
            }
            this.auditConfigTokenRecord("Failure", method, tokenID, auditModParams, e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    List<String> getAuthorizedProfiles() throws Exception {
        String method = "TokenService.getAuthorizedProfiles: ";
        PKIPrincipal pkiPrincipal = (PKIPrincipal)this.servletRequest.getUserPrincipal();
        if (pkiPrincipal == null) {
            logger.debug(method + "servletRequest.getUserPrincipal() returned null");
            return null;
        }
        User user = pkiPrincipal.getUser();
        return user.getTpsProfiles();
    }

    public void auditConfigTokenRecord(String status, String service, String tokenID, Map<String, String> params, String info) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String msg = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_TOKEN_RECORD_6", (Object[])new Object[]{this.servletRequest.getUserPrincipal().getName(), status, service, tokenID, auditor.getParamString(params), info});
        auditor.log(msg);
    }

    public void auditTokenStateChange(String status, TokenStatus oldState, TokenStatus newState, String oldReason, String newReason, Map<String, String> params, String info) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String msg = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_TOKEN_STATE_CHANGE_8", (Object[])new Object[]{this.servletRequest.getUserPrincipal().getName(), status, oldState == null ? "" : oldState.toString(), oldReason, newState == null ? "" : newState.toString(), newReason, auditor.getParamString(params), info});
        auditor.log(msg);
    }
}

