/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.main;

import com.netscape.certsrv.base.EBaseException;
import java.util.ArrayList;
import org.dogtagpki.server.authentication.AuthManagersConfig;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSEngineConfig;
import org.dogtagpki.server.tps.main.ExternalRegCertToRecover;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalRegAttrs {
    public static Logger logger = LoggerFactory.getLogger(ExternalRegAttrs.class);
    public String ldapAttrNameTokenType;
    public String ldapAttrNameTokenCUID;
    public String ldapAttrNameCertsToRecover;
    public String ldapAttrNameRegistrationType;
    String tokenCUID;
    String tokenType;
    String tokenUserId;
    String tokenMSN;
    String registrationType;
    ArrayList<ExternalRegCertToRecover> certsToRecover;
    boolean isDelegation;

    public ExternalRegAttrs(String authId) {
        String method = "ExternalRegAttrs";
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        AuthenticationConfig authConfig = configStore.getAuthenticationConfig();
        AuthManagersConfig instancesConfig = authConfig.getAuthManagersConfig();
        String configName = null;
        try {
            configName = authId + ".externalReg.tokenTypeAttributeName";
            logger.debug(method + ": getting config: auths.instance." + configName);
            this.ldapAttrNameTokenType = instancesConfig.getString(configName, "tokenType");
            configName = authId + ".externalReg.cuidAttributeName";
            logger.debug(method + ": getting config: auths.instance." + configName);
            this.ldapAttrNameTokenCUID = instancesConfig.getString(configName, "tokenCUID");
            configName = authId + ".externalReg.certs.recoverAttributeName";
            logger.debug(method + ": getting config: auths.instance." + configName);
            this.ldapAttrNameCertsToRecover = instancesConfig.getString(configName, "certsToRecover");
            String RH_Delegation_Cfg = "externalReg.delegation.enable";
            this.isDelegation = configStore.getBoolean(RH_Delegation_Cfg, false);
            configName = authId + ".externalReg.registrationTypeAttributeName";
            logger.debug(method + ": getting config: auths.instance." + configName);
            this.ldapAttrNameRegistrationType = instancesConfig.getString(configName, "registrationtype");
        }
        catch (EBaseException e) {
            logger.warn("ExternalRegAttrs: unable to obtain certain config values. Default to be used: " + e.getMessage(), (Throwable)e);
        }
        this.certsToRecover = new ArrayList();
    }

    public void setTokenType(String type) {
        this.tokenType = type;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenCUID(String cuid) {
        this.tokenCUID = cuid;
    }

    public String getTokenCUID() {
        return this.tokenCUID;
    }

    public void setTokenUserId(String uid) {
        this.tokenUserId = uid;
    }

    public String getTokenUserId() {
        return this.tokenUserId;
    }

    public void setTokenMSN(String msn) {
        this.tokenMSN = msn;
    }

    public String getTokenMSN() {
        return this.tokenMSN;
    }

    public int getCertsToRecoverCount() {
        return this.certsToRecover.size();
    }

    public void addCertToRecover(ExternalRegCertToRecover cert) {
        this.certsToRecover.add(cert);
    }

    public ArrayList<ExternalRegCertToRecover> getCertsToRecover() {
        return this.certsToRecover;
    }

    public void setIsDelegation(boolean isDelegation) {
        this.isDelegation = isDelegation;
    }

    public boolean getIsDelegation() {
        return this.isDelegation;
    }

    public void setRegistrationType(String regType) {
        this.registrationType = regType;
    }

    public String getRegistrationType() {
        return this.registrationType;
    }
}

