/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.cms;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.connector.HttpConnector;
import com.netscape.cmsutil.http.HttpResponse;
import java.math.BigInteger;
import java.util.Hashtable;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.dogtagpki.server.tps.cms.KRARecoverKeyResponse;
import org.dogtagpki.server.tps.cms.KRAServerSideKeyGenResponse;
import org.dogtagpki.server.tps.cms.RemoteRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRARemoteRequestHandler
extends RemoteRequestHandler {
    public static Logger logger = LoggerFactory.getLogger(KRARemoteRequestHandler.class);

    public KRARemoteRequestHandler(String connID) throws EBaseException {
        if (connID == null) {
            throw new EBaseException("KRARemoteRequestHandler: KRARemoteRequestHandler(): connID null.");
        }
        this.connid = connID;
    }

    public KRAServerSideKeyGenResponse serverSideKeyGen(boolean isECC, int keysize, String cuid, String userid, String sDesKey, boolean archive) throws EBaseException {
        HttpResponse resp;
        logger.debug("KRARemoteRequestHandler: serverSideKeyGen(): begins.");
        if (cuid == null || userid == null || sDesKey == null) {
            throw new EBaseException("KRARemoteRequestHandler: serverSideKeyGen(): input parameter null.");
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        HttpConnector conn = (HttpConnector)subsystem.getConnectionManager().getConnector(this.connid);
        logger.debug("KRARemoteRequestHandler: serverSideKeyGen(): sending request to KRA");
        if (isECC) {
            String eckeycurve;
            if (keysize == 521) {
                eckeycurve = "nistp521";
            } else if (keysize == 384) {
                eckeycurve = "nistp384";
            } else if (keysize == 256) {
                eckeycurve = "nistp256";
            } else {
                logger.debug("KRARemoteRequestHandler: serverSideKeyGen(): unrecognized ECC keysize" + keysize + ", setting to nistp256");
                keysize = 256;
                eckeycurve = "nistp256";
            }
            String request = "archive=" + archive + "&tokencuid=" + cuid + "&userid=" + userid + "&keytype=EC&eckeycurve=" + eckeycurve + "&drm_trans_desKey=" + sDesKey;
            resp = conn.send("GenerateKeyPair", request);
        } else {
            String request = "archive=" + archive + "&tokencuid=" + cuid + "&userid=" + userid + "&keytype=RSA&keysize=" + keysize + "&drm_trans_desKey=" + sDesKey;
            resp = conn.send("GenerateKeyPair", request);
        }
        if (resp == null) {
            throw new EBaseException("KRARemoteRequestHandler: serverSideKeyGen(): No response object returned from connection.");
        }
        String content = resp.getContent();
        if (content == null || content.equals("")) {
            logger.error("KRARemoteRequestHandler: serverSideKeyGen(): no response content.");
            throw new EBaseException("KRARemoteRequestHandler: serverSideKeyGen(): no response content.");
        }
        logger.debug("KRARemoteRequestHandler: serverSideKeyGen(): got content");
        Hashtable<String, Object> response = this.parseResponse(content);
        Integer ist = -1;
        String value = (String)response.get("status");
        if (value == null) {
            throw new EBaseException("KRARemoteRequestHandler: serverSideKeyGen(): Invalide status returned!");
        }
        logger.debug("KRARemoteRequestHandler: serverSideKeyGen(): got status = " + value);
        ist = Integer.parseInt(value);
        if (ist != 0) {
            logger.debug("KRARemoteRequestHandler: serverSideKeyGen(): status not 0, getting error string... ");
            value = (String)response.get("error");
            if (value == null) {
                logger.debug("KRARemoteRequestHandler: serverSideKeyGen(): response missing name-value pair for: error");
            } else {
                logger.debug("KRARemoteRequestHandler: serverSideKeyGen(): got IRemoteRequest.RESPONSE_ERROR_STRING = " + value);
                response.put("error", value);
            }
        }
        response.put("status", ist);
        value = (String)response.get("public_key");
        if (value == null) {
            logger.debug("KRARemoteRequestHandler: serverSideKeyGen(): response missing name-value pair for: public_key");
        } else {
            logger.debug("KRARemoteRequestHandler:serverSideKeyGen(): got IRemoteRequest.KRA_RESPONSE_PublicKey");
            response.put("public_key", value);
        }
        value = (String)response.get("wrapped_priv_key");
        if (value == null) {
            logger.debug("KRARemoteRequestHandler: serverSideKeyGen(): response missing name-value pair for: wrapped_priv_key");
        } else {
            logger.debug("KRARemoteRequestHandler:serverSideKeyGen(): got IRemoteRequest.KRA_RESPONSE_Wrapped_PrivKey");
            response.put("wrapped_priv_key", value);
        }
        value = (String)response.get("iv_param");
        if (value == null) {
            logger.debug("KRARemoteRequestHandler: serverSideKeyGen(): response missing name-value pair for: iv_param");
        } else {
            logger.debug("KRARemoteRequestHandler:serverSideKeyGen(): got IRemoteRequest.KRA_RESPONSE_IV_Param");
            response.put("iv_param", value);
        }
        logger.debug("KRARemoteRequestHandler: serverSideKeyGen(): ends.");
        return new KRAServerSideKeyGenResponse(this.connid, response);
    }

    public KRARecoverKeyResponse recoverKey(String cuid, String userid, String sDesKey, String b64cert) throws EBaseException {
        return this.recoverKey(cuid, userid, sDesKey, b64cert, BigInteger.valueOf(0L));
    }

    public KRARecoverKeyResponse recoverKey(String cuid, String userid, String sDesKey, String b64cert, BigInteger keyid) throws EBaseException {
        logger.debug("KRARemoteRequestHandler: recoverKey(): begins.");
        if (b64cert == null && keyid == BigInteger.valueOf(0L)) {
            throw new EBaseException("KRARemoteRequestHandler: recoverKey(): one of b64cert or kid has to be a valid value");
        }
        if (cuid == null || userid == null || sDesKey == null) {
            throw new EBaseException("KRARemoteRequestHandler: recoverKey(): input parameter null.");
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        logger.debug("KRARemoteRequestHandler: getting conn id: " + this.connid);
        HttpConnector conn = (HttpConnector)subsystem.getConnectionManager().getConnector(this.connid);
        if (conn == null) {
            logger.error("KRARemoteRequestHandler: recoverKey(): conn null");
            throw new EBaseException("KRARemoteRequestHandler: recoverKey(): conn null");
        }
        logger.debug("KRARemoteRequestHandler: recoverKey(): sending request to KRA");
        String sendMsg = null;
        try {
            if (b64cert != null) {
                sendMsg = "tokencuid=" + cuid + "&userid=" + userid + "&cert=" + b64cert + "&drm_trans_desKey=" + sDesKey;
            } else if (keyid != BigInteger.valueOf(0L)) {
                logger.debug("KRARemoteRequestHandler: recoverKey(): keyid = " + keyid);
                sendMsg = "tokencuid=" + cuid + "&userid=" + userid + "&keyid=" + keyid.toString() + "&drm_trans_desKey=" + sDesKey;
            }
        }
        catch (Exception e) {
            logger.debug("KRARemoteRequestHandler: recoverKey(): uriEncode failed: " + e);
            throw new EBaseException("KRARemoteRequestHandler: recoverKey(): uriEncode failed: " + e);
        }
        HttpResponse resp = conn.send("TokenKeyRecovery", sendMsg);
        if (resp == null) {
            throw new EBaseException("KRARemoteRequestHandler: recoverKey(): No response object returned from connection.");
        }
        String content = resp.getContent();
        if (content == null || content.equals("")) {
            logger.error("KRARemoteRequestHandler: recoverKey(): no response content.");
            throw new EBaseException("KRARemoteRequestHandler: recoverKey(): no response content.");
        }
        logger.debug("KRARemoteRequestHandler: recoverKey(): got content");
        Hashtable<String, Object> response = this.parseResponse(content);
        Integer ist = -1;
        String value = (String)response.get("status");
        logger.debug("KRARemoteRequestHandler: recoverKey(): got status = " + value);
        ist = Integer.parseInt(value);
        if (ist != 0) {
            logger.debug("KRARemoteRequestHandler: recoverKey(): status not 0, getting error string... ");
            value = (String)response.get("error");
            if (value == null) {
                logger.debug("KRARemoteRequestHandler: recoverKey(): response missing name-value pair for: error");
            } else {
                logger.debug("KRARemoteRequestHandler: recoverKey(): got IRemoteRequest.RESPONSE_ERROR_STRING = " + value);
                response.put("error", value);
            }
        }
        response.put("status", ist);
        value = (String)response.get("public_key");
        if (value == null) {
            logger.debug("KRARemoteRequestHandler: recoverKey(): response missing name-value pair for: public_key");
        } else {
            logger.debug("KRARemoteRequestHandler:recoverKey(): got IRemoteRequest.KRA_RESPONSE_PublicKey");
            response.put("public_key", value);
        }
        value = (String)response.get("wrapped_priv_key");
        if (value == null) {
            logger.debug("KRARemoteRequestHandler: recoverKey(): response missing name-value pair for: wrapped_priv_key");
        } else {
            logger.debug("KRARemoteRequestHandler:recoverKey(): got IRemoteRequest.KRA_RESPONSE_Wrapped_PrivKey");
            response.put("wrapped_priv_key", value);
        }
        value = (String)response.get("iv_param");
        if (value == null) {
            logger.debug("KRARemoteRequestHandler: recoverKey(): response missing name-value pair for: iv_param");
        } else {
            logger.debug("KRARemoteRequestHandler:recoverKey(): got IRemoteRequest.KRA_RESPONSE_IV_Param");
            response.put("iv_param", value);
        }
        logger.debug("KRARemoteRequestHandler: recoverKey(): ends.");
        return new KRARecoverKeyResponse(this.connid, response);
    }
}

