/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.connector;

import com.netscape.certsrv.tps.connector.ConnectorClient;
import com.netscape.certsrv.tps.connector.ConnectorData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.connector.ConnectorCLI;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ConnectorShowCLI.class);
    public ConnectorCLI connectorCLI;

    public ConnectorShowCLI(ConnectorCLI connectorCLI) {
        super("show", "Show connector", (CLI)connectorCLI);
        this.connectorCLI = connectorCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Connector ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output", true, "Output file to store connector properties.");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No Connector ID specified.");
        }
        String connectorID = cmdArgs[0];
        String output = cmd.getOptionValue("output");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        ConnectorClient connectorClient = this.connectorCLI.getConnectorClient();
        ConnectorData connectorData = connectorClient.getConnector(connectorID);
        if (output == null) {
            MainCLI.printMessage("Connector \"" + connectorID + "\"");
            ConnectorCLI.printConnectorData(connectorData, true);
        } else {
            try (PrintWriter out = new PrintWriter(new FileWriter(output));){
                out.println(connectorData.toJSON());
            }
            MainCLI.printMessage("Stored connector \"" + connectorID + "\" into " + output);
        }
    }
}

