/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.authenticator;

import com.netscape.certsrv.tps.authenticator.AuthenticatorClient;
import com.netscape.certsrv.tps.authenticator.AuthenticatorData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.authenticator.AuthenticatorCLI;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatorShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(AuthenticatorShowCLI.class);
    public AuthenticatorCLI authenticatorCLI;

    public AuthenticatorShowCLI(AuthenticatorCLI authenticatorCLI) {
        super("show", "Show authenticator", (CLI)authenticatorCLI);
        this.authenticatorCLI = authenticatorCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Authenticator ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output", true, "Output file to store authenticator properties.");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No Authenticator ID specified.");
        }
        String authenticatorID = cmdArgs[0];
        String output = cmd.getOptionValue("output");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        AuthenticatorClient authenticatorClient = this.authenticatorCLI.getAuthenticatorClient();
        AuthenticatorData authenticatorData = authenticatorClient.getAuthenticator(authenticatorID);
        if (output == null) {
            MainCLI.printMessage("Authenticator \"" + authenticatorID + "\"");
            AuthenticatorCLI.printAuthenticatorData(authenticatorData, true);
        } else {
            try (PrintWriter out = new PrintWriter(new FileWriter(output));){
                out.println(authenticatorData);
            }
            MainCLI.printMessage("Stored authenticator \"" + authenticatorID + "\" into " + output);
        }
    }
}

