/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tks;

import com.netscape.certsrv.system.TPSConnectorClient;
import com.netscape.certsrv.system.TPSConnectorCollection;
import com.netscape.certsrv.system.TPSConnectorData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tks.TPSConnectorCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSConnectorFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(TPSConnectorFindCLI.class);
    public TPSConnectorCLI tpsConnectorCLI;

    public TPSConnectorFindCLI(TPSConnectorCLI tpsConnectorCLI) {
        super("find", "Find TPS connectors on TKS", (CLI)tpsConnectorCLI);
        this.tpsConnectorCLI = tpsConnectorCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String s = cmd.getOptionValue("start");
        Integer start = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("size");
        Integer size = s == null ? null : Integer.valueOf(s);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        TPSConnectorClient tpsConnectorClient = this.tpsConnectorCLI.getTPSConnectorClient();
        TPSConnectorCollection result = tpsConnectorClient.findConnectors(null, null, start, size);
        MainCLI.printMessage(result.getTotal() + " entries matched");
        if (result.getTotal() == 0) {
            return;
        }
        Collection conns = result.getEntries();
        boolean first = true;
        for (TPSConnectorData data : conns) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            TPSConnectorCLI.printConnectorInfo(data);
        }
        MainCLI.printMessage("Number of entries returned " + conns.size());
    }
}

