/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.selftests;

import com.netscape.certsrv.selftests.SelfTestClient;
import com.netscape.certsrv.selftests.SelfTestResult;
import com.netscape.certsrv.selftests.SelfTestResults;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.selftests.SelfTestCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfTestRunCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(SelfTestRunCLI.class);
    public SelfTestCLI selfTestCLI;

    public SelfTestRunCLI(SelfTestCLI selfTestCLI) {
        super("run", "Run selftests", (CLI)selfTestCLI);
        this.selfTestCLI = selfTestCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [selftests...] [OPTIONS...]", this.options);
    }

    public static void printSelfTestResult(SelfTestResult result) {
        System.out.println("  Selftest ID: " + result.getID());
        String status = result.getStatus();
        System.out.println("  Status: " + status);
        String output = result.getOutput();
        if (StringUtils.isNotEmpty((CharSequence)output)) {
            System.out.println("  Output:");
            System.out.println(output);
        }
    }

    public void execute(CommandLine cmd) throws Exception {
        SelfTestResults results;
        String[] cmdArgs = cmd.getArgs();
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        SelfTestClient selfTestClient = this.selfTestCLI.getSelfTestClient();
        if (cmdArgs.length == 0) {
            results = selfTestClient.runSelfTests();
        } else {
            results = new SelfTestResults();
            for (String selfTestID : cmdArgs) {
                SelfTestResult result = selfTestClient.runSelfTest(selfTestID);
                results.addEntry((Object)result);
            }
        }
        boolean first = true;
        for (SelfTestResult result : results.getEntries()) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            SelfTestRunCLI.printSelfTestResult(result);
        }
        MainCLI.printMessage("Selftests completed");
    }
}

