/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.request;

import com.netscape.certsrv.base.IAttrSet;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cmscore.request.ExtDataHashtable;
import com.netscape.cmscore.request.RequestIAttrSetWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.dogtagpki.server.authentication.AuthToken;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509ExtensionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Request {
    public static Logger logger = LoggerFactory.getLogger(Request.class);
    public static final String REQ_VERSION = "requestVersion";
    public static final String REQ_STATUS = "requestStatus";
    public static final String REQ_TYPE = "requestType";
    public static final String REQ_FORMAT = "requestFormat";
    public static final String ENROLLMENT_REQUEST = "enrollment";
    public static final String RENEWAL_REQUEST = "renewal";
    public static final String REVOCATION_REQUEST = "revocation";
    public static final String CMCREVOKE_REQUEST = "CMCRevReq";
    public static final String UNREVOCATION_REQUEST = "unrevocation";
    public static final String KEYARCHIVAL_REQUEST = "archival";
    public static final String KEYRECOVERY_REQUEST = "recovery";
    public static final String KEY_RECOVERY_REQUEST = "keyRecovery";
    public static final String KEY_ARCHIVAL_REQUEST = "keyArchival";
    public static final String GETCACHAIN_REQUEST = "getCAChain";
    public static final String GETREVOCATIONINFO_REQUEST = "getRevocationInfo";
    public static final String GETCRL_REQUEST = "getCRL";
    public static final String GETCERTS_REQUEST = "getCertificates";
    public static final String REVOCATION_CHECK_CHALLENGE_REQUEST = "revocationChallenge";
    public static final String GETCERT_STATUS_REQUEST = "getCertStatus";
    public static final String GETCERTS_FOR_CHALLENGE_REQUEST = "getCertsForChallenge";
    public static final String CLA_CERT4CRL_REQUEST = "cert4crl";
    public static final String CLA_UNCERT4CRL_REQUEST = "uncert4crl";
    public static final String NETKEY_KEYGEN_REQUEST = "netkeyKeygen";
    public static final String NETKEY_KEYRECOVERY_REQUEST = "netkeyKeyRecovery";
    public static final String REQUESTOR_NAME = "csrRequestorName";
    public static final String REQUESTOR_PHONE = "csrRequestorPhone";
    public static final String REQUESTOR_EMAIL = "csrRequestorEmail";
    public static final String REQUESTOR_COMMENTS = "csrRequestorComments";
    public static final String AUTH_TOKEN = "AUTH_TOKEN";
    public static final String HTTP_PARAMS = "HTTP_PARAMS";
    public static final String HTTP_HEADERS = "HTTP_HEADERS";
    public static final String AGENT_PARAMS = "AGENT_PARAMS";
    public static final String SERVER_ATTRS = "SERVER_ATTRS";
    public static final String AUTH_TOKEN_PREFIX = "auth_token";
    public static final String PROFILE_ID = "profileId";
    public static final String AUTHORITY_ID = "req_authority_id";
    public static final String USER_DATA = "user_data";
    public static final String RESULT = "Result";
    public static final Integer RES_SUCCESS = 1;
    public static final Integer RES_ERROR = 2;
    public static final String REMOTE_SERVICE_AUTHORITY = "RemServiceAuthority";
    public static final String SVCERRORS = "serviceErrors";
    public static final String REMOTE_STATUS = "remoteStatus";
    public static final String REMOTE_REQID = "remoteReqID";
    public static final String CERT_STATUS = "certStatus";
    public static final String CHALLENGE_PHRASE = "challengePhrase";
    public static final String SUBJECTNAME = "subjectName";
    public static final String SERIALNUMBER = "serialNumber";
    public static final String SERIALNOARRAY = "serialNoArray";
    public static final String CERT_TYPE = "certType";
    public static final String CRMF_REQID = "crmfReqId";
    public static final String PKCS10_REQID = "pkcs10ReqId";
    public static final String CMC_REQIDS = "cmcReqIds";
    public static final String CMC_TRANSID = "transactionId";
    public static final String CMC_SENDERNONCE = "senderNonce";
    public static final String CMC_RECIPIENTNONCE = "recipientNonce";
    public static final String CMC_REGINFO = "regInfo";
    public static final String CERT_INFO = "CERT_INFO";
    public static final String ISSUED_CERTS = "issuedCerts";
    public static final String REQUEST_TRUSTEDMGR_PRIVILEGE = "requestTrustedManagerPrivilege";
    public static final String FINGERPRINTS = "fingerprints";
    public static final String SERVER_CERT = "server";
    public static final String CLIENT_CERT = "client";
    public static final String CA_CERT = "ca";
    public static final String RA_CERT = "ra";
    public static final String OCSP_CERT = "ocsp";
    public static final String OBJECT_SIGNING_CERT = "objSignClient";
    public static final String OTHER_CERT = "other";
    public static final String ROUTER_CERT = "router";
    public static final String CEP_CERT = "CEP-Request";
    public static final String OLD_CERTS = "OLD_CERTS";
    public static final String OLD_SERIALS = "OLD_SERIALS";
    public static final String ISSUERDN = "issuerDN";
    public static final String REVOKED_CERTS = "revokedCerts";
    public static final String REVOKED_REASON = "revocationReason";
    public static final String REVOKED_CERT_RECORDS = "revokedCertRecs";
    public static final String CRL_UPDATE_STATUS = "crlUpdateStatus";
    public static final String CRL_UPDATE_ERROR = "crlUpdateError";
    public static final String CRL_PUBLISH_STATUS = "crlPublishStatus";
    public static final String CRL_PUBLISH_ERROR = "crlPublishError";
    public static final String REQUESTOR_TYPE = "requestorType";
    public static final String NETKEY_ATTR_CUID = "CUID";
    public static final String NETKEY_ATTR_USERID = "USERID";
    public static final String NETKEY_ATTR_DRMTRANS_DES_KEY = "drm_trans_desKey";
    public static final String NETKEY_ATTR_ARCHIVE_FLAG = "archive";
    public static final String NETKEY_ATTR_SERVERSIDE_MUSCLE_FLAG = "serverSideMuscle";
    public static final String NETKEY_ATTR_ENC_PRIVKEY_FLAG = "encryptPrivKey";
    public static final String NETKEY_ATTR_USER_CERT = "cert";
    public static final String NETKEY_ATTR_KEYID = "keyid";
    public static final String NETKEY_ATTR_KEY_SIZE = "keysize";
    public static final String NETKEY_ATTR_KEY_TYPE = "keytype";
    public static final String NETKEY_ATTR_KEY_EC_CURVE = "eckeycurve";
    public static final String SECURITY_DATA_ENROLLMENT_REQUEST = "securityDataEnrollment";
    public static final String SECURITY_DATA_RECOVERY_REQUEST = "securityDataRecovery";
    public static final String SECURITY_DATA_CLIENT_KEY_ID = "clientKeyID";
    public static final String SECURITY_DATA_STRENGTH = "strength";
    public static final String SECURITY_DATA_ALGORITHM = "algorithm";
    public static final String SECURITY_DATA_TYPE = "dataType";
    public static final String SECURITY_DATA_STATUS = "status";
    public static final String SECURITY_DATA_TRANS_SESS_KEY = "transWrappedSessionKey";
    public static final String SECURITY_DATA_SESS_PASS_PHRASE = "sessionWrappedPassphrase";
    public static final String SECURITY_DATA_IV_STRING_IN = "iv_in";
    public static final String SECURITY_DATA_IV_STRING_OUT = "iv_out";
    public static final String SECURITY_DATA_SESS_WRAPPED_DATA = "sessWrappedSecData";
    public static final String SECURITY_DATA_PASS_WRAPPED_DATA = "passPhraseWrappedData";
    public static final String SECURITY_DATA_PL_ENCRYPTION_OID = "payloadEncryptionOID";
    public static final String SECURITY_DATA_PL_WRAPPING_NAME = "payloadWrappingName";
    public static final String SECURITY_DATA_PL_WRAPPED = "payloadWrapped";
    public static final String ASYMKEY_GENERATION_REQUEST = "asymkeyGenRequest";
    public static final String SYMKEY_GENERATION_REQUEST = "symkeyGenRequest";
    public static final String KEY_GEN_ALGORITHM = "keyGenAlgorithm";
    public static final String KEY_GEN_SIZE = "keyGenSize";
    public static final String KEY_GEN_USAGES = "keyGenUsages";
    public static final String KEY_GEN_TRANS_WRAPPED_SESSION_KEY = "transWrappedSessionKey";
    public static final String SERVER_SIDE_KEYGEN_ENROLL_ENABLE_ARCHIVAL = "serverSideKeygenEnrollEnableArchival";
    public static final String SSK_STAGE = "serverSideKeygenStage";
    public static final String SSK_STAGE_KEYGEN = "serverSideKeygenStage_keygen";
    public static final String SSK_STAGE_KEY_RETRIEVE = "serverSideKeygenStage_key_retrieve";
    public static final String REQUESTOR_EE = "EE";
    public static final String REQUESTOR_RA = "RA";
    public static final String REQUESTOR_NETKEY_RA = "NETKEY_RA";
    public static final String REQUESTOR_KRA = "KRA";
    public static final String REQUESTOR_AGENT = "Agent";
    public static final String CACERTCHAIN = "CACertChain";
    public static final String CRL = "CRL";
    public static final String DOGETCACHAIN = "doGetCAChain";
    public static final String CERT_FILTER = "certFilter";
    public static final String ERRORS = "errors";
    public static final String SMIME = "SMIME";
    public static final String OBJECT_SIGNING = "ObjectSigning";
    public static final String SSL_CLIENT = "SSLClient";
    public static final String REQUEST_SUBJECT_NAME = "req_subject_name";
    public static final String REQUEST_KEY = "req_key";
    public static final String REQUEST_TRANSPORT_CERT = "req_transport_cert";
    public static final String REQUEST_ARCHIVE_OPTIONS = "req_archive_options";
    public static final String REQUEST_SESSION_KEY = "req_session_key";
    public static final String REQUEST_SECURITY_DATA = "req_security_data";
    public static final String REQUEST_ALGORITHM_PARAMS = "req_algorithm_params";
    public static final String REQUEST_ALGORITHM_OID = "req_algorithm_oid";
    public static final String REQUEST_VALIDITY = "req_validity";
    public static final String REQUEST_SIGNING_ALGORITHM = "req_signing_alg";
    public static final String REQUEST_EXTENSIONS = "req_extensions";
    public static final String REQUEST_CERTINFO = "req_x509info";
    public static final String REQUEST_ISSUED_CERT = "req_issued_cert";
    public static final String CTX_CERT_REQUEST = "cert_request";
    public static final String ATTR_REQUEST_OWNER = "requestOwner";
    public static final String ATTR_REQUEST_STATUS = "requestStatus";
    public static final String ATTR_SOURCE_ID = "requestSourceId";
    public static final String ATTR_REQUEST_TYPE = "requestType";
    public static final String ATTR_APPROVE_AGENTS = "approvingAgents";
    public static final String UPDATED_BY = "updatedBy";
    public static final String ERROR = "Error";
    public static final String ERROR_CODE = "errorCode";
    public static final String REALM = "realm";
    protected RequestId mRequestId;
    protected RequestStatus mRequestStatus;
    protected String mSourceId;
    protected String mSource;
    protected String mOwner;
    protected String mRequestType;
    protected String mContext;
    protected String realm;
    protected ExtDataHashtable<Object> mExtData = new ExtDataHashtable();
    Date mCreationTime = new Date();
    Date mModificationTime = new Date();

    public Request(RequestId id) {
        this.mRequestId = id;
        this.setRequestStatus(RequestStatus.BEGIN);
    }

    public RequestId getRequestId() {
        return this.mRequestId;
    }

    public RequestStatus getRequestStatus() {
        return this.mRequestStatus;
    }

    public void setRequestStatus(RequestStatus s) {
        this.mRequestStatus = s;
        this.setExtData("requestStatus", s.toString());
    }

    public boolean isSuccess() {
        Integer result = this.getExtDataInInteger(RESULT);
        return result != null && result.equals(RES_SUCCESS);
    }

    public String getError(Locale locale) {
        return this.getExtDataInString(ERROR);
    }

    public String getErrorCode(Locale locale) {
        return this.getExtDataInString(ERROR_CODE);
    }

    public String getSourceId() {
        return this.mSourceId;
    }

    public void setSourceId(String id) {
        this.mSourceId = id;
    }

    public String getRequestOwner() {
        return this.mOwner;
    }

    public void setRequestOwner(String id) {
        this.mOwner = id;
    }

    public String getRequestType() {
        return this.mRequestType;
    }

    public void setRequestType(String type) {
        this.mRequestType = type;
        this.setExtData("requestType", type);
    }

    public String getRequestVersion() {
        return this.getExtDataInString(REQ_VERSION);
    }

    public Date getCreationTime() {
        return this.mCreationTime;
    }

    public void setCreationTime(Date date) {
        this.mCreationTime = date;
    }

    public String getContext() {
        return this.mContext;
    }

    public void setContext(String ctx) {
        this.mContext = ctx;
    }

    public Date getModificationTime() {
        return this.mModificationTime;
    }

    public void setModificationTime(Date date) {
        this.mModificationTime = date;
    }

    public void copyContents(Request req) {
        Enumeration<String> e = req.getExtDataKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (key.equals(ISSUED_CERTS) || key.equals(ERRORS) || key.equals(REMOTE_REQID)) continue;
            if (req.isSimpleExtDataValue(key)) {
                this.setExtData(key, req.getExtDataInString(key));
                continue;
            }
            this.setExtData(key, req.getExtDataInHashtable(key));
        }
    }

    protected boolean isValidExtDataKey(String key) {
        return key != null && !key.equals("");
    }

    protected boolean isValidExtDataHashtableValue(Hashtable<String, String> hash) {
        if (hash == null) {
            return false;
        }
        Enumeration<String> keys = hash.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!(key instanceof String) || !this.isValidExtDataKey(key)) {
                return false;
            }
            String value = hash.get(key);
            if (value instanceof String) continue;
            return false;
        }
        return true;
    }

    public boolean setExtData(String key, String value) {
        if (!this.isValidExtDataKey(key)) {
            return false;
        }
        if (value == null) {
            return false;
        }
        this.mExtData.put(key, (Object)value);
        return true;
    }

    public boolean setExtData(String key, Hashtable<String, String> value) {
        if (!this.isValidExtDataKey(key) || !this.isValidExtDataHashtableValue(value)) {
            return false;
        }
        this.mExtData.put(key, (Object)new ExtDataHashtable<String>((Map<String, String>)value));
        return true;
    }

    public boolean isSimpleExtDataValue(String key) {
        return this.mExtData.get(key) instanceof String;
    }

    public String getExtDataInString(String key) {
        Object value = this.mExtData.get(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            return null;
        }
        return (String)value;
    }

    public Hashtable<String, String> getExtDataInHashtable(String key) {
        Object value = this.mExtData.get(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof Hashtable)) {
            return null;
        }
        return new ExtDataHashtable<String>((Hashtable)value);
    }

    public Enumeration<String> getExtDataKeys() {
        return this.mExtData.keys();
    }

    public void deleteExtData(String type) {
        this.mExtData.remove(type);
    }

    public boolean setExtData(String key, String subkey, String value) {
        if (!this.isValidExtDataKey(key) || !this.isValidExtDataKey(subkey)) {
            return false;
        }
        if (this.isSimpleExtDataValue(key)) {
            return false;
        }
        if (value == null) {
            return false;
        }
        ExtDataHashtable<String> existingValue = (ExtDataHashtable<String>)this.mExtData.get(key);
        if (existingValue == null) {
            existingValue = new ExtDataHashtable<String>();
            this.mExtData.put(key, (Object)existingValue);
        }
        ((Hashtable)existingValue).put(subkey, value);
        return true;
    }

    public String getExtDataInString(String key, String subkey) {
        Hashtable<String, String> value = this.getExtDataInHashtable(key);
        if (value == null) {
            return null;
        }
        return value.get(subkey);
    }

    public boolean setExtData(String key, Integer value) {
        if (value == null) {
            return false;
        }
        return this.setExtData(key, value.toString());
    }

    public Integer getExtDataInInteger(String key) {
        String strVal = this.getExtDataInString(key);
        if (strVal == null) {
            return null;
        }
        try {
            return Integer.valueOf(strVal);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean setExtData(String key, Integer[] data) {
        if (data == null) {
            return false;
        }
        String[] stringArray = new String[data.length];
        for (int index = 0; index < data.length; ++index) {
            stringArray[index] = data[index].toString();
        }
        return this.setExtData(key, stringArray);
    }

    public Integer[] getExtDataInIntegerArray(String key) {
        String[] stringArray = this.getExtDataInStringArray(key);
        if (stringArray == null) {
            return null;
        }
        Integer[] intArray = new Integer[stringArray.length];
        for (int index = 0; index < stringArray.length; ++index) {
            try {
                intArray[index] = Integer.valueOf(stringArray[index]);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return intArray;
    }

    public boolean setExtData(String key, BigInteger value) {
        if (value == null) {
            return false;
        }
        return this.setExtData(key, value.toString());
    }

    public BigInteger getExtDataInBigInteger(String key) {
        String strVal = this.getExtDataInString(key);
        if (strVal == null) {
            return null;
        }
        try {
            return new BigInteger(strVal);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean setExtData(String key, BigInteger[] data) {
        if (data == null) {
            return false;
        }
        String[] stringArray = new String[data.length];
        for (int index = 0; index < data.length; ++index) {
            stringArray[index] = data[index].toString();
        }
        return this.setExtData(key, stringArray);
    }

    public BigInteger[] getExtDataInBigIntegerArray(String key) {
        String[] stringArray = this.getExtDataInStringArray(key);
        if (stringArray == null) {
            return null;
        }
        BigInteger[] intArray = new BigInteger[stringArray.length];
        for (int index = 0; index < stringArray.length; ++index) {
            try {
                intArray[index] = new BigInteger(stringArray[index]);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return intArray;
    }

    public boolean setExtData(String key, Throwable e) {
        if (e == null) {
            return false;
        }
        return this.setExtData(key, e.toString());
    }

    public boolean setExtData(String key, byte[] data) {
        if (data == null) {
            return false;
        }
        return this.setExtData(key, Utils.base64encode((byte[])data, (boolean)true));
    }

    public byte[] getExtDataInByteArray(String key) {
        String value = this.getExtDataInString(key);
        if (value != null) {
            return Utils.base64decode((String)value);
        }
        return null;
    }

    public boolean setExtData(String key, X509CertImpl data) {
        if (data == null) {
            return false;
        }
        try {
            return this.setExtData(key, data.getEncoded());
        }
        catch (CertificateEncodingException e) {
            return false;
        }
    }

    public X509CertImpl getExtDataInCert(String key) {
        byte[] data = this.getExtDataInByteArray(key);
        if (data != null) {
            try {
                return new X509CertImpl(data);
            }
            catch (CertificateException e) {
                logger.warn("Request: getExtDataInCert(): " + e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public boolean setExtData(String key, X509CertImpl[] data) {
        if (data == null) {
            return false;
        }
        String[] stringArray = new String[data.length];
        for (int index = 0; index < data.length; ++index) {
            try {
                stringArray[index] = Utils.base64encode((byte[])data[index].getEncoded(), (boolean)true);
                continue;
            }
            catch (CertificateEncodingException e) {
                return false;
            }
        }
        return this.setExtData(key, stringArray);
    }

    public X509CertImpl[] getExtDataInCertArray(String key) {
        String[] stringArray = this.getExtDataInStringArray(key);
        if (stringArray == null) {
            return null;
        }
        X509CertImpl[] certArray = new X509CertImpl[stringArray.length];
        for (int index = 0; index < stringArray.length; ++index) {
            try {
                certArray[index] = new X509CertImpl(Utils.base64decode((String)stringArray[index]));
                continue;
            }
            catch (CertificateException e) {
                logger.warn("Request: getExtDataInCertArray(): " + e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return certArray;
    }

    public boolean setExtData(String key, X509CertInfo data) {
        if (data == null) {
            return false;
        }
        try {
            return this.setExtData(key, data.getEncodedInfo(true));
        }
        catch (CertificateEncodingException e) {
            return false;
        }
    }

    public X509CertInfo getExtDataInCertInfo(String key) {
        byte[] data = this.getExtDataInByteArray(key);
        if (data != null) {
            try {
                return new X509CertInfo(data);
            }
            catch (CertificateException e) {
                logger.warn("Request: getExtDataInCertInfo(): " + e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public boolean setExtData(String key, X509CertInfo[] data) {
        if (data == null) {
            return false;
        }
        String[] stringArray = new String[data.length];
        for (int index = 0; index < data.length; ++index) {
            try {
                stringArray[index] = Utils.base64encode((byte[])data[index].getEncodedInfo(true), (boolean)true);
                continue;
            }
            catch (CertificateEncodingException e) {
                return false;
            }
        }
        return this.setExtData(key, stringArray);
    }

    public X509CertInfo[] getExtDataInCertInfoArray(String key) {
        String[] stringArray = this.getExtDataInStringArray(key);
        if (stringArray == null) {
            return null;
        }
        X509CertInfo[] certArray = new X509CertInfo[stringArray.length];
        for (int index = 0; index < stringArray.length; ++index) {
            try {
                certArray[index] = new X509CertInfo(Utils.base64decode((String)stringArray[index]));
                continue;
            }
            catch (CertificateException e) {
                logger.warn("Request: getExtDataInCertInfoArray(): " + e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return certArray;
    }

    public boolean setExtData(String key, RevokedCertImpl[] data) {
        if (data == null) {
            return false;
        }
        String[] stringArray = new String[data.length];
        for (int index = 0; index < data.length; ++index) {
            try {
                stringArray[index] = Utils.base64encode((byte[])data[index].getEncoded(), (boolean)true);
                continue;
            }
            catch (CRLException e) {
                return false;
            }
        }
        return this.setExtData(key, stringArray);
    }

    public RevokedCertImpl[] getExtDataInRevokedCertArray(String key) {
        String[] stringArray = this.getExtDataInStringArray(key);
        if (stringArray == null) {
            return null;
        }
        RevokedCertImpl[] certArray = new RevokedCertImpl[stringArray.length];
        for (int index = 0; index < stringArray.length; ++index) {
            try {
                certArray[index] = new RevokedCertImpl(Utils.base64decode((String)stringArray[index]));
                continue;
            }
            catch (CRLException e) {
                return null;
            }
            catch (X509ExtensionException e) {
                return null;
            }
        }
        return certArray;
    }

    public boolean setExtData(String key, Vector<?> stringVector) {
        String[] stringArray;
        if (stringVector == null) {
            return false;
        }
        try {
            stringArray = stringVector.toArray(new String[0]);
        }
        catch (ArrayStoreException e) {
            return false;
        }
        return this.setExtData(key, stringArray);
    }

    public Vector<String> getExtDataInStringVector(String key) {
        String[] stringArray = this.getExtDataInStringArray(key);
        if (stringArray == null) {
            return null;
        }
        return new Vector<String>(Arrays.asList(stringArray));
    }

    public boolean getExtDataInBoolean(String key, boolean defVal) {
        String val = this.getExtDataInString(key);
        if (val == null) {
            return defVal;
        }
        return val.equalsIgnoreCase("true") || val.equalsIgnoreCase("ON");
    }

    public boolean getExtDataInBoolean(String prefix, String type, boolean defVal) {
        String val = this.getExtDataInString(prefix, type);
        if (val == null) {
            return defVal;
        }
        return val.equalsIgnoreCase("true") || val.equalsIgnoreCase("ON");
    }

    public boolean setExtData(String key, AuthToken data) {
        if (data == null) {
            return false;
        }
        Hashtable<String, String> hash = new Hashtable<String, String>();
        Enumeration<String> keys = data.getElements();
        while (keys.hasMoreElements()) {
            try {
                String authKey = keys.nextElement();
                hash.put(authKey, data.getInString(authKey));
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return this.setExtData(key, hash);
    }

    public AuthToken getExtDataInAuthToken(String key) {
        Hashtable<String, String> hash = this.getExtDataInHashtable(key);
        if (hash == null) {
            return null;
        }
        AuthToken authToken = new AuthToken(null);
        Enumeration<String> keys = hash.keys();
        while (keys.hasMoreElements()) {
            try {
                String hashKey = keys.nextElement();
                authToken.set(hashKey, hash.get(hashKey));
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        return authToken;
    }

    public boolean setExtData(String key, CertificateExtensions data) {
        if (data == null) {
            return false;
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            data.encode((OutputStream)byteStream);
        }
        catch (CertificateException e) {
            logger.warn("Request: setExtData(): " + e.getMessage(), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.warn("Request: setExtData(): " + e.getMessage(), (Throwable)e);
            return false;
        }
        return this.setExtData(key, byteStream.toByteArray());
    }

    public CertificateExtensions getExtDataInCertExts(String key) {
        CertificateExtensions exts = null;
        byte[] extensionsData = this.getExtDataInByteArray(key);
        if (extensionsData != null) {
            exts = new CertificateExtensions();
            try {
                exts.decodeEx((InputStream)new ByteArrayInputStream(extensionsData));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return exts;
    }

    public boolean setExtData(String key, CertificateSubjectName data) {
        if (data == null) {
            return false;
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            data.encode((OutputStream)byteStream);
        }
        catch (IOException e) {
            return false;
        }
        return this.setExtData(key, byteStream.toByteArray());
    }

    public CertificateSubjectName getExtDataInCertSubjectName(String key) {
        CertificateSubjectName name = null;
        byte[] nameData = this.getExtDataInByteArray(key);
        if (nameData != null) {
            try {
                name = new CertificateSubjectName(new DerInputStream(nameData));
            }
            catch (IOException e) {
                return null;
            }
        }
        return name;
    }

    public boolean setExtData(String key, String[] values) {
        if (values == null) {
            return false;
        }
        Hashtable<String, String> hashValue = new Hashtable<String, String>();
        for (int index = 0; index < values.length; ++index) {
            hashValue.put(Integer.toString(index), values[index]);
        }
        return this.setExtData(key, hashValue);
    }

    public String[] getExtDataInStringArray(String key) {
        Hashtable<String, String> hashValue = this.getExtDataInHashtable(key);
        if (hashValue == null) {
            String[] stringArray;
            String s = this.getExtDataInString(key);
            if (s == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = s;
            }
            return stringArray;
        }
        Set<String> arrayKeys = hashValue.keySet();
        Vector<String> listValue = new Vector<String>(arrayKeys.size());
        for (String arrayKey : arrayKeys) {
            int index;
            try {
                index = Integer.parseInt(arrayKey);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (listValue.size() < index + 1) {
                listValue.setSize(index + 1);
            }
            listValue.set(index, hashValue.get(arrayKey));
        }
        return listValue.toArray(new String[0]);
    }

    public IAttrSet asIAttrSet() {
        return new RequestIAttrSetWrapper(this);
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void printContent() {
        String method = "Request.printContent: ";
        logger.debug(method + "Content of request: ");
        Enumeration<String> ereq = this.getExtDataKeys();
        while (ereq.hasMoreElements()) {
            String reqKey = ereq.nextElement();
            String reqVal = this.getExtDataInString(reqKey);
            if (reqVal != null) {
                logger.debug("  req entry - " + reqKey + ": " + reqVal);
                continue;
            }
            logger.debug("  req entry - " + reqKey + ": no value");
        }
    }
}

