/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.base;

import com.netscape.cmscore.apps.CMSEngine;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SystemInfoServlet
extends HttpServlet {
    private static final long serialVersionUID = -438134935001530607L;
    protected ServletConfig servletConfig;
    protected ServletContext servletContext;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.servletConfig = sc;
        this.servletContext = sc.getServletContext();
    }

    public CMSEngine getCMSEngine() {
        return (CMSEngine)this.servletContext.getAttribute("engine");
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String op = request.getParameter("op");
        response.setContentType("text/html");
        if (op == null) {
            this.mainMenu(request, response);
        } else if (op.equals("gc")) {
            this.gc(request, response);
        } else if (op.equals("general")) {
            this.general(request, response);
        } else if (op.equals("thread")) {
            this.thread(request, response);
        }
    }

    private void mainMenu(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.getWriter().println("<HTML>");
        response.getWriter().println("<H1>");
        response.getWriter().println("<a href=" + request.getServletPath() + ">");
        response.getWriter().println("Main");
        response.getWriter().println("</a>");
        response.getWriter().println("</H1>");
        response.getWriter().println("<p>");
        response.getWriter().println("<table>");
        response.getWriter().println("<tr>");
        response.getWriter().println("<td>");
        response.getWriter().println("<li>");
        response.getWriter().println("<a href=" + request.getServletPath() + "?op=general>");
        response.getWriter().println("General");
        response.getWriter().println("</a>");
        response.getWriter().println("</td>");
        response.getWriter().println("</tr>");
        response.getWriter().println("<tr>");
        response.getWriter().println("<td>");
        response.getWriter().println("<li>");
        response.getWriter().println("<a href=" + request.getServletPath() + "?op=gc>");
        response.getWriter().println("Garbage Collection");
        response.getWriter().println("</a>");
        response.getWriter().println("</td>");
        response.getWriter().println("</tr>");
        response.getWriter().println("<tr>");
        response.getWriter().println("<td>");
        response.getWriter().println("<li>");
        response.getWriter().println("<a href=" + request.getServletPath() + "?op=thread>");
        response.getWriter().println("Thread Listing");
        response.getWriter().println("</a>");
        response.getWriter().println("</td>");
        response.getWriter().println("</tr>");
        response.getWriter().println("</table>");
        response.getWriter().println("</HTML>");
    }

    private void gc(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        response.getWriter().println("<HTML>");
        response.getWriter().println("<H1>");
        response.getWriter().println("<a href=" + request.getServletPath() + ">");
        response.getWriter().println("Main");
        response.getWriter().println("</a>");
        response.getWriter().println(" : ");
        response.getWriter().println("Garbage Collection");
        response.getWriter().println("</H1>");
        response.getWriter().println("<p>");
        response.getWriter().println("The garbage collector has been executed.");
        response.getWriter().println("</HTML>");
    }

    private void general(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        CMSEngine engine = this.getCMSEngine();
        response.getWriter().println("<HTML>");
        response.getWriter().println("<H1>");
        response.getWriter().println("<a href=" + request.getServletPath() + ">");
        response.getWriter().println("Main");
        response.getWriter().println("</a>");
        response.getWriter().println(" : ");
        response.getWriter().println("General");
        response.getWriter().println("</H1>");
        response.getWriter().println("<p>");
        response.getWriter().println("<table>");
        response.getWriter().println("<tr>");
        response.getWriter().println("<td>");
        response.getWriter().println("Server Started Time:");
        response.getWriter().println("</td>");
        response.getWriter().println("<td>");
        response.getWriter().println(new Date(engine.getStartupTime()));
        response.getWriter().println("</td>");
        response.getWriter().println("</tr>");
        response.getWriter().println("<tr>");
        response.getWriter().println("<td>");
        response.getWriter().println("Current Time:");
        response.getWriter().println("</td>");
        response.getWriter().println("<td>");
        response.getWriter().println(new Date());
        response.getWriter().println("</td>");
        response.getWriter().println("</tr>");
        response.getWriter().println("<tr>");
        response.getWriter().println("<td>");
        response.getWriter().println("Available Processors:");
        response.getWriter().println("</td>");
        response.getWriter().println("<td>");
        response.getWriter().println(Runtime.getRuntime().availableProcessors());
        response.getWriter().println("</td>");
        response.getWriter().println("</tr>");
        response.getWriter().println("<tr>");
        response.getWriter().println("<td>");
        response.getWriter().println("Active Threads:");
        response.getWriter().println("</td>");
        response.getWriter().println("<td>");
        response.getWriter().println(Thread.activeCount());
        response.getWriter().println("</td>");
        response.getWriter().println("</tr>");
        response.getWriter().println("<tr>");
        response.getWriter().println("<td>");
        response.getWriter().println("Max Memory (in Bytes):");
        response.getWriter().println("</td>");
        response.getWriter().println("<td>");
        response.getWriter().println(Runtime.getRuntime().maxMemory());
        response.getWriter().println("</td>");
        response.getWriter().println("</tr>");
        response.getWriter().println("<tr>");
        response.getWriter().println("<td>");
        response.getWriter().println("Total Memory (in Bytes):");
        response.getWriter().println("</td>");
        response.getWriter().println("<td>");
        response.getWriter().println(Runtime.getRuntime().totalMemory());
        response.getWriter().println("</td>");
        response.getWriter().println("</tr>");
        response.getWriter().println("<tr>");
        response.getWriter().println("<td>");
        response.getWriter().println("Free Memory (in Bytes):");
        response.getWriter().println("</td>");
        response.getWriter().println("<td>");
        response.getWriter().println(Runtime.getRuntime().freeMemory());
        response.getWriter().println("</td>");
        response.getWriter().println("</tr>");
        response.getWriter().println("<tr>");
        response.getWriter().println("<td>");
        response.getWriter().println("Free Memory / Total Memory:");
        response.getWriter().println("</td>");
        response.getWriter().println("<td>");
        response.getWriter().println(Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().totalMemory() + "%");
        response.getWriter().println("</td>");
        response.getWriter().println("</tr>");
        response.getWriter().println("</table>");
        response.getWriter().println("</HTML>");
    }

    private void thread(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.getWriter().println("</table>");
        response.getWriter().println("<HTML>");
        response.getWriter().println("<H1>");
        response.getWriter().println("<a href=" + request.getServletPath() + ">");
        response.getWriter().println("Main");
        response.getWriter().println("</a>");
        response.getWriter().println(" : ");
        response.getWriter().println("Thread Listing");
        response.getWriter().println("</H1>");
        response.getWriter().println("<p>");
        response.getWriter().println("<table width=100% border=1>");
        response.getWriter().println("<tr>");
        response.getWriter().println("<td>");
        response.getWriter().println("<b>");
        response.getWriter().println("#");
        response.getWriter().println("</b>");
        response.getWriter().println("</td>");
        response.getWriter().println("<td>");
        response.getWriter().println("<b>");
        response.getWriter().println("Name");
        response.getWriter().println("</b>");
        response.getWriter().println("</td>");
        response.getWriter().println("<td>");
        response.getWriter().println("<b>");
        response.getWriter().println("Priority");
        response.getWriter().println("</b>");
        response.getWriter().println("</td>");
        response.getWriter().println("<td>");
        response.getWriter().println("<b>");
        response.getWriter().println("isDaemon");
        response.getWriter().println("</b>");
        response.getWriter().println("</td>");
        response.getWriter().println("</tr>");
        int active = Thread.activeCount();
        Thread[] threads = new Thread[active];
        int c = Thread.enumerate(threads);
        for (int i = 0; i < c; ++i) {
            response.getWriter().println("<tr>");
            response.getWriter().println("<td>");
            response.getWriter().println(i);
            response.getWriter().println("</td>");
            response.getWriter().println("<td>");
            response.getWriter().println(threads[i].getName());
            response.getWriter().println("</td>");
            response.getWriter().println("<td>");
            response.getWriter().println(threads[i].getPriority());
            response.getWriter().println("</td>");
            response.getWriter().println("<td>");
            if (threads[i].isDaemon()) {
                response.getWriter().println("true");
            } else {
                response.getWriter().println("false");
            }
            response.getWriter().println("</td>");
            response.getWriter().println("</tr>");
        }
        response.getWriter().println("</table>");
        response.getWriter().println("</HTML>");
    }
}

