/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.servlet.csadmin.Configurator;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.xml.XMLObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAuthentication
extends AuthManager {
    public static Logger logger = LoggerFactory.getLogger(TokenAuthentication.class);
    public static final String CRED_SESSION_ID = "sessionID";
    protected String[] mRequiredCreds = new String[]{"sessionID"};

    @Override
    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        this.authenticationConfig = authenticationConfig;
        this.mName = name;
        this.mImplName = implName;
        this.mConfig = config;
    }

    @Override
    public boolean isSSLClientRequired() {
        return false;
    }

    @Override
    public AuthToken authenticate(AuthCredentials authCred) throws EMissingCredential, EInvalidCredentials, EBaseException {
        logger.debug("TokenAuthentication: start");
        SessionContext context = SessionContext.getExistingContext();
        AuthToken authToken = new AuthToken(this);
        EngineConfig sconfig = this.engine.getConfig();
        String sessionId = (String)authCred.get(CRED_SESSION_ID);
        String givenHost = (String)authCred.get("clientHost");
        String authHost = sconfig.getString("securitydomain.host");
        int authAdminPort = sconfig.getInteger("securitydomain.httpsadminport");
        String authPath = "ca/admin/ca/tokenAuthenticate";
        String authURL = "https://" + authHost + ":" + authAdminPort + "/" + authPath;
        logger.info("TokenAuthentication: Authenticating session ID against security domain at " + authURL);
        MultivaluedHashMap content = new MultivaluedHashMap();
        content.putSingle((Object)CRED_SESSION_ID, (Object)sessionId);
        content.putSingle((Object)"hostname", (Object)givenHost);
        logger.debug("TokenAuthentication: content: " + (MultivaluedMap)content);
        String c = null;
        try {
            c = this.sendAuthRequest(authHost, authAdminPort, authPath, (MultivaluedMap<String, String>)content);
            if (c != null) {
                XMLObject xMLObject = new XMLObject((InputStream)new ByteArrayInputStream(c.getBytes()));
            }
        }
        catch (Exception e) {
            String message = "Unable to access security domain: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new EBaseException(message, (Throwable)e);
        }
        if (c != null) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(c.getBytes());
                XMLObject parser = null;
                try {
                    parser = new XMLObject((InputStream)bis);
                }
                catch (Exception e) {
                    logger.error("TokenAuthentication::authenticate() - Exception=" + e.getMessage(), (Throwable)e);
                    throw new EBaseException(e.toString());
                }
                String status = parser.getValue("Status");
                logger.debug("TokenAuthentication: status=" + status);
                if (!status.equals("0")) {
                    String error = parser.getValue("Error");
                    logger.error("TokenAuthentication: error: " + error);
                    throw new EBaseException(error);
                }
                String uid = parser.getValue("uid");
                String gid = parser.getValue("gid");
                String[] groups = new String[]{gid};
                authToken.set("uid", uid);
                authToken.set("groups", groups);
                if (context != null) {
                    logger.debug("SessionContext.USER_ID " + uid + " SessionContext.GROUP_ID " + gid);
                    context.put((Object)"userid", (Object)uid);
                    context.put((Object)"groupid", (Object)gid);
                }
                logger.debug("TokenAuthentication: authenticated uid=" + uid + ", gid=" + gid);
            }
            catch (EBaseException e) {
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return authToken;
    }

    private String sendAuthRequest(String authHost, int authPort, String authUrl, MultivaluedMap<String, String> content) throws Exception {
        String serverURL = "https://" + authHost + ":" + authPort;
        PKIClient client = Configurator.createClient(serverURL, null, null);
        return (String)client.post(authUrl, content, String.class);
    }

    @Override
    public String[] getRequiredCreds() {
        return this.mRequiredCreds;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void init(ConfigStore config) throws EProfileException {
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage(locale, "CMS_AUTHENTICATION_AGENT_NAME", new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage(locale, "CMS_AUTHENTICATION_AGENT_TEXT", new String[0]);
    }

    @Override
    public Enumeration<String> getValueNames() {
        Vector<String> v = new Vector<String>();
        v.addElement(CRED_SESSION_ID);
        return v.elements();
    }

    @Override
    public boolean isValueWriteable(String name) {
        return false;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        return null;
    }

    @Override
    public void populate(AuthToken token, Request request) throws EProfileException {
    }
}

