/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EAuthInternalError;
import com.netscape.certsrv.authentication.EAuthUserError;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.cms.authentication.DirBasedAuthentication;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldapconn.LDAPAuthenticationConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchResults;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalEnroll
extends DirBasedAuthentication {
    public static Logger logger = LoggerFactory.getLogger(PortalEnroll.class);
    protected static final String PROP_AUTHTYPE = "authtype";
    protected static final String PROP_BINDDN = "bindDN";
    protected static final String PROP_BINDPW = "bindPW";
    protected static final String PROP_HOST = "host";
    protected static final String PROP_PORT = "port";
    protected static final String PROP_SECURECONN = "secureConn";
    protected static final String PROP_VERSION = "version";
    protected static final String PROP_OBJECTCLASS = "objectclass";
    public static final String CRED_UID = "uid";
    public static final String CRED_PWD = "userPassword";
    protected static String[] mRequiredCreds = new String[]{"uid", "userPassword"};
    private ArgBlock argblk;
    private String mObjectClass = null;
    private String mBindDN = null;
    private String mBaseDN = null;
    private LdapBoundConnFactory mLdapFactory;
    private LDAPConnection mLdapConn = null;
    Vector<Enumeration<String>> mRequiredAttrs = null;
    Vector<Enumeration<String>> mOptionalAttrs = null;
    Vector<String> mObjClasses = null;
    protected static String[] mConfigParams = new String[]{"dnpattern", "ldap.ldapconn.host", "ldap.ldapconn.port", "ldap.ldapconn.secureConn", "ldap.ldapconn.version", "ldap.ldapauth.bindDN", "ldap.ldapauth.bindPWPrompt", "ldap.ldapauth.clientCertNickname", "ldap.ldapauth.authtype", "ldap.basedn", "ldap.objectclass", "ldap.minConns", "ldap.maxConns"};

    @Override
    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        super.init(authenticationConfig, name, implName, config);
        EngineConfig cs = this.engine.getConfig();
        LDAPAuthenticationConfig authConfig = this.mLdapConfig.getAuthenticationConfig();
        this.mBindDN = authConfig.getString(PROP_BINDDN);
        if (this.mBindDN == null || this.mBindDN.length() == 0 || this.mBindDN == "") {
            throw new EPropertyNotFound(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", "binddn"));
        }
        this.mBaseDN = this.mLdapConfig.getBaseDN();
        if (this.mBaseDN == null || this.mBaseDN.length() == 0 || this.mBaseDN == "") {
            throw new EPropertyNotFound(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", "basedn"));
        }
        this.mObjectClass = this.mLdapConfig.getString(PROP_OBJECTCLASS);
        if (this.mObjectClass == null || this.mObjectClass.length() == 0) {
            throw new EPropertyNotFound(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", PROP_OBJECTCLASS));
        }
        PKISocketConfig socketConfig = cs.getSocketConfig();
        this.mLdapFactory = new LdapBoundConnFactory("PortalEnroll");
        this.mLdapFactory.setCMSEngine(this.engine);
        this.mLdapFactory.init(socketConfig, this.mLdapConfig, this.engine.getPasswordStore());
        this.mLdapConn = this.mLdapFactory.getConn();
        logger.info("PortalEnroll: " + CMS.getLogMessage("CMS_AUTH_PORTAL_INIT", new Object[0]));
    }

    @Override
    public void init(ConfigStore config) throws EProfileException {
    }

    @Override
    protected String authenticate(LDAPConnection conn, AuthCredentials authCreds, AuthToken token) throws EBaseException {
        String uid = null;
        String pwd = null;
        String dn = null;
        this.argblk = authCreds.getArgBlock();
        try {
            uid = (String)authCreds.get(CRED_UID);
            if (uid == null) {
                throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_NULL_CREDENTIAL", CRED_UID));
            }
            pwd = (String)authCreds.get(CRED_PWD);
            if (pwd == null) {
                throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_NULL_CREDENTIAL", CRED_PWD));
            }
            if (pwd.equals("")) {
                throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
            }
            LDAPSearchResults res = conn.search(this.mBaseDN, 2, "(uid=" + uid + ")", null, false);
            if (res.hasMoreElements()) {
                res.nextElement();
                throw new EAuthUserError(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_ATTRIBUTE_VALUE", "UID already exists."));
            }
            dn = this.regist(token, uid);
            if (dn == null) {
                throw new EAuthUserError(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_ATTRIBUTE_VALUE", "Could not add user " + uid + "."));
            }
            conn.authenticate(dn, pwd);
            token.set(CRED_UID, uid);
            logger.info("PortalEnroll: portal authentication is done");
            return dn;
        }
        catch (LDAPException e) {
            switch (e.getLDAPResultCode()) {
                case 9: 
                case 32: {
                    logger.error("PortalEnroll: " + CMS.getLogMessage("CMS_AUTH_ADD_USER_ERROR", conn.getHost(), Integer.toString(conn.getPort())));
                    throw new EAuthInternalError(CMS.getUserMessage("CMS_AUTHENTICATION_INTERNAL_ERROR", "Check Configuration detail."));
                }
                case 49: {
                    logger.error("PortalEnroll: " + CMS.getLogMessage("CMS_AUTH_BAD_PASSWORD", uid));
                    throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
                }
                case 81: {
                    logger.error("PortalEnroll: " + CMS.getLogMessage("LDAP_SERVER_DOWN", new Object[0]));
                    throw new ELdapException(CMS.getUserMessage("CMS_LDAP_SERVER_UNAVAILABLE", conn.getHost(), "" + conn.getPort()));
                }
            }
            logger.error("PortalEnroll: " + CMS.getLogMessage("LDAP_ERROR", e.getMessage()));
            throw new ELdapException(CMS.getUserMessage("CMS_LDAP_OTHER_LDAP_EXCEPTION", e.errorCodeToString()));
        }
        catch (EBaseException e) {
            if (e.getMessage().equalsIgnoreCase(CMS.getUserMessage("CMS_BASE_ATTRIBUTE_NOT_FOUND", new String[0]))) {
                logger.error("PortalEnroll: " + CMS.getLogMessage("CMS_AUTH_MAKE_DN_ERROR", e.toString()), (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public String[] getConfigParams() {
        return mConfigParams;
    }

    @Override
    public String[] getExtendedPluginInfo() {
        String[] s = new String[]{"dnpattern;string;Template for cert Subject Name. ($dn.xxx - get value from user's LDAP DN.  $attr.yyy - get value from LDAP attributes in user's entry.) Default: " + DEFAULT_DNPATTERN, "ldap.ldapconn.host;string,required;LDAP host to connect to", "ldap.ldapconn.port;number,required;LDAP port number (default 389, or 636 if SSL)", "ldap.objectclass;string,required;SEE DOCUMENTATION for Object Class. Default is inetOrgPerson.", "ldap.ldapconn.secureConn;boolean;Use SSL to connect to directory?", "ldap.ldapconn.version;choice(3,2);LDAP protocol version", "ldap.ldapauth.bindDN;string,required;DN to bind as for Directory Manager. For example 'CN=Directory Manager'", "ldap.ldapauth.bindPWPrompt;password;Enter password used to bind as the above user", "ldap.ldapauth.authtype;choice(BasicAuth,SslClientAuth);How to bind to the directory (for pin removal only)", "ldap.ldapauth.clientCertNickname;string;If you want to use SSL client auth to the directory, set the client cert nickname here", "ldap.basedn;string,required;Base DN to start searching under. If your user's DN is 'uid=jsmith, o=company', you might want to use 'o=company' here", "ldap.minConns;number;number of connections to keep open to directory server", "ldap.maxConns;number;when needed, connection pool can grow to this many connections", "HELP_TEXT;This authentication plugin checks to see if a user exists in the directory. If not, then the user is created with the requested password.", "HELP_TOKEN;configuration-authrules-portalauth"};
        return s;
    }

    @Override
    public String[] getRequiredCreds() {
        return mRequiredCreds;
    }

    public String regist(AuthToken token, String uid) {
        String attrval;
        String attrname;
        String dn = "uid=" + uid + "," + this.mBaseDN;
        Vector<String> objectclass_values = null;
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        LDAPAttribute attr = new LDAPAttribute(PROP_OBJECTCLASS);
        this.mRequiredAttrs = new Vector();
        this.mOptionalAttrs = new Vector();
        this.mObjClasses = new Vector();
        LDAPSchema dirSchema = null;
        try {
            dirSchema = new LDAPSchema();
            dirSchema.fetchSchema(this.mLdapConn);
        }
        catch (LDAPException e) {
            logger.warn("PortalEnroll: " + CMS.getLogMessage("LDAP_ERROR", e.getMessage()), (Throwable)e);
        }
        this.initLdapAttrs(dirSchema, this.mObjectClass);
        objectclass_values = this.mObjClasses;
        for (int i = objectclass_values.size() - 1; i >= 0; --i) {
            attr.addValue(objectclass_values.elementAt(i));
        }
        attrs.add(attr);
        Enumeration<Enumeration<String>> objClasses = this.mRequiredAttrs.elements();
        Enumeration<String> attrnames = null;
        while (objClasses.hasMoreElements()) {
            attrnames = objClasses.nextElement();
            logger.debug("PortalEnroll: Required attrs:");
            while (attrnames.hasMoreElements()) {
                attrname = attrnames.nextElement();
                attrval = null;
                logger.debug("PortalEnroll: attrname is: " + attrname);
                if (attrname.equalsIgnoreCase(PROP_OBJECTCLASS)) continue;
                try {
                    attrval = this.argblk.getValueAsString(attrname);
                }
                catch (EBaseException e) {
                    if (e.getMessage().equalsIgnoreCase(CMS.getUserMessage("CMS_BASE_ATTRIBUTE_NOT_FOUND", new String[0]))) continue;
                }
                logger.debug("PortalEnroll: " + attrname + " = " + attrval);
                attrs.add(new LDAPAttribute(attrname, attrval));
            }
        }
        objClasses = this.mOptionalAttrs.elements();
        attrnames = null;
        while (objClasses.hasMoreElements()) {
            attrnames = objClasses.nextElement();
            logger.debug("PortalEnroll: Optional attrs:");
            while (attrnames.hasMoreElements()) {
                attrname = attrnames.nextElement();
                attrval = null;
                logger.debug("PortalEnroll: attrname is: " + attrname);
                try {
                    attrval = this.argblk.getValueAsString(attrname);
                }
                catch (EBaseException e) {
                    if (e.getMessage().equalsIgnoreCase(CMS.getUserMessage("CMS_BASE_ATTRIBUTE_NOT_FOUND", new String[0]))) continue;
                }
                logger.debug("PortalEnroll: " + attrname + " = " + attrval);
                if (attrval == null) continue;
                attrs.add(new LDAPAttribute(attrname, attrval));
            }
        }
        LDAPEntry entry = new LDAPEntry(dn, attrs);
        try {
            this.mLdapConn.add(entry);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 68) {
                logger.warn("PortalEnroll: " + CMS.getLogMessage("LDAP_ERROR", e.getMessage()));
            } else {
                logger.warn("PortalEnroll: " + CMS.getLogMessage("LDAP_ERROR", e.getMessage()), (Throwable)e);
            }
            return null;
        }
        logger.info("PortalEnroll: " + CMS.getLogMessage("CMS_AUTH_REGISTRATION_DONE", new Object[0]));
        return dn;
    }

    public void initLdapAttrs(LDAPSchema dirSchema, String oclass) {
        logger.debug("PortalEnroll: in initLdapAttrsAttrs");
        this.mObjClasses.addElement(oclass);
        if (oclass.equalsIgnoreCase("top")) {
            return;
        }
        try {
            LDAPObjectClassSchema objClass = dirSchema.getObjectClass(oclass);
            if (objClass == null) {
                return;
            }
            this.mRequiredAttrs.add(objClass.getRequiredAttributes());
            this.mOptionalAttrs.add(objClass.getOptionalAttributes());
            logger.debug("PortalEnroll: getting superiors for: " + oclass);
            String[] superiors = objClass.getSuperiors();
            logger.debug("PortalEnroll: got superiors, superiors.length=" + superiors.length);
            if (superiors.length == 0) {
                return;
            }
            for (int i = 0; i < superiors.length; ++i) {
                logger.debug("Portalenroll: superior" + i + "=" + superiors[i]);
                objClass = dirSchema.getObjectClass(superiors[i]);
                this.initLdapAttrs(dirSchema, superiors[i]);
            }
        }
        catch (Exception e) {
            logger.warn("PortalEnroll: " + CMS.getLogMessage("LDAP_ERROR", e.getMessage()), (Throwable)e);
        }
    }
}

