/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.acls;

import com.netscape.cms.authorization.ACL;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ACLEntry
implements Serializable {
    private static final long serialVersionUID = 422656406529200393L;
    protected Hashtable<String, String> mPerms = new Hashtable();
    protected String expressions = null;
    protected Type type = Type.DENY;
    protected String aclEntryString = null;

    private ACLEntry() {
    }

    public Type getType() {
        return this.type;
    }

    public void setACLEntryString(String s) {
        this.aclEntryString = s;
    }

    public String getACLEntryString() {
        return this.aclEntryString;
    }

    public void addPermission(ACL acl, String permission) {
        if (acl.checkRight(permission)) {
            this.mPerms.put(permission, permission);
        }
    }

    public Enumeration<String> permissions() {
        return this.mPerms.elements();
    }

    public void setAttributeExpressions(String expressions) {
        this.expressions = expressions;
    }

    public String getAttributeExpressions() {
        return this.expressions;
    }

    public boolean containPermission(String permission) {
        return this.mPerms.get(permission) != null;
    }

    public boolean checkPermission(String permission) {
        if (this.mPerms.get(permission) == null) {
            return false;
        }
        return this.type != Type.DENY;
    }

    public static ACLEntry parseACLEntry(ACL acl, String aclEntryString) {
        if (aclEntryString == null) {
            return null;
        }
        String te = aclEntryString.trim();
        int i = te.indexOf(32);
        String prefix = te.substring(0, i);
        String suffix = te.substring(i + 1).trim();
        ACLEntry entry = new ACLEntry();
        if (prefix.equals("allow")) {
            entry.type = Type.ALLOW;
        } else if (prefix.equals("deny")) {
            entry.type = Type.DENY;
        } else {
            return null;
        }
        i = suffix.indexOf(32);
        if (i <= 0) {
            return null;
        }
        prefix = suffix.substring(1, i - 1);
        suffix = suffix.substring(i + 1).trim();
        StringTokenizer st = new StringTokenizer(prefix, ",");
        while (st.hasMoreTokens()) {
            entry.addPermission(acl, st.nextToken());
        }
        entry.setAttributeExpressions(suffix);
        return entry;
    }

    public String toString() {
        StringBuffer entry = new StringBuffer();
        if (this.type == Type.DENY) {
            entry.append("deny (");
        } else {
            entry.append("allow (");
        }
        Enumeration<String> e = this.permissions();
        while (e.hasMoreElements()) {
            String p = e.nextElement();
            entry.append(p);
            if (!e.hasMoreElements()) continue;
            entry.append(",");
        }
        entry.append(") " + this.getAttributeExpressions());
        return entry.toString();
    }

    public static enum Type {
        ALLOW,
        DENY;

    }
}

