/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.kra;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.AsymKeyGenerationProcessedEvent;
import com.netscape.certsrv.logging.event.ServerSideKeygenEnrollKeygenProcessedEvent;
import com.netscape.certsrv.request.IService;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.security.IStorageKeyUnit;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.kra.KeyRecoveryAuthority;
import java.math.BigInteger;
import java.security.KeyPair;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.netscape.security.util.WrappingParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsymKeyGenService
implements IService {
    public static Logger logger = LoggerFactory.getLogger(AsymKeyGenService.class);
    private static final String ATTR_KEY_RECORD = "keyRecord";
    private static final String STATUS_ACTIVE = "active";
    private KeyRecoveryAuthority kra;
    private IStorageKeyUnit storageUnit = null;

    public AsymKeyGenService(KeyRecoveryAuthority kra) {
        this.kra = kra;
        this.storageUnit = kra.getStorageKeyUnit();
    }

    public boolean serviceRequest(Request request) throws EBaseException {
        String method = "AsymKeyGenService:serviceRequest: ";
        KRAEngine engine = KRAEngine.getInstance();
        KRAEngineConfig configStore = engine.getConfig();
        String owner = request.getExtDataInString("requestOwner");
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = owner;
        boolean isSSKeygen = false;
        String isSSKeygenStr = request.getExtDataInString("isServerSideKeygen");
        if (isSSKeygenStr != null && isSSKeygenStr.equalsIgnoreCase("true")) {
            logger.debug(method + "isServerSideKeygen = true");
            isSSKeygen = true;
        } else {
            logger.debug(method + "isServerSideKeygen = false");
        }
        String clientKeyId = request.getExtDataInString("clientKeyID");
        if (clientKeyId != null) {
            logger.debug(method + "clientKeyId = " + clientKeyId);
        } else {
            logger.debug(method + "clientKeyId not found");
        }
        String algorithm = request.getExtDataInString("keyGenAlgorithm");
        String keySizeStr = request.getExtDataInString("keyGenSize");
        int keySize = 2048;
        boolean isEC = false;
        Object errmsg = "";
        if (algorithm.toUpperCase().equals("EC")) {
            isEC = true;
            switch (keySizeStr) {
                case "nistp256": {
                    keySize = 256;
                    break;
                }
                case "nistp384": {
                    keySize = 384;
                    break;
                }
                case "nistp521": {
                    keySize = 521;
                    break;
                }
                default: {
                    logger.debug(method + "unknown EC key curve name: " + keySizeStr);
                    errmsg = "unknown EC key curve name: " + keySizeStr;
                    auditor.log((LogEvent)new ServerSideKeygenEnrollKeygenProcessedEvent(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, (String)errmsg));
                    throw new EBaseException("Errors in ServerSideKeygenEnroll generating Asymmetric key: " + (String)errmsg);
                }
            }
        } else {
            keySize = Integer.valueOf(keySizeStr);
        }
        String realm = request.getRealm();
        boolean allowEncDecrypt_archival = configStore.getBoolean("kra.allowEncDecrypt.archival", false);
        KeyPairGeneratorSpi.Usage[] usageList = null;
        String usageStr = request.getExtDataInString("keyGenUsages");
        if (usageStr != null) {
            String[] usages = usageStr.split(",");
            if (usages.length > 0) {
                usageList = new KeyPairGeneratorSpi.Usage[usages.length];
                block40: for (int i = 0; i < usages.length; ++i) {
                    switch (usages[i]) {
                        case "decrypt": {
                            usageList[i] = KeyPairGeneratorSpi.Usage.DECRYPT;
                            continue block40;
                        }
                        case "encrypt": {
                            usageList[i] = KeyPairGeneratorSpi.Usage.ENCRYPT;
                            continue block40;
                        }
                        case "wrap": {
                            usageList[i] = KeyPairGeneratorSpi.Usage.WRAP;
                            continue block40;
                        }
                        case "unwrap": {
                            usageList[i] = KeyPairGeneratorSpi.Usage.UNWRAP;
                            continue block40;
                        }
                        case "derive": {
                            usageList[i] = KeyPairGeneratorSpi.Usage.DERIVE;
                            continue block40;
                        }
                        case "sign": {
                            usageList[i] = KeyPairGeneratorSpi.Usage.SIGN;
                            continue block40;
                        }
                        case "sign_recover": {
                            usageList[i] = KeyPairGeneratorSpi.Usage.SIGN_RECOVER;
                            continue block40;
                        }
                        case "verify": {
                            usageList[i] = KeyPairGeneratorSpi.Usage.VERIFY;
                            continue block40;
                        }
                        case "verify_recover": {
                            usageList[i] = KeyPairGeneratorSpi.Usage.VERIFY_RECOVER;
                        }
                    }
                }
            } else {
                usageList = new KeyPairGeneratorSpi.Usage[]{KeyPairGeneratorSpi.Usage.DECRYPT, KeyPairGeneratorSpi.Usage.ENCRYPT};
            }
        }
        logger.debug("AsymKeyGenService: request id: " + request.getRequestId());
        logger.debug("AsymKeyGenService: algorithm: " + algorithm);
        KeyPair kp = null;
        try {
            kp = this.kra.generateKeyPair(algorithm.toUpperCase(), keySize, isEC ? keySizeStr : null, null, usageList, true);
        }
        catch (EBaseException e) {
            errmsg = "Unable to generate asymmetric key: " + e.getMessage();
            logger.error("AsymKeyGenService: " + (String)errmsg, (Throwable)e);
            if (isSSKeygen) {
                auditor.log((LogEvent)new ServerSideKeygenEnrollKeygenProcessedEvent(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, (String)errmsg));
                throw new EBaseException("Errors in ServerSideKeygenEnroll generating Asymmetric key: " + e, (Throwable)e);
            }
            this.auditAsymKeyGenRequestProcessed(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, null, (String)errmsg);
            throw new EBaseException((String)errmsg, (Throwable)e);
        }
        if (kp == null) {
            errmsg = "Unable to generate asymmetric key";
            logger.error("AsymKeyGenService: " + (String)errmsg);
            if (isSSKeygen) {
                auditor.log((LogEvent)new ServerSideKeygenEnrollKeygenProcessedEvent(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, (String)errmsg));
                throw new EBaseException("Errors in ServerSideKeygenEnroll generating Asymmetric key: " + (String)errmsg);
            }
            this.auditAsymKeyGenRequestProcessed(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, null, (String)errmsg);
            throw new EBaseException((String)errmsg);
        }
        if (isSSKeygen) {
            byte[] publicKeyData = null;
            String pubKeyStr = "";
            try {
                publicKeyData = kp.getPublic().getEncoded();
                if (publicKeyData == null) {
                    request.setExtData("Result", Integer.valueOf(4));
                    errmsg = " failed getting publickey encoded";
                    logger.debug(method + (String)errmsg);
                    auditor.log((LogEvent)new ServerSideKeygenEnrollKeygenProcessedEvent(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, (String)errmsg));
                    throw new EBaseException("Errors in ServerSideKeygenEnroll generating Asymmetric key: " + (String)errmsg);
                }
                pubKeyStr = CryptoUtil.base64Encode((byte[])publicKeyData);
                request.setExtData("public_key", pubKeyStr);
            }
            catch (Exception e) {
                logger.debug(method + e);
                request.setExtData("Result", Integer.valueOf(4));
                auditor.log((LogEvent)new ServerSideKeygenEnrollKeygenProcessedEvent(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, e.getMessage()));
                throw new EBaseException("Errors in ServerSideKeygenEnroll generating Asymmetric key: " + e, (Throwable)e);
            }
        }
        byte[] privateSecurityData = null;
        WrappingParams params = null;
        try {
            params = this.storageUnit.getWrappingParams(allowEncDecrypt_archival);
            privateSecurityData = this.storageUnit.wrap((PrivateKey)kp.getPrivate(), params);
        }
        catch (Exception e) {
            errmsg = "Unable to wrap asymmetric key: " + e.getMessage();
            logger.error("AsymKeyGenService: " + (String)errmsg, (Throwable)e);
            if (isSSKeygen) {
                auditor.log((LogEvent)new ServerSideKeygenEnrollKeygenProcessedEvent(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, (String)errmsg));
                throw new EBaseException("Errors in ServerSideKeygenEnroll generating Asymmetric key: " + e, (Throwable)e);
            }
            this.auditAsymKeyGenRequestProcessed(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, null, (String)errmsg);
            throw new EBaseException((String)errmsg, (Throwable)e);
        }
        if (owner == null) {
            owner = request.getExtDataInString("auth_token-userdn");
        }
        KeyRecord record = new KeyRecord(null, kp.getPublic().getEncoded(), privateSecurityData, isSSKeygen ? clientKeyId : owner, algorithm, owner);
        KeyRepository storage = this.kra.getKeyRepository();
        BigInteger serialNo = storage.getNextSerialNumber();
        if (serialNo == null) {
            errmsg = "Unable to get next key ID";
            logger.error("AsymKeyGenService: " + (String)errmsg);
            if (isSSKeygen) {
                errmsg = "Failed to get next Key ID";
                auditor.log((LogEvent)new ServerSideKeygenEnrollKeygenProcessedEvent(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, (String)errmsg));
                throw new EBaseException("Errors in ServerSideKeygenEnroll generating Asymmetric key: " + (String)errmsg);
            }
            this.auditAsymKeyGenRequestProcessed(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, null, (String)errmsg);
            throw new EBaseException((String)errmsg);
        }
        record.set("clientId", (Object)clientKeyId);
        record.setSerialNumber(serialNo);
        record.set("keySerialNumber", (Object)serialNo);
        record.set("dataType", (Object)"asymmetricKey");
        record.set("status", (Object)STATUS_ACTIVE);
        record.set("keySize", (Object)keySize);
        request.setExtData(ATTR_KEY_RECORD, serialNo);
        request.setExtData("serialNumber", serialNo);
        if (realm != null) {
            record.set("realm", (Object)realm);
        }
        try {
            record.setWrappingParams(params, allowEncDecrypt_archival);
        }
        catch (Exception e) {
            errmsg = "Unable to store wrapping parameters: " + e.getMessage();
            logger.error("AsymKeyGenService: " + (String)errmsg);
            if (isSSKeygen) {
                auditor.log((LogEvent)new ServerSideKeygenEnrollKeygenProcessedEvent(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, (String)errmsg));
                throw new EBaseException("Errors in ServerSideKeygenEnroll generating Asymmetric key: " + (String)errmsg, (Throwable)e);
            }
            this.auditAsymKeyGenRequestProcessed(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, null, (String)errmsg);
            throw new EBaseException((String)errmsg, (Throwable)e);
        }
        storage.addKeyRecord(record);
        if (isSSKeygen) {
            auditor.log((LogEvent)new ServerSideKeygenEnrollKeygenProcessedEvent(auditSubjectID, "Success", request.getRequestId(), clientKeyId, null));
        } else {
            this.auditAsymKeyGenRequestProcessed(auditSubjectID, "Success", request.getRequestId(), clientKeyId, new KeyId(serialNo), "None");
        }
        request.setExtData("Result", Request.RES_SUCCESS);
        engine.getRequestRepository().updateRequest(request);
        return true;
    }

    private void auditAsymKeyGenRequestProcessed(String subjectID, String status, RequestId requestID, String clientKeyID, KeyId keyID, String reason) {
        KRAEngine engine = KRAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        auditor.log((LogEvent)new AsymKeyGenerationProcessedEvent(subjectID, status, requestID, clientKeyID, keyID, reason));
    }
}

