/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.key;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.SecurityDataRecoveryStateChangeEvent;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.kra.KeyRecoveryAuthority;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="kraKRAGrantAsyncRecovery", urlPatterns={"/agent/kra/grantAsyncRecovery"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="kra"), @WebInitParam(name="templatePath", value="/agent/kra/grantAsyncRecovery.template"), @WebInitParam(name="ID", value="kraKRAGrantAsyncRecovery"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.kra.key")})
public class GrantAsyncRecovery
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(GrantAsyncRecovery.class);
    private static final long serialVersionUID = -4200111795169532676L;
    private static final String INFO = "grantAsyncRecovery";
    private static final String TPL_FILE = "grantAsyncRecovery.template";
    private static final String OUT_OP = "op";
    private static final String OUT_SERVICE_URL = "serviceURL";
    private static final String OUT_ERROR = "errorDetails";
    private KeyRecoveryAuthority mService;
    private String mFormPath = null;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/kra/grantAsyncRecovery.template";
        KRAEngine engine = KRAEngine.getInstance();
        this.mService = engine.getKRA();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    public String getServletInfo() {
        return INFO;
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        logger.debug("GrantAsyncRecovery: process() begins");
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "recover");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        String agentID = authToken.getInString("uid");
        logger.debug("GrantAsyncRecovery: process() agent uid=" + agentID);
        logger.debug("GrantAsyncRecovery: process() request id=" + req.getParameter("reqID"));
        try {
            this.process(argSet, header, req.getParameter("reqID"), agentID, req, resp, locale[0]);
        }
        catch (NumberFormatException e) {
            header.addStringValue(OUT_ERROR, CMS.getUserMessage((Locale)locale[0], (String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            resp.setContentType("text/html");
            form.renderOutput((OutputStream)out, argSet);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, String reqID, String agentID, HttpServletRequest req, HttpServletResponse resp, Locale locale) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        try {
            header.addStringValue(OUT_OP, req.getParameter(OUT_OP));
            header.addStringValue(OUT_SERVICE_URL, req.getRequestURI());
            this.mService.addAgentAsyncKeyRecovery(reqID, agentID);
            header.addStringValue("requestID", reqID);
            header.addStringValue("agentID", agentID);
            auditor.log((LogEvent)new SecurityDataRecoveryStateChangeEvent(auditSubjectID, "Success", new RequestId(reqID), "approve"));
        }
        catch (Exception e) {
            header.addStringValue(OUT_ERROR, e.toString());
            auditor.log((LogEvent)new SecurityDataRecoveryStateChangeEvent(auditSubjectID, "Failure", new RequestId(reqID), "approve"));
        }
    }
}

