/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.connector;

import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.request.KeyRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="kraTokenKeyRecovery", urlPatterns={"/agent/kra/TokenKeyRecovery"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="kra"), @WebInitParam(name="ID", value="kraTokenKeyRecovery"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.kra.TokenKeyRecovery")})
public class TokenKeyRecoveryServlet
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(TokenKeyRecoveryServlet.class);
    private static final long serialVersionUID = -2322410659376501336L;
    private static final String INFO = "TokenKeyRecoveryServlet";
    public static final String PROP_AUTHORITY = "authority";
    protected ServletConfig mConfig = null;
    protected IAuthority mAuthority = null;
    public static int ERROR = 1;
    PrettyPrintFormat pp = new PrettyPrintFormat(":");
    protected AuthSubsystem mAuthSubsystem;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        KRAEngine engine = KRAEngine.getInstance();
        this.mConfig = config;
        String authority = config.getInitParameter(PROP_AUTHORITY);
        if (authority != null) {
            this.mAuthority = (IAuthority)engine.getSubsystem(authority);
        }
        this.mAuthSubsystem = engine.getAuthSubsystem();
    }

    public String getServletInfo() {
        return INFO;
    }

    protected String URLdecode(String s) {
        if (s == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '+') {
                out.write(32);
                continue;
            }
            if (c == '%') {
                int c1 = Character.digit(s.charAt(++i), 16);
                int c2 = Character.digit(s.charAt(++i), 16);
                out.write((char)(c1 * 16 + c2));
                continue;
            }
            out.write(c);
        }
        return out.toString();
    }

    private void processTokenKeyRecovery(HttpServletRequest req, HttpServletResponse resp) throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        KeyRequestRepository requestRepository = engine.getKeyRequestRepository();
        RequestQueue queue = engine.getRequestQueue();
        Request thisreq = null;
        boolean missingParam = false;
        String status = "0";
        logger.debug("processTokenKeyRecovery begins:");
        String rCUID = req.getParameter("tokencuid");
        String rUserid = req.getParameter("userid");
        String rKeyid = req.getParameter("keyid");
        String rdesKeyString = req.getParameter("drm_trans_desKey");
        String rCert = req.getParameter("cert");
        if (rCUID == null || rCUID.equals("")) {
            logger.warn("TokenKeyRecoveryServlet: processTokenKeyRecovery(): missing request parameter: CUID");
            missingParam = true;
        }
        if (rUserid == null || rUserid.equals("")) {
            logger.warn("TokenKeyRecoveryServlet: processTokenKeyRecovery(): missing request parameter: userid");
            missingParam = true;
        }
        if (rdesKeyString == null || rdesKeyString.equals("")) {
            logger.warn("TokenKeyRecoveryServlet: processTokenKeyRecovery(): missing request parameter: DRM-transportKey-wrapped des key");
            missingParam = true;
        }
        if ((rCert == null || rCert.equals("")) && (rKeyid == null || rKeyid.equals(""))) {
            logger.warn("TokenKeyRecoveryServlet: processTokenKeyRecovery(): missing request parameter: cert or keyid");
            missingParam = true;
        }
        if (!missingParam) {
            thisreq = requestRepository.createRequest("netkeyKeyRecovery");
            thisreq.setExtData("requestorType", "NETKEY_RA");
            thisreq.setExtData("CUID", rCUID);
            thisreq.setExtData("USERID", rUserid);
            thisreq.setExtData("drm_trans_desKey", rdesKeyString);
            if (rCert != null && !rCert.equals("")) {
                thisreq.setExtData("cert", rCert);
                logger.debug("TokenKeyRecoveryServlet: processTokenKeyRecovery(): received request parameter: cert");
            }
            if (rKeyid != null && !rKeyid.equals("")) {
                thisreq.setExtData("keyid", rKeyid);
                logger.debug("TokenKeyRecoveryServlet: processTokenKeyRecovery(): received request parameter: keyid");
            }
            queue.processRequest(thisreq);
            Integer result = thisreq.getExtDataInInteger("Result");
            status = result != null ? (result == 1 ? "0" : result.toString()) : "7";
            logger.debug("processTokenKeyRecovery finished");
        }
        Object value = "";
        resp.setContentType("application/x-www-form-urlencoded");
        String wrappedPrivKeyString = "";
        String publicKeyString = "";
        String ivString = "";
        if (thisreq == null) {
            logger.error("TokenKeyRecoveryServlet::processTokenKeyRecovery() - thisreq is null!");
            throw new EBaseException("thisreq is null");
        }
        publicKeyString = thisreq.getExtDataInString("public_key");
        wrappedPrivKeyString = thisreq.getExtDataInString("wrappedUserPrivate");
        ivString = thisreq.getExtDataInString("iv_s");
        thisreq.setExtData("wrappedUserPrivate", "");
        thisreq.setExtData("public_key", "");
        thisreq.setExtData("iv_s", "");
        thisreq.setExtData("drm_trans_desKey", "");
        thisreq.deleteExtData("wrappedUserPrivate");
        thisreq.deleteExtData("public_key");
        thisreq.deleteExtData("iv_s");
        thisreq.deleteExtData("drm_trans_desKey");
        thisreq.setExtData("delayLDAPCommit", "false");
        requestRepository.updateRequest(thisreq);
        if (!status.equals("0")) {
            value = "status=" + status;
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("status=0&");
            sb.append("wrapped_priv_key=");
            sb.append(wrappedPrivKeyString);
            sb.append("&public_key=");
            sb.append(publicKeyString);
            sb.append("&iv_param=");
            sb.append(ivString);
            value = sb.toString();
        }
        try {
            resp.setContentLength(((String)value).length());
            logger.debug("TokenKeyRecoveryServlet:outputString.length " + ((String)value).length());
            ServletOutputStream ooss = resp.getOutputStream();
            ooss.write(((String)value).getBytes());
            ooss.flush();
            this.mRenderResult = false;
        }
        catch (IOException e) {
            logger.warn("TokenKeyRecoveryServlet: " + e.getMessage(), (Throwable)e);
        }
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "submit");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            try {
                resp.setContentType("application/x-www-form-urlencoded");
                String value = "unauthorized=";
                logger.debug("TokenKeyRecoveryServlet: Unauthorized");
                resp.setContentLength(value.length());
                ServletOutputStream ooss = resp.getOutputStream();
                ooss.write(value.getBytes());
                ooss.flush();
                this.mRenderResult = false;
            }
            catch (Exception e) {
                logger.warn("TokenKeyRecoveryServlet: " + e.getMessage(), (Throwable)e);
            }
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        logger.debug("TokenKeyRecoveryServlet: processTokenKeyRecovery would be called");
        this.processTokenKeyRecovery(req, resp);
    }
}

