/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.Tag;

public class ASN1Util {
    public static byte[] encode(ASN1Value val) {
        return ASN1Util.encode(val.getTag(), val);
    }

    public static byte[] encode(Tag implicitTag, ASN1Value val) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            val.encode(implicitTag, bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to encode byte array: " + e.getMessage(), e);
        }
    }

    public static ASN1Value decode(ASN1Template template, byte[] encoded) throws InvalidBERException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(encoded);
            return template.decode(bis);
        }
        catch (IOException e) {
            throw (InvalidBERException)new InvalidBERException("Unable to decode byte array: " + e.getMessage()).initCause(e);
        }
    }

    public static ASN1Value decode(Tag implicitTag, ASN1Template template, byte[] encoded) throws InvalidBERException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(encoded);
            return template.decode(implicitTag, bis);
        }
        catch (IOException e) {
            throw (InvalidBERException)new InvalidBERException("Unable to decode byte array: " + e.getMessage()).initCause(e);
        }
    }

    public static void readFully(byte[] bytes, InputStream istream) throws IOException {
        int nr;
        for (int numRead = 0; numRead < bytes.length; numRead += nr) {
            nr = istream.read(bytes, numRead, bytes.length - numRead);
            if (nr != -1) continue;
            throw new EOFException();
        }
    }

    public static byte[] getECCurveBytesByX509PublicKeyBytes(byte[] X509PubKeyBytes, boolean withHeader) throws IllegalArgumentException, ArrayIndexOutOfBoundsException, NullPointerException {
        byte[] curve;
        if (X509PubKeyBytes == null || X509PubKeyBytes.length == 0) {
            throw new IllegalArgumentException("X509PubKeyBytes null");
        }
        byte[] EC_PubOIDBytes_full = ASN1Util.encode(OBJECT_IDENTIFIER.EC_PUBKEY_OID);
        byte[] EC_PubOIDBytes = Arrays.copyOfRange(EC_PubOIDBytes_full, 2, EC_PubOIDBytes_full.length);
        int curveBeginIndex = 0;
        for (int idx = 0; idx <= X509PubKeyBytes.length; ++idx) {
            byte[] tmp = Arrays.copyOfRange(X509PubKeyBytes, idx, idx + EC_PubOIDBytes.length);
            if (!Arrays.equals(tmp, EC_PubOIDBytes)) continue;
            curveBeginIndex = idx + EC_PubOIDBytes.length;
            break;
        }
        byte curveByteArraySize = X509PubKeyBytes[curveBeginIndex + 1];
        if (withHeader) {
            curve = Arrays.copyOfRange(X509PubKeyBytes, curveBeginIndex, curveBeginIndex + curveByteArraySize + 2);
            return curve;
        }
        curve = Arrays.copyOfRange(X509PubKeyBytes, curveBeginIndex + 2, curveBeginIndex + 2 + curveByteArraySize);
        return curve;
    }

    public static String getOIDdescription(byte[] oidBA) {
        return ASN1Util.getTagDescriptionByOid(oidBA);
    }

    private static native String getTagDescriptionByOid(byte[] var0);
}

