"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMonoid = exports.getEq = exports.getShow = exports.URI = exports.separate = exports.compact = exports.reduceRight = exports.foldMap = exports.reduce = exports.partitionMap = exports.partition = exports.filterMap = exports.filter = exports.difference = exports.intersection = exports.union = exports.elem = exports.some = exports.every = exports.fromFoldableMap = exports.fromFoldable = exports.filterWithIndex = exports.filterMapWithIndex = exports.partitionWithIndex = exports.partitionMapWithIndex = exports.wilt = exports.wither = exports.sequence = exports.traverse = exports.traverseWithIndex = exports.singleton = exports.reduceRightWithIndex = exports.foldMapWithIndex = exports.reduceWithIndex = exports.map = exports.mapWithIndex = exports.lookup = exports.isSubrecord = exports.pop = exports.modifyAt = exports.updateAt = exports.deleteAt = exports.has = exports.upsertAt = exports.toUnfoldable = exports.toArray = exports.collect = exports.keys = exports.isEmpty = exports.size = void 0;
exports.record = exports.hasOwnProperty = exports.insertAt = exports.empty = exports.Witherable = exports.TraversableWithIndex = exports.Traversable = exports.FoldableWithIndex = exports.Foldable = exports.getDifferenceMagma = exports.getIntersectionSemigroup = exports.getUnionMonoid = exports.getUnionSemigroup = exports.getWitherable = exports.getTraversableWithIndex = exports.getTraversable = exports.FilterableWithIndex = exports.Filterable = exports.Compactable = exports.getFoldableWithIndex = exports.getFoldable = exports.FunctorWithIndex = exports.flap = exports.Functor = void 0;
var function_1 = require("./function");
var Functor_1 = require("./Functor");
var _ = __importStar(require("./internal"));
var RR = __importStar(require("./ReadonlyRecord"));
var S = __importStar(require("./string"));
var Witherable_1 = require("./Witherable");
// -------------------------------------------------------------------------------------
// model
// -------------------------------------------------------------------------------------
/**
 * Calculate the number of key/value pairs in a `Record`.
 *
 * @since 2.0.0
 */
exports.size = RR.size;
/**
 * Test whether a `Record` is empty.
 *
 * @since 2.0.0
 */
exports.isEmpty = RR.isEmpty;
var keys_ = function (O) { return function (r) {
    return Object.keys(r).sort(O.compare);
}; };
/**
 * @since 2.0.0
 */
exports.keys = 
/*#__PURE__*/
keys_(S.Ord);
function collect(O) {
    if (typeof O === 'function') {
        return collect(S.Ord)(O);
    }
    var keysO = keys_(O);
    return function (f) { return function (r) {
        var out = [];
        for (var _i = 0, _a = keysO(r); _i < _a.length; _i++) {
            var key = _a[_i];
            out.push(f(key, r[key]));
        }
        return out;
    }; };
}
exports.collect = collect;
/**
 * Get a sorted `Array` of the key/value pairs contained in a `Record`.
 *
 * @since 2.0.0
 */
exports.toArray = 
/*#__PURE__*/
collect(S.Ord)(function (k, a) { return [k, a]; });
function toUnfoldable(U) {
    return function (r) {
        var sas = exports.toArray(r);
        var len = sas.length;
        return U.unfold(0, function (b) { return (b < len ? _.some([sas[b], b + 1]) : _.none); });
    };
}
exports.toUnfoldable = toUnfoldable;
/**
 * Insert or replace a key/value pair in a `Record`.
 *
 * @category combinators
 * @since 2.10.0
 */
exports.upsertAt = RR.upsertAt;
/**
 * Test whether or not a key exists in a `Record`.
 *
 * Note. This function is not pipeable because is a `Refinement`.
 *
 * @since 2.10.0
 */
exports.has = RR.has;
function deleteAt(k) {
    return function (r) {
        if (!_.has.call(r, k)) {
            return r;
        }
        var out = Object.assign({}, r);
        delete out[k];
        return out;
    };
}
exports.deleteAt = deleteAt;
/**
 * @since 2.0.0
 */
var updateAt = function (k, a) {
    return exports.modifyAt(k, function () { return a; });
};
exports.updateAt = updateAt;
/**
 * @since 2.0.0
 */
var modifyAt = function (k, f) { return function (r) {
    if (!exports.has(k, r)) {
        return _.none;
    }
    var out = Object.assign({}, r);
    out[k] = f(r[k]);
    return _.some(out);
}; };
exports.modifyAt = modifyAt;
function pop(k) {
    var deleteAtk = deleteAt(k);
    return function (r) {
        var oa = exports.lookup(k, r);
        return _.isNone(oa) ? _.none : _.some([oa.value, deleteAtk(r)]);
    };
}
exports.pop = pop;
// TODO: remove non-curried overloading in v3
/**
 * Test whether one `Record` contains all of the keys and values contained in another `Record`.
 *
 * @since 2.0.0
 */
exports.isSubrecord = RR.isSubrecord;
// TODO: remove non-curried overloading in v3
/**
 * Lookup the value for a key in a `Record`.
 *
 * @since 2.0.0
 */
exports.lookup = RR.lookup;
/**
 * Map a `Record` passing the keys to the iterating function.
 *
 * @since 2.0.0
 */
exports.mapWithIndex = RR.mapWithIndex;
/**
 * Map a `Record` passing the values to the iterating function.
 *
 * @since 2.0.0
 */
exports.map = RR.map;
function reduceWithIndex() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    return args.length === 1 ? RR.reduceWithIndex(args[0]) : RR.reduceWithIndex(S.Ord).apply(void 0, args);
}
exports.reduceWithIndex = reduceWithIndex;
function foldMapWithIndex(O) {
    return 'compare' in O ? RR.foldMapWithIndex(O) : RR.foldMapWithIndex(S.Ord)(O);
}
exports.foldMapWithIndex = foldMapWithIndex;
function reduceRightWithIndex() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    return args.length === 1 ? RR.reduceRightWithIndex(args[0]) : RR.reduceRightWithIndex(S.Ord).apply(void 0, args);
}
exports.reduceRightWithIndex = reduceRightWithIndex;
/**
 * Create a `Record` with one key/value pair.
 *
 * @since 2.0.0
 */
exports.singleton = RR.singleton;
function traverseWithIndex(F) {
    return RR.traverseWithIndex(F);
}
exports.traverseWithIndex = traverseWithIndex;
function traverse(F) {
    return RR.traverse(F);
}
exports.traverse = traverse;
function sequence(F) {
    return RR.sequence(F);
}
exports.sequence = sequence;
/**
 * @category Witherable
 * @since 2.6.5
 */
var wither = function (F) {
    var traverseF = traverse(F);
    return function (f) { return function (fa) { return F.map(function_1.pipe(fa, traverseF(f)), exports.compact); }; };
};
exports.wither = wither;
/**
 * @category Witherable
 * @since 2.6.5
 */
var wilt = function (F) {
    var traverseF = traverse(F);
    return function (f) { return function (fa) { return F.map(function_1.pipe(fa, traverseF(f)), exports.separate); }; };
};
exports.wilt = wilt;
/**
 * @since 2.0.0
 */
exports.partitionMapWithIndex = RR.partitionMapWithIndex;
function partitionWithIndex(predicateWithIndex) {
    return RR.partitionWithIndex(predicateWithIndex);
}
exports.partitionWithIndex = partitionWithIndex;
/**
 * @since 2.0.0
 */
exports.filterMapWithIndex = RR.filterMapWithIndex;
function filterWithIndex(predicateWithIndex) {
    return RR.filterWithIndex(predicateWithIndex);
}
exports.filterWithIndex = filterWithIndex;
function fromFoldable(M, F) {
    return RR.fromFoldable(M, F);
}
exports.fromFoldable = fromFoldable;
function fromFoldableMap(M, F) {
    return RR.fromFoldableMap(M, F);
}
exports.fromFoldableMap = fromFoldableMap;
/**
 * @since 2.0.0
 */
exports.every = RR.every;
/**
 * @since 2.0.0
 */
exports.some = RR.some;
// TODO: remove non-curried overloading in v3
/**
 * @since 2.0.0
 */
exports.elem = RR.elem;
/**
 * @category combinators
 * @since 2.11.0
 */
var union = function (M) {
    var unionM = RR.union(M);
    return function (second) { return function (first) {
        if (exports.isEmpty(first)) {
            return __assign({}, second);
        }
        if (exports.isEmpty(second)) {
            return __assign({}, first);
        }
        return unionM(second)(first);
    }; };
};
exports.union = union;
/**
 * @category combinators
 * @since 2.11.0
 */
var intersection = function (M) { return function (second) { return function (first) {
    if (exports.isEmpty(first) || exports.isEmpty(second)) {
        return {};
    }
    return RR.intersection(M)(second)(first);
}; }; };
exports.intersection = intersection;
/**
 * @category combinators
 * @since 2.11.0
 */
var difference = function (second) { return function (first) {
    if (exports.isEmpty(first)) {
        return __assign({}, second);
    }
    if (exports.isEmpty(second)) {
        return __assign({}, first);
    }
    return RR.difference(second)(first);
}; };
exports.difference = difference;
// -------------------------------------------------------------------------------------
// non-pipeables
// -------------------------------------------------------------------------------------
var _map = RR._map;
var _mapWithIndex = RR._mapWithIndex;
var _reduce = RR._reduce;
var _foldMap = RR._foldMap;
var _reduceRight = RR._reduceRight;
var _filter = RR._filter;
var _filterMap = RR._filterMap;
var _partition = RR._partition;
var _partitionMap = RR._partitionMap;
var _reduceWithIndex = RR._reduceWithIndex;
var _foldMapWithIndex = RR._foldMapWithIndex;
var _reduceRightWithIndex = RR._reduceRightWithIndex;
var _partitionMapWithIndex = RR._partitionMapWithIndex;
var _partitionWithIndex = RR._partitionWithIndex;
var _filterMapWithIndex = RR._filterMapWithIndex;
var _filterWithIndex = RR._filterWithIndex;
var _traverse = RR._traverse;
var _sequence = RR._sequence;
var _traverseWithIndex = function (O) { return function (F) {
    var keysO = keys_(O);
    return function (ta, f) {
        var ks = keysO(ta);
        if (ks.length === 0) {
            return F.of({});
        }
        var fr = F.of({});
        var _loop_1 = function (key) {
            fr = F.ap(F.map(fr, function (r) { return function (b) {
                r[key] = b;
                return r;
            }; }), f(key, ta[key]));
        };
        for (var _i = 0, ks_1 = ks; _i < ks_1.length; _i++) {
            var key = ks_1[_i];
            _loop_1(key);
        }
        return fr;
    };
}; };
// -------------------------------------------------------------------------------------
// type class members
// -------------------------------------------------------------------------------------
/**
 * @category Filterable
 * @since 2.0.0
 */
exports.filter = RR.filter;
/**
 * @category Filterable
 * @since 2.0.0
 */
exports.filterMap = RR.filterMap;
/**
 * @category Filterable
 * @since 2.0.0
 */
exports.partition = RR.partition;
/**
 * @category Filterable
 * @since 2.0.0
 */
exports.partitionMap = RR.partitionMap;
function reduce() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    return args.length === 1 ? RR.reduce(args[0]) : RR.reduce(S.Ord).apply(void 0, args);
}
exports.reduce = reduce;
function foldMap(O) {
    return 'compare' in O ? RR.foldMap(O) : RR.foldMap(S.Ord)(O);
}
exports.foldMap = foldMap;
function reduceRight() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    return args.length === 1 ? RR.reduceRight(args[0]) : RR.reduceRight(S.Ord).apply(void 0, args);
}
exports.reduceRight = reduceRight;
/**
 * @category Compactable
 * @since 2.0.0
 */
exports.compact = RR.compact;
/**
 * @category Compactable
 * @since 2.0.0
 */
exports.separate = RR.separate;
// -------------------------------------------------------------------------------------
// instances
// -------------------------------------------------------------------------------------
/**
 * @category instances
 * @since 2.0.0
 */
exports.URI = 'Record';
function getShow(O) {
    return 'compare' in O ? RR.getShow(O) : RR.getShow(S.Ord)(O);
}
exports.getShow = getShow;
/**
 * @category instances
 * @since 2.0.0
 */
exports.getEq = RR.getEq;
/**
 * Returns a `Monoid` instance for `Record`s given a `Semigroup` instance for their values.
 *
 * @example
 * import { SemigroupSum } from 'fp-ts/number'
 * import { getMonoid } from 'fp-ts/Record'
 *
 * const M = getMonoid(SemigroupSum)
 * assert.deepStrictEqual(M.concat({ foo: 123 }, { foo: 456 }), { foo: 579 })
 *
 * @category instances
 * @since 2.0.0
 */
exports.getMonoid = RR.getMonoid;
/**
 * @category instances
 * @since 2.7.0
 */
exports.Functor = {
    URI: exports.URI,
    map: _map
};
/**
 * Derivable from `Functor`.
 *
 * @category combinators
 * @since 2.10.0
 */
exports.flap = 
/*#_PURE_*/
Functor_1.flap(exports.Functor);
/**
 * @category instances
 * @since 2.7.0
 */
exports.FunctorWithIndex = {
    URI: exports.URI,
    map: _map,
    mapWithIndex: _mapWithIndex
};
/**
 * @category instances
 * @since 2.11.0
 */
var getFoldable = function (O) { return ({
    URI: exports.URI,
    reduce: _reduce(O),
    foldMap: _foldMap(O),
    reduceRight: _reduceRight(O)
}); };
exports.getFoldable = getFoldable;
/**
 * @category instances
 * @since 2.11.0
 */
var getFoldableWithIndex = function (O) { return ({
    URI: exports.URI,
    reduce: _reduce(O),
    foldMap: _foldMap(O),
    reduceRight: _reduceRight(O),
    reduceWithIndex: _reduceWithIndex(O),
    foldMapWithIndex: _foldMapWithIndex(O),
    reduceRightWithIndex: _reduceRightWithIndex(O)
}); };
exports.getFoldableWithIndex = getFoldableWithIndex;
/**
 * @category instances
 * @since 2.7.0
 */
exports.Compactable = {
    URI: exports.URI,
    compact: exports.compact,
    separate: exports.separate
};
/**
 * @category instances
 * @since 2.7.0
 */
exports.Filterable = {
    URI: exports.URI,
    map: _map,
    compact: exports.compact,
    separate: exports.separate,
    filter: _filter,
    filterMap: _filterMap,
    partition: _partition,
    partitionMap: _partitionMap
};
/**
 * @category instances
 * @since 2.7.0
 */
exports.FilterableWithIndex = {
    URI: exports.URI,
    map: _map,
    mapWithIndex: _mapWithIndex,
    compact: exports.compact,
    separate: exports.separate,
    filter: _filter,
    filterMap: _filterMap,
    partition: _partition,
    partitionMap: _partitionMap,
    filterMapWithIndex: _filterMapWithIndex,
    filterWithIndex: _filterWithIndex,
    partitionMapWithIndex: _partitionMapWithIndex,
    partitionWithIndex: _partitionWithIndex
};
/**
 * @category instances
 * @since 2.11.0
 */
var getTraversable = function (O) { return ({
    URI: exports.URI,
    map: _map,
    reduce: _reduce(O),
    foldMap: _foldMap(O),
    reduceRight: _reduceRight(O),
    traverse: _traverse(O),
    sequence: _sequence(O)
}); };
exports.getTraversable = getTraversable;
/**
 * @category instances
 * @since 2.11.0
 */
var getTraversableWithIndex = function (O) { return ({
    URI: exports.URI,
    map: _map,
    mapWithIndex: _mapWithIndex,
    reduce: _reduce(O),
    foldMap: _foldMap(O),
    reduceRight: _reduceRight(O),
    reduceWithIndex: _reduceWithIndex(O),
    foldMapWithIndex: _foldMapWithIndex(O),
    reduceRightWithIndex: _reduceRightWithIndex(O),
    traverse: _traverse(O),
    sequence: _sequence(O),
    traverseWithIndex: _traverseWithIndex(O)
}); };
exports.getTraversableWithIndex = getTraversableWithIndex;
/**
 * @category instances
 * @since 2.11.0
 */
var getWitherable = function (O) {
    var T = exports.getTraversable(O);
    return {
        URI: exports.URI,
        map: _map,
        reduce: _reduce(O),
        foldMap: _foldMap(O),
        reduceRight: _reduceRight(O),
        traverse: T.traverse,
        sequence: T.sequence,
        compact: exports.compact,
        separate: exports.separate,
        filter: _filter,
        filterMap: _filterMap,
        partition: _partition,
        partitionMap: _partitionMap,
        wither: Witherable_1.witherDefault(T, exports.Compactable),
        wilt: Witherable_1.wiltDefault(T, exports.Compactable)
    };
};
exports.getWitherable = getWitherable;
/**
 * @category instances
 * @since 2.11.0
 */
var getUnionSemigroup = function (S) {
    var unionS = exports.union(S);
    return {
        concat: function (first, second) { return unionS(second)(first); }
    };
};
exports.getUnionSemigroup = getUnionSemigroup;
/**
 * @category instances
 * @since 2.11.0
 */
var getUnionMonoid = function (S) { return ({
    concat: exports.getUnionSemigroup(S).concat,
    empty: {}
}); };
exports.getUnionMonoid = getUnionMonoid;
/**
 * @category instances
 * @since 2.11.0
 */
var getIntersectionSemigroup = function (S) {
    var intersectionS = exports.intersection(S);
    return {
        concat: function (first, second) { return intersectionS(second)(first); }
    };
};
exports.getIntersectionSemigroup = getIntersectionSemigroup;
/**
 * @category instances
 * @since 2.11.0
 */
var getDifferenceMagma = function () { return ({
    concat: function (first, second) { return exports.difference(second)(first); }
}); };
exports.getDifferenceMagma = getDifferenceMagma;
// -------------------------------------------------------------------------------------
// deprecated
// -------------------------------------------------------------------------------------
// tslint:disable: deprecation
/**
 * Use `getFoldable` instead.
 *
 * @category instances
 * @since 2.7.0
 * @deprecated
 */
exports.Foldable = {
    URI: exports.URI,
    reduce: _reduce(S.Ord),
    foldMap: _foldMap(S.Ord),
    reduceRight: _reduceRight(S.Ord)
};
/**
 * Use `getFoldableWithIndex` instead.
 *
 * @category instances
 * @since 2.7.0
 * @deprecated
 */
exports.FoldableWithIndex = {
    URI: exports.URI,
    reduce: _reduce(S.Ord),
    foldMap: _foldMap(S.Ord),
    reduceRight: _reduceRight(S.Ord),
    reduceWithIndex: _reduceWithIndex(S.Ord),
    foldMapWithIndex: _foldMapWithIndex(S.Ord),
    reduceRightWithIndex: _reduceRightWithIndex(S.Ord)
};
/**
 * Use `getTraversable` instead.
 *
 * @category instances
 * @since 2.7.0
 * @deprecated
 */
exports.Traversable = {
    URI: exports.URI,
    map: _map,
    reduce: _reduce(S.Ord),
    foldMap: _foldMap(S.Ord),
    reduceRight: _reduceRight(S.Ord),
    traverse: _traverse(S.Ord),
    sequence: sequence
};
/**
 * Use the `getTraversableWithIndex` instead.
 *
 * @category instances
 * @since 2.7.0
 * @deprecated
 */
exports.TraversableWithIndex = {
    URI: exports.URI,
    map: _map,
    mapWithIndex: _mapWithIndex,
    reduce: _reduce(S.Ord),
    foldMap: _foldMap(S.Ord),
    reduceRight: _reduceRight(S.Ord),
    reduceWithIndex: _reduceWithIndex(S.Ord),
    foldMapWithIndex: _foldMapWithIndex(S.Ord),
    reduceRightWithIndex: _reduceRightWithIndex(S.Ord),
    traverse: _traverse(S.Ord),
    sequence: sequence,
    traverseWithIndex: _traverseWithIndex(S.Ord)
};
var _wither = Witherable_1.witherDefault(exports.Traversable, exports.Compactable);
var _wilt = Witherable_1.wiltDefault(exports.Traversable, exports.Compactable);
/**
 * Use `getWitherable` instead.
 *
 * @category instances
 * @since 2.7.0
 * @deprecated
 */
exports.Witherable = {
    URI: exports.URI,
    map: _map,
    reduce: _reduce(S.Ord),
    foldMap: _foldMap(S.Ord),
    reduceRight: _reduceRight(S.Ord),
    traverse: _traverse(S.Ord),
    sequence: sequence,
    compact: exports.compact,
    separate: exports.separate,
    filter: _filter,
    filterMap: _filterMap,
    partition: _partition,
    partitionMap: _partitionMap,
    wither: _wither,
    wilt: _wilt
};
/**
 * Use a new `{}` instead.
 *
 * @since 2.0.0
 * @deprecated
 */
exports.empty = {};
/**
 * Use [`upsertAt`](#upsertat) instead.
 *
 * @since 2.0.0
 * @deprecated
 */
exports.insertAt = exports.upsertAt;
/**
 * Use [`has`](#has) instead.
 *
 * @since 2.0.0
 * @deprecated
 */
exports.hasOwnProperty = RR.hasOwnProperty;
/**
 * Use small, specific instances instead.
 *
 * @category instances
 * @since 2.0.0
 * @deprecated
 */
exports.record = {
    URI: exports.URI,
    map: _map,
    reduce: _reduce(S.Ord),
    foldMap: _foldMap(S.Ord),
    reduceRight: _reduceRight(S.Ord),
    traverse: _traverse(S.Ord),
    sequence: sequence,
    compact: exports.compact,
    separate: exports.separate,
    filter: _filter,
    filterMap: _filterMap,
    partition: _partition,
    partitionMap: _partitionMap,
    mapWithIndex: _mapWithIndex,
    reduceWithIndex: _reduceWithIndex(S.Ord),
    foldMapWithIndex: _foldMapWithIndex(S.Ord),
    reduceRightWithIndex: _reduceRightWithIndex(S.Ord),
    filterMapWithIndex: _filterMapWithIndex,
    filterWithIndex: _filterWithIndex,
    partitionMapWithIndex: _partitionMapWithIndex,
    partitionWithIndex: _partitionWithIndex,
    traverseWithIndex: _traverseWithIndex(S.Ord),
    wither: _wither,
    wilt: _wilt
};
