"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const toHaveSelector = async function (page, selector, options = {}) {
    const pass = await page
        .waitForSelector(selector, options)
        .then(() => true)
        .catch(() => false);
    return {
        pass: pass,
        message: () => {
            const not = this.isNot ? " not" : "";
            const hint = this.utils.matcherHint("toHaveSelector", undefined, undefined, { isNot: this.isNot, promise: this.promise });
            return (hint +
                "\n\n" +
                `Expected: page to${not} have selector ${this.utils.printExpected(selector)}`);
        },
    };
};
exports.default = toHaveSelector;
