/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the CollectionVersionSearchList type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CollectionVersionSearchList{}

// CollectionVersionSearchList Cross-repo search results.
type CollectionVersionSearchList struct {
	Repository Repository `json:"repository"`
	// Collection Version serializer without docs blob.
	CollectionVersion map[string]interface{} `json:"collection_version"`
	NamespaceMetadata NullableAnsibleAnsibleNamespaceMetadata `json:"namespace_metadata"`
	IsHighest bool `json:"is_highest"`
	IsDeprecated bool `json:"is_deprecated"`
	IsSigned bool `json:"is_signed"`
	AdditionalProperties map[string]interface{}
}

type _CollectionVersionSearchList CollectionVersionSearchList

// NewCollectionVersionSearchList instantiates a new CollectionVersionSearchList object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCollectionVersionSearchList(repository Repository, collectionVersion map[string]interface{}, namespaceMetadata NullableAnsibleAnsibleNamespaceMetadata, isHighest bool, isDeprecated bool, isSigned bool) *CollectionVersionSearchList {
	this := CollectionVersionSearchList{}
	this.Repository = repository
	this.CollectionVersion = collectionVersion
	this.NamespaceMetadata = namespaceMetadata
	this.IsHighest = isHighest
	this.IsDeprecated = isDeprecated
	this.IsSigned = isSigned
	return &this
}

// NewCollectionVersionSearchListWithDefaults instantiates a new CollectionVersionSearchList object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCollectionVersionSearchListWithDefaults() *CollectionVersionSearchList {
	this := CollectionVersionSearchList{}
	return &this
}

// GetRepository returns the Repository field value
func (o *CollectionVersionSearchList) GetRepository() Repository {
	if o == nil {
		var ret Repository
		return ret
	}

	return o.Repository
}

// GetRepositoryOk returns a tuple with the Repository field value
// and a boolean to check if the value has been set.
func (o *CollectionVersionSearchList) GetRepositoryOk() (*Repository, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Repository, true
}

// SetRepository sets field value
func (o *CollectionVersionSearchList) SetRepository(v Repository) {
	o.Repository = v
}

// GetCollectionVersion returns the CollectionVersion field value
func (o *CollectionVersionSearchList) GetCollectionVersion() map[string]interface{} {
	if o == nil {
		var ret map[string]interface{}
		return ret
	}

	return o.CollectionVersion
}

// GetCollectionVersionOk returns a tuple with the CollectionVersion field value
// and a boolean to check if the value has been set.
func (o *CollectionVersionSearchList) GetCollectionVersionOk() (map[string]interface{}, bool) {
	if o == nil {
		return map[string]interface{}{}, false
	}
	return o.CollectionVersion, true
}

// SetCollectionVersion sets field value
func (o *CollectionVersionSearchList) SetCollectionVersion(v map[string]interface{}) {
	o.CollectionVersion = v
}

// GetNamespaceMetadata returns the NamespaceMetadata field value
// If the value is explicit nil, the zero value for AnsibleAnsibleNamespaceMetadata will be returned
func (o *CollectionVersionSearchList) GetNamespaceMetadata() AnsibleAnsibleNamespaceMetadata {
	if o == nil || o.NamespaceMetadata.Get() == nil {
		var ret AnsibleAnsibleNamespaceMetadata
		return ret
	}

	return *o.NamespaceMetadata.Get()
}

// GetNamespaceMetadataOk returns a tuple with the NamespaceMetadata field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CollectionVersionSearchList) GetNamespaceMetadataOk() (*AnsibleAnsibleNamespaceMetadata, bool) {
	if o == nil {
		return nil, false
	}
	return o.NamespaceMetadata.Get(), o.NamespaceMetadata.IsSet()
}

// SetNamespaceMetadata sets field value
func (o *CollectionVersionSearchList) SetNamespaceMetadata(v AnsibleAnsibleNamespaceMetadata) {
	o.NamespaceMetadata.Set(&v)
}

// GetIsHighest returns the IsHighest field value
func (o *CollectionVersionSearchList) GetIsHighest() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.IsHighest
}

// GetIsHighestOk returns a tuple with the IsHighest field value
// and a boolean to check if the value has been set.
func (o *CollectionVersionSearchList) GetIsHighestOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.IsHighest, true
}

// SetIsHighest sets field value
func (o *CollectionVersionSearchList) SetIsHighest(v bool) {
	o.IsHighest = v
}

// GetIsDeprecated returns the IsDeprecated field value
func (o *CollectionVersionSearchList) GetIsDeprecated() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.IsDeprecated
}

// GetIsDeprecatedOk returns a tuple with the IsDeprecated field value
// and a boolean to check if the value has been set.
func (o *CollectionVersionSearchList) GetIsDeprecatedOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.IsDeprecated, true
}

// SetIsDeprecated sets field value
func (o *CollectionVersionSearchList) SetIsDeprecated(v bool) {
	o.IsDeprecated = v
}

// GetIsSigned returns the IsSigned field value
func (o *CollectionVersionSearchList) GetIsSigned() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.IsSigned
}

// GetIsSignedOk returns a tuple with the IsSigned field value
// and a boolean to check if the value has been set.
func (o *CollectionVersionSearchList) GetIsSignedOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.IsSigned, true
}

// SetIsSigned sets field value
func (o *CollectionVersionSearchList) SetIsSigned(v bool) {
	o.IsSigned = v
}

func (o CollectionVersionSearchList) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CollectionVersionSearchList) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["repository"] = o.Repository
	toSerialize["collection_version"] = o.CollectionVersion
	toSerialize["namespace_metadata"] = o.NamespaceMetadata.Get()
	toSerialize["is_highest"] = o.IsHighest
	toSerialize["is_deprecated"] = o.IsDeprecated
	toSerialize["is_signed"] = o.IsSigned

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CollectionVersionSearchList) UnmarshalJSON(bytes []byte) (err error) {
	varCollectionVersionSearchList := _CollectionVersionSearchList{}

	if err = json.Unmarshal(bytes, &varCollectionVersionSearchList); err == nil {
		*o = CollectionVersionSearchList(varCollectionVersionSearchList)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "repository")
		delete(additionalProperties, "collection_version")
		delete(additionalProperties, "namespace_metadata")
		delete(additionalProperties, "is_highest")
		delete(additionalProperties, "is_deprecated")
		delete(additionalProperties, "is_signed")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCollectionVersionSearchList struct {
	value *CollectionVersionSearchList
	isSet bool
}

func (v NullableCollectionVersionSearchList) Get() *CollectionVersionSearchList {
	return v.value
}

func (v *NullableCollectionVersionSearchList) Set(val *CollectionVersionSearchList) {
	v.value = val
	v.isSet = true
}

func (v NullableCollectionVersionSearchList) IsSet() bool {
	return v.isSet
}

func (v *NullableCollectionVersionSearchList) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCollectionVersionSearchList(val *CollectionVersionSearchList) *NullableCollectionVersionSearchList {
	return &NullableCollectionVersionSearchList{value: val, isSet: true}
}

func (v NullableCollectionVersionSearchList) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCollectionVersionSearchList) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


