/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"os"
)

// checks if the PackageUpload type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PackageUpload{}

// PackageUpload A Serializer for Python packages being uploaded to the index.
type PackageUpload struct {
	// A Python package release file to upload to the index.
	Content *os.File `json:"content"`
	// Defaults to `file_upload`, don't change it or request will fail!
	Action *string `json:"action,omitempty"`
	// SHA256 of package to validate upload integrity.
	Sha256Digest string `json:"sha256_digest"`
	AdditionalProperties map[string]interface{}
}

type _PackageUpload PackageUpload

// NewPackageUpload instantiates a new PackageUpload object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPackageUpload(content *os.File, sha256Digest string) *PackageUpload {
	this := PackageUpload{}
	this.Content = content
	var action string = "file_upload"
	this.Action = &action
	this.Sha256Digest = sha256Digest
	return &this
}

// NewPackageUploadWithDefaults instantiates a new PackageUpload object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPackageUploadWithDefaults() *PackageUpload {
	this := PackageUpload{}
	var action string = "file_upload"
	this.Action = &action
	return &this
}

// GetContent returns the Content field value
func (o *PackageUpload) GetContent() *os.File {
	if o == nil {
		var ret *os.File
		return ret
	}

	return o.Content
}

// GetContentOk returns a tuple with the Content field value
// and a boolean to check if the value has been set.
func (o *PackageUpload) GetContentOk() (**os.File, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Content, true
}

// SetContent sets field value
func (o *PackageUpload) SetContent(v *os.File) {
	o.Content = v
}

// GetAction returns the Action field value if set, zero value otherwise.
func (o *PackageUpload) GetAction() string {
	if o == nil || IsNil(o.Action) {
		var ret string
		return ret
	}
	return *o.Action
}

// GetActionOk returns a tuple with the Action field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PackageUpload) GetActionOk() (*string, bool) {
	if o == nil || IsNil(o.Action) {
		return nil, false
	}
	return o.Action, true
}

// HasAction returns a boolean if a field has been set.
func (o *PackageUpload) HasAction() bool {
	if o != nil && !IsNil(o.Action) {
		return true
	}

	return false
}

// SetAction gets a reference to the given string and assigns it to the Action field.
func (o *PackageUpload) SetAction(v string) {
	o.Action = &v
}

// GetSha256Digest returns the Sha256Digest field value
func (o *PackageUpload) GetSha256Digest() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Sha256Digest
}

// GetSha256DigestOk returns a tuple with the Sha256Digest field value
// and a boolean to check if the value has been set.
func (o *PackageUpload) GetSha256DigestOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Sha256Digest, true
}

// SetSha256Digest sets field value
func (o *PackageUpload) SetSha256Digest(v string) {
	o.Sha256Digest = v
}

func (o PackageUpload) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PackageUpload) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["content"] = o.Content
	if !IsNil(o.Action) {
		toSerialize["action"] = o.Action
	}
	toSerialize["sha256_digest"] = o.Sha256Digest

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PackageUpload) UnmarshalJSON(bytes []byte) (err error) {
	varPackageUpload := _PackageUpload{}

	if err = json.Unmarshal(bytes, &varPackageUpload); err == nil {
		*o = PackageUpload(varPackageUpload)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "content")
		delete(additionalProperties, "action")
		delete(additionalProperties, "sha256_digest")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePackageUpload struct {
	value *PackageUpload
	isSet bool
}

func (v NullablePackageUpload) Get() *PackageUpload {
	return v.value
}

func (v *NullablePackageUpload) Set(val *PackageUpload) {
	v.value = val
	v.isSet = true
}

func (v NullablePackageUpload) IsSet() bool {
	return v.isSet
}

func (v *NullablePackageUpload) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePackageUpload(val *PackageUpload) *NullablePackageUpload {
	return &NullablePackageUpload{value: val, isSet: true}
}

func (v NullablePackageUpload) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePackageUpload) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


