/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the CollectionVersionCopyMove type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CollectionVersionCopyMove{}

// CollectionVersionCopyMove Copy or move collections from a source repository into one or more destinations.  This will carry associated content like Signatures and Marks along.
type CollectionVersionCopyMove struct {
	// A list of collection versions to move or copy.
	CollectionVersions []string `json:"collection_versions"`
	// List of repository HREFs to put content in.
	DestinationRepositories []string `json:"destination_repositories"`
	// HREF for a signing service. This will be used to sign the collection before moving putting it in any new repositories.
	SigningService *string `json:"signing_service,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _CollectionVersionCopyMove CollectionVersionCopyMove

// NewCollectionVersionCopyMove instantiates a new CollectionVersionCopyMove object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCollectionVersionCopyMove(collectionVersions []string, destinationRepositories []string) *CollectionVersionCopyMove {
	this := CollectionVersionCopyMove{}
	this.CollectionVersions = collectionVersions
	this.DestinationRepositories = destinationRepositories
	return &this
}

// NewCollectionVersionCopyMoveWithDefaults instantiates a new CollectionVersionCopyMove object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCollectionVersionCopyMoveWithDefaults() *CollectionVersionCopyMove {
	this := CollectionVersionCopyMove{}
	return &this
}

// GetCollectionVersions returns the CollectionVersions field value
func (o *CollectionVersionCopyMove) GetCollectionVersions() []string {
	if o == nil {
		var ret []string
		return ret
	}

	return o.CollectionVersions
}

// GetCollectionVersionsOk returns a tuple with the CollectionVersions field value
// and a boolean to check if the value has been set.
func (o *CollectionVersionCopyMove) GetCollectionVersionsOk() ([]string, bool) {
	if o == nil {
		return nil, false
	}
	return o.CollectionVersions, true
}

// SetCollectionVersions sets field value
func (o *CollectionVersionCopyMove) SetCollectionVersions(v []string) {
	o.CollectionVersions = v
}

// GetDestinationRepositories returns the DestinationRepositories field value
func (o *CollectionVersionCopyMove) GetDestinationRepositories() []string {
	if o == nil {
		var ret []string
		return ret
	}

	return o.DestinationRepositories
}

// GetDestinationRepositoriesOk returns a tuple with the DestinationRepositories field value
// and a boolean to check if the value has been set.
func (o *CollectionVersionCopyMove) GetDestinationRepositoriesOk() ([]string, bool) {
	if o == nil {
		return nil, false
	}
	return o.DestinationRepositories, true
}

// SetDestinationRepositories sets field value
func (o *CollectionVersionCopyMove) SetDestinationRepositories(v []string) {
	o.DestinationRepositories = v
}

// GetSigningService returns the SigningService field value if set, zero value otherwise.
func (o *CollectionVersionCopyMove) GetSigningService() string {
	if o == nil || IsNil(o.SigningService) {
		var ret string
		return ret
	}
	return *o.SigningService
}

// GetSigningServiceOk returns a tuple with the SigningService field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionVersionCopyMove) GetSigningServiceOk() (*string, bool) {
	if o == nil || IsNil(o.SigningService) {
		return nil, false
	}
	return o.SigningService, true
}

// HasSigningService returns a boolean if a field has been set.
func (o *CollectionVersionCopyMove) HasSigningService() bool {
	if o != nil && !IsNil(o.SigningService) {
		return true
	}

	return false
}

// SetSigningService gets a reference to the given string and assigns it to the SigningService field.
func (o *CollectionVersionCopyMove) SetSigningService(v string) {
	o.SigningService = &v
}

func (o CollectionVersionCopyMove) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CollectionVersionCopyMove) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["collection_versions"] = o.CollectionVersions
	toSerialize["destination_repositories"] = o.DestinationRepositories
	if !IsNil(o.SigningService) {
		toSerialize["signing_service"] = o.SigningService
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CollectionVersionCopyMove) UnmarshalJSON(bytes []byte) (err error) {
	varCollectionVersionCopyMove := _CollectionVersionCopyMove{}

	if err = json.Unmarshal(bytes, &varCollectionVersionCopyMove); err == nil {
		*o = CollectionVersionCopyMove(varCollectionVersionCopyMove)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "collection_versions")
		delete(additionalProperties, "destination_repositories")
		delete(additionalProperties, "signing_service")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCollectionVersionCopyMove struct {
	value *CollectionVersionCopyMove
	isSet bool
}

func (v NullableCollectionVersionCopyMove) Get() *CollectionVersionCopyMove {
	return v.value
}

func (v *NullableCollectionVersionCopyMove) Set(val *CollectionVersionCopyMove) {
	v.value = val
	v.isSet = true
}

func (v NullableCollectionVersionCopyMove) IsSet() bool {
	return v.isSet
}

func (v *NullableCollectionVersionCopyMove) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCollectionVersionCopyMove(val *CollectionVersionCopyMove) *NullableCollectionVersionCopyMove {
	return &NullableCollectionVersionCopyMove{value: val, isSet: true}
}

func (v NullableCollectionVersionCopyMove) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCollectionVersionCopyMove) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


