/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl.javax;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.mozilla.jss.provider.javax.crypto.JSSKeyManager;
import org.mozilla.jss.ssl.SSLCipher;
import org.mozilla.jss.ssl.javax.JSSEngine;
import org.mozilla.jss.ssl.javax.JSSEngineReferenceImpl;
import org.mozilla.jss.ssl.javax.JSSServerSocket;

public class JSSServerSocketFactory
extends SSLServerSocketFactory {
    private SSLContext ctx;
    private JSSKeyManager key_manager;
    private X509TrustManager[] trust_managers;

    public JSSServerSocketFactory(String protocol, JSSKeyManager km, X509TrustManager[] tms) {
        try {
            this.ctx = SSLContext.getInstance(protocol, "Mozilla-JSS");
            this.ctx.init(new JSSKeyManager[]{km}, tms, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error recreating SSLContext instance: " + e.getMessage(), e);
        }
        this.key_manager = km;
        this.trust_managers = tms;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        SSLCipher[] ciphers = JSSEngine.queryEnabledCipherSuites();
        String[] result = new String[ciphers.length];
        for (int i = 0; i < ciphers.length; ++i) {
            result[i] = ciphers[i].toString();
        }
        return result;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        JSSEngineReferenceImpl engine = new JSSEngineReferenceImpl();
        return engine.getSupportedCipherSuites();
    }

    @Override
    public JSSServerSocket createServerSocket() throws IOException {
        JSSServerSocket ret = new JSSServerSocket();
        ret.consumeSocket(new ServerSocket());
        ret.setSSLContext(this.ctx);
        ret.initEngine();
        ret.setKeyManager(this.key_manager);
        ret.setTrustManagers(this.trust_managers);
        return ret;
    }

    @Override
    public JSSServerSocket createServerSocket(int port) throws IOException {
        JSSServerSocket ret = new JSSServerSocket();
        ret.consumeSocket(new ServerSocket(port));
        ret.setSSLContext(this.ctx);
        ret.initEngine();
        ret.setKeyManager(this.key_manager);
        ret.setTrustManagers(this.trust_managers);
        return ret;
    }

    @Override
    public JSSServerSocket createServerSocket(int port, int backlog) throws IOException {
        JSSServerSocket ret = new JSSServerSocket();
        ret.consumeSocket(new ServerSocket(port, backlog));
        ret.setSSLContext(this.ctx);
        ret.initEngine();
        ret.setKeyManager(this.key_manager);
        ret.setTrustManagers(this.trust_managers);
        return ret;
    }

    @Override
    public JSSServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        JSSServerSocket ret = new JSSServerSocket();
        ret.consumeSocket(new ServerSocket(port, backlog, ifAddress));
        ret.setSSLContext(this.ctx);
        ret.initEngine();
        ret.setKeyManager(this.key_manager);
        ret.setTrustManagers(this.trust_managers);
        return ret;
    }
}

