/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;

public class CertificateAlgorithmId
implements CertAttrSet,
Serializable {
    private static final long serialVersionUID = 6084780721443376563L;
    private AlgorithmId algId;
    public static final String IDENT = "x509.info.algorithmID";
    public static final String NAME = "algorithmID";
    public static final String ALGORITHM = "algorithm";

    public CertificateAlgorithmId(AlgorithmId algId) {
        this.algId = algId;
    }

    public CertificateAlgorithmId(DerInputStream in) throws IOException {
        DerValue val = in.getDerValue();
        this.algId = AlgorithmId.parse(val);
    }

    public CertificateAlgorithmId(InputStream in) throws IOException {
        DerValue val = new DerValue(in);
        this.algId = AlgorithmId.parse(val);
    }

    @Override
    public String toString() {
        if (this.algId == null) {
            return "";
        }
        return this.algId.toString() + ", OID = " + this.algId.getOID().toString() + "\n";
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.encode(stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        this.decode(stream);
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.algId.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void decode(InputStream in) throws IOException {
        DerValue derVal = new DerValue(in);
        this.algId = AlgorithmId.parse(derVal);
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof AlgorithmId)) {
            throw new IOException("Attribute must be of type AlgorithmId.");
        }
        if (!name.equalsIgnoreCase(ALGORITHM)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
        }
        this.algId = (AlgorithmId)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(ALGORITHM)) {
            return this.algId;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(ALGORITHM)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateAlgorithmId.");
        }
        this.algId = null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(ALGORITHM);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

