/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;

public class StringTestUtil {
    public static final String NULL_CHARS = "\u0000";
    public static final String PRINTABLE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 '()+,-./:=?";
    public static final String NON_PRINTABLE_CHARS = "\"\\";
    public static final String CONTROL_CHARS = "\b\t\n\f\r";
    public static final String MULTIBYTE_CHARS = "\u6211\u7231\u4f60";

    public static String toString(byte[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(Integer.toHexString(0xFF & array[i] | 0x100).substring(1).toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] normalizeUnicode(byte[] data) throws Exception {
        try (DerOutputStream os = new DerOutputStream();){
            DerValue value = new DerValue(data);
            byte[] tmp = value.data.toByteArray();
            if (tmp[0] == -2 && tmp[1] == -1) {
                byte tag = value.tag;
                int length = value.length() - 2;
                os.putTag((byte)0, false, tag);
                os.putLength(length);
                os.write(tmp, 2, length);
                byte[] byArray = os.toByteArray();
                return byArray;
            }
            byte[] byArray = data;
            return byArray;
        }
    }

    public static byte[] encode(byte tag, String string) throws Exception {
        try (DerOutputStream os = new DerOutputStream();){
            os.putStringType(tag, string);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public static String decode(byte tag, byte[] bytes) throws Exception {
        DerInputStream is = new DerInputStream(bytes);
        switch (tag) {
            case 30: {
                return is.getBMPString();
            }
            case 22: {
                return is.getIA5String();
            }
            case 19: {
                return is.getPrintableString();
            }
            case 20: {
                return is.getT61String();
            }
            case 28: {
                return is.getUniversalString();
            }
            case 12: {
                return is.getDerValue().getUTF8String();
            }
        }
        throw new Exception("Unsupported tag: " + tag);
    }
}

