/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.File;
import java.io.FileWriter;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.InitializationValues;
import org.mozilla.jss.JSSProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilitiesList {
    public static void main(String[] args) throws Exception {
        Capabilities lister = new Capabilities();
        if (!lister.createOutputDirs()) {
            return;
        }
        lister.addJssProvider();
        Provider[] ps = Security.getProviders();
        lister.listBrief(ps);
        lister.listVerbose(ps);
    }

    static class Capabilities {
        public static Logger logger = LoggerFactory.getLogger(CapabilitiesList.class);
        public static String briefFileBase = "listings/brief/Capabilities4";
        public static String verboseFileBase = "listings/verbose/Capabilities4";

        public void listCapabilities(FileWriter fw, Provider p) throws Exception {
            String factoryClass;
            Set<Object> keySet = p.keySet();
            assert (keySet != null);
            Iterator<Object> it = keySet.iterator();
            assert (it != null);
            HashMap mapping = new HashMap();
            while (it.hasNext()) {
                String entry = (String)it.next();
                if (entry.startsWith("Alg.Alias.")) {
                    Object implementation = (String)p.get(entry);
                    assert (!((String)implementation).startsWith("Alg.Alias."));
                    String withoutPrefix = entry.replaceFirst("Alg.Alias.", "");
                    factoryClass = withoutPrefix.substring(0, withoutPrefix.indexOf(46));
                    implementation = factoryClass + "." + (String)implementation;
                    if (mapping.get(implementation) == null) {
                        mapping.put(implementation, new HashSet());
                    }
                    ((HashSet)mapping.get(implementation)).add(withoutPrefix);
                    continue;
                }
                mapping.put(entry, new HashSet());
            }
            ArrayList entries = new ArrayList(mapping.keySet());
            Collections.sort(entries);
            for (String entry : entries) {
                factoryClass = entry.substring(0, entry.indexOf(46));
                String name = entry.substring(factoryClass.length() + 1);
                assert (name != null);
                fw.write(String.format("\t %s : %s", factoryClass, name));
                fw.write(System.lineSeparator());
                if (mapping.get(entry) == null) continue;
                ArrayList subentries = new ArrayList((Collection)mapping.get(entry));
                Collections.sort(subentries);
                for (String subentry : subentries) {
                    fw.write(String.format("\t\t Alias: %s", subentry));
                    fw.write(System.lineSeparator());
                }
            }
        }

        public boolean jssIsRegistered(Provider[] ps) throws Exception {
            Provider jssProvider = null;
            for (int i = 0; i < ps.length; ++i) {
                Provider p = ps[i];
                if (!p.getName().equals("Mozilla-JSS")) continue;
                jssProvider = p;
                break;
            }
            assert (jssProvider != null);
            assert (jssProvider.getName().equals("Mozilla-JSS"));
            assert (jssProvider instanceof JSSProvider);
            return jssProvider != null;
        }

        public void addJssProvider() throws Exception {
            try {
                UseSystemDB.addJSSProvider();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Alternative method failed: keep going");
            }
            if (!this.jssIsRegistered(Security.getProviders())) {
                throw new Exception("JSS is not registered");
            }
        }

        public boolean createOutputDirs() throws Exception {
            File dir4Listings = new File("listings");
            dir4Listings.mkdir();
            File dir4verboseListings = new File("listings/verbose");
            dir4verboseListings.mkdir();
            File dir4briefListings = new File("listings/brief");
            dir4briefListings.mkdir();
            return true;
        }

        public void listBrief(Provider[] ps) throws Exception {
            try {
                for (int i = 0; i < ps.length; ++i) {
                    String fileName = briefFileBase + ps[i].getName() + ".txt";
                    FileWriter fw = new FileWriter(new File(fileName));
                    Enumeration<Object> e = ps[i].keys();
                    while (e.hasMoreElements()) {
                        fw.write(String.format("\t %s", e.nextElement()));
                        fw.write(System.lineSeparator());
                    }
                    fw.close();
                    File resultsFile = new File(fileName);
                    assert (resultsFile.exists());
                }
            }
            catch (Exception e) {
                logger.info("Exception caught in listBrief: " + e.getMessage(), (Throwable)e);
                logger.info("Keep going");
            }
        }

        public void listVerbose(Provider[] ps) throws Exception {
            try {
                for (int i = 0; i < ps.length; ++i) {
                    String fileName = verboseFileBase + ps[i].getName() + ".txt";
                    FileWriter fw = new FileWriter(new File(fileName));
                    this.listCapabilities(fw, ps[i]);
                    fw.close();
                    File resultsFile = new File(fileName);
                    assert (resultsFile.exists());
                }
            }
            catch (Exception e) {
                logger.info("Exception caught in listVerbose: " + e.getMessage(), (Throwable)e);
                logger.info("Keep going");
            }
        }
    }

    public static class UseSystemDB {
        public static String NSS_DB_LOCATION = "/etc/pki/nssdb";

        private UseSystemDB() {
        }

        public static void addJSSProvider() throws Exception {
            Capabilities.logger.debug("Starting call to JSSProviderLoader.addProvider()...");
            InitializationValues ivs = new InitializationValues(NSS_DB_LOCATION);
            ivs.noCertDB = true;
            ivs.installJSSProvider = true;
            ivs.initializeJavaOnly = false;
            CryptoManager.initialize((InitializationValues)ivs);
            CryptoManager cm = CryptoManager.getInstance();
        }
    }
}

