/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs12;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.JSSSecureRandom;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkcs12.SafeBag;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkcs7.EncryptedContentInfo;
import org.mozilla.jss.pkcs7.EncryptedData;
import org.mozilla.jss.util.Password;

public class AuthenticatedSafes
implements ASN1Value {
    private SEQUENCE sequence;
    public static final int DEFAULT_ITERATIONS = 1;
    private static final int SALT_LENGTH = 20;
    @Deprecated(since="5.0.1", forRemoval=true)
    public static final PBEAlgorithm DEFAULT_KEY_GEN_ALG = PBEAlgorithm.PBE_SHA1_RC2_40_CBC;
    private static final boolean ACCEPT_SECURITY_DYNAMICS = false;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public AuthenticatedSafes() {
        this.sequence = new SEQUENCE();
    }

    public AuthenticatedSafes(SEQUENCE sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        for (int i = 0; i < sequence.size(); ++i) {
            if (sequence.elementAt(i) instanceof ContentInfo) continue;
            throw new IllegalArgumentException("element " + i + " of sequence is not a ContentInfo");
        }
        this.sequence = sequence;
    }

    public SEQUENCE getSequence() {
        return this.sequence;
    }

    public int getSize() {
        return this.sequence.size();
    }

    public boolean safeContentsIsEncrypted(int index) {
        ContentInfo ci = (ContentInfo)this.sequence.elementAt(index);
        return ci.getContentType().equals(ContentInfo.ENCRYPTED_DATA);
    }

    public SEQUENCE getSafeContentsAt(Password password, int index) throws IllegalStateException, NotInitializedException, NoSuchAlgorithmException, InvalidBERException, IOException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, IllegalBlockSizeException, BadPaddingException {
        ContentInfo ci = (ContentInfo)this.sequence.elementAt(index);
        if (ci.getContentType().equals(ContentInfo.ENCRYPTED_DATA)) {
            if (password == null) {
                throw new IllegalStateException("No password to decode encrypted SafeContents");
            }
            EncryptedContentInfo encCI = ((EncryptedData)ci.getInterpretedContent()).getEncryptedContentInfo();
            byte[] decrypted = encCI.decrypt(password, null);
            SEQUENCE.OF_Template seqt = new SEQUENCE.OF_Template(SafeBag.getTemplate());
            return (SEQUENCE)ASN1Util.decode(seqt, decrypted);
        }
        if (ci.getContentType().equals(ContentInfo.DATA)) {
            SEQUENCE.OF_Template seqt = new SEQUENCE.OF_Template(SafeBag.getTemplate());
            return (SEQUENCE)ASN1Util.decode(seqt, ((OCTET_STRING)ci.getInterpretedContent()).toByteArray());
        }
        throw new InvalidBERException("AuthenticatedSafes element is neither a Data or an EncryptedData");
    }

    static void print_byte_array(byte[] bytes) {
        int online = 0;
        int i = 0;
        while (i < bytes.length) {
            if (online > 25) {
                System.out.println("");
                online = 0;
            }
            System.out.print(Integer.toHexString(bytes[i] & 0xFF) + " ");
            ++i;
            ++online;
        }
        System.out.println("");
    }

    public void addSafeContents(SEQUENCE safeContents) {
        AuthenticatedSafes.checkSafeContents(safeContents);
        ContentInfo ci = new ContentInfo(ASN1Util.encode(safeContents));
        this.sequence.addElement(ci);
    }

    private static void checkSafeContents(SEQUENCE safeContents) {
        int size = safeContents.size();
        for (int i = 0; i < size; ++i) {
            if (safeContents.elementAt(i) instanceof SafeBag) continue;
            throw new IllegalArgumentException("Element " + i + " of SafeContents is not a SafeBag");
        }
    }

    public void addEncryptedSafeContents(PBEAlgorithm keyGenAlg, Password password, byte[] salt, int iterationCount, SEQUENCE safeContents) throws NotInitializedException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException {
        try {
            if (salt == null) {
                JSSSecureRandom rand = CryptoManager.getInstance().createPseudoRandomNumberGenerator();
                salt = new byte[20];
                rand.nextBytes(salt);
            }
            EncryptedContentInfo encCI = EncryptedContentInfo.createPBE(keyGenAlg, password, salt, iterationCount, new PasswordConverter(), ASN1Util.encode(safeContents));
            EncryptedData encData = new EncryptedData(encCI);
            ContentInfo ci = new ContentInfo(encData);
            this.sequence.addElement(ci);
        }
        catch (CharConversionException e) {
            throw new RuntimeException("Unable to convert password: " + e.getMessage(), e);
        }
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.OF_Template seqt = new SEQUENCE.OF_Template(ContentInfo.getTemplate());

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new AuthenticatedSafes(seq);
        }
    }
}

