/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.io.CharConversionException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.crypto.KBKDFParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.PK11SymKey;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.NativeProxy;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.UTF8Converter;

public final class PK11KeyGenerator
implements KeyGenerator {
    private PK11Token token;
    private KeyGenAlgorithm algorithm;
    private int strength = 0;
    private AlgorithmParameterSpec parameters;
    private long opFlags = 2304L;
    private boolean temporaryKeyMode = true;
    private int sensitiveKeyMode = -1;
    private KeyGenerator.CharToByteConverter charToByte;

    private PK11KeyGenerator() {
    }

    PK11KeyGenerator(PK11Token token, KeyGenAlgorithm algorithm) {
        if (token == null || algorithm == null) {
            throw new NullPointerException();
        }
        this.token = token;
        this.algorithm = algorithm;
        this.charToByte = new KeyGenerator.CharToByteConverter(){

            @Override
            public byte[] convert(char[] chars) throws CharConversionException {
                return UTF8Converter.UnicodeToUTF8(chars);
            }
        };
    }

    @Override
    public void setCharToByteConverter(KeyGenerator.CharToByteConverter charToByte) {
        if (charToByte == null) {
            throw new IllegalArgumentException("CharToByteConverter is null");
        }
        this.charToByte = charToByte;
    }

    @Override
    public void initialize(int strength) throws InvalidAlgorithmParameterException {
        Class<?>[] paramClasses = this.algorithm.getParameterClasses();
        if (paramClasses.length == 1 && paramClasses[0].equals(PBEKeyGenParams.class)) {
            throw new InvalidAlgorithmParameterException("PBE keygen algorithms require PBEKeyGenParams ");
        }
        if (!this.algorithm.isValidStrength(strength)) {
            throw new InvalidAlgorithmParameterException(strength + " is not a valid strength for " + this.algorithm);
        }
        if (strength % 8 != 0) {
            throw new InvalidAlgorithmParameterException("Key strength must be divisible by 8");
        }
        this.strength = strength;
    }

    @Override
    public void initialize(AlgorithmParameterSpec parameters) throws InvalidAlgorithmParameterException {
        if (!this.algorithm.isValidParameterObject(parameters)) {
            String name = "null";
            if (parameters != null) {
                name = parameters.getClass().getName();
            }
            throw new InvalidAlgorithmParameterException(this.algorithm + " cannot use a " + name + " parameter");
        }
        this.parameters = parameters;
    }

    @Override
    public void setKeyUsages(SymmetricKey.Usage[] usages) {
        this.opFlags = 0L;
        for (int i = 0; i < usages.length; ++i) {
            if (usages[i] == null) continue;
            this.opFlags |= usages[i].value();
        }
    }

    public void setKeyUsages(long opFlags) {
        this.opFlags = opFlags;
    }

    @Override
    public void temporaryKeys(boolean temp) {
        this.temporaryKeyMode = temp;
    }

    @Override
    public void sensitiveKeys(boolean sensitive) {
        this.sensitiveKeyMode = sensitive ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SymmetricKey generate() throws IllegalStateException, TokenException, CharConversionException {
        boolean is_kbkdf;
        Class<?>[] paramClasses = this.algorithm.getParameterClasses();
        boolean is_pbe = paramClasses.length == 1 && paramClasses[0].equals(PBEKeyGenParams.class);
        boolean bl = is_kbkdf = paramClasses.length == 1 && this.parameters instanceof KBKDFParameterSpec;
        if (is_pbe) {
            SymmetricKey symmetricKey;
            block11: {
                if (this.parameters == null || !(this.parameters instanceof PBEKeyGenParams)) {
                    throw new IllegalStateException("PBE keygen algorithms require PBEKeyGenParams");
                }
                PBEKeyGenParams kgp = (PBEKeyGenParams)this.parameters;
                byte[] pwbytes = null;
                try {
                    pwbytes = this.charToByte.convert(kgp.getPassword().getChars());
                    symmetricKey = PK11KeyGenerator.generatePBE(this.token, this.algorithm, kgp.getEncryptionAlgorithm(), kgp.getHashAlgorithm(), pwbytes, kgp.getSalt(), kgp.getIterations());
                    if (pwbytes == null) break block11;
                }
                catch (Throwable throwable) {
                    if (pwbytes != null) {
                        Password.wipeBytes(pwbytes);
                    }
                    throw throwable;
                }
                Password.wipeBytes(pwbytes);
            }
            return symmetricKey;
        }
        if (is_kbkdf) {
            KBKDFParameterSpec kps = (KBKDFParameterSpec)this.parameters;
            SymmetricKey result = null;
            try {
                try {
                    kps.open();
                    long pkcs11_alg = this.algorithm.getEnum().getValue();
                    result = PK11KeyGenerator.generateKBKDF(this.token, kps.prfKey, pkcs11_alg, kps.mPointer, kps.mPointerSize, kps.derivedKeyAlgorithm, kps.keySize, (int)this.opFlags, this.temporaryKeyMode, this.sensitiveKeyMode);
                }
                finally {
                    kps.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return result;
        }
        return PK11KeyGenerator.generateNormal(this.token, this.algorithm, this.strength, (int)this.opFlags, this.temporaryKeyMode, this.sensitiveKeyMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] generatePBE_IV() throws TokenException, CharConversionException {
        boolean is_pbe;
        Class<?>[] paramClasses = this.algorithm.getParameterClasses();
        boolean bl = is_pbe = paramClasses.length == 1 && paramClasses[0].equals(PBEKeyGenParams.class);
        if (is_pbe) {
            byte[] byArray;
            block5: {
                if (this.parameters == null || !(this.parameters instanceof PBEKeyGenParams)) {
                    throw new IllegalStateException("PBE keygen algorithms require PBEKeyGenParams");
                }
                PBEKeyGenParams kgp = (PBEKeyGenParams)this.parameters;
                byte[] pwbytes = null;
                try {
                    pwbytes = this.charToByte.convert(kgp.getPassword().getChars());
                    byArray = PK11KeyGenerator.generatePBE_IV(this.algorithm, pwbytes, kgp.getSalt(), kgp.getIterations());
                    if (pwbytes == null) break block5;
                }
                catch (Throwable throwable) {
                    if (pwbytes != null) {
                        Password.wipeBytes(pwbytes);
                    }
                    throw throwable;
                }
                Password.wipeBytes(pwbytes);
            }
            return byArray;
        }
        throw new IllegalStateException("IV generation can only be performed by PBE algorithms");
    }

    private static native byte[] generatePBE_IV(KeyGenAlgorithm var0, byte[] var1, byte[] var2, int var3) throws TokenException;

    @Override
    public SymmetricKey clone(SymmetricKey key) throws SymmetricKey.NotExtractableException, InvalidKeyException, TokenException {
        return PK11KeyGenerator.clone(key, this.token);
    }

    public static SymmetricKey clone(SymmetricKey key, PK11Token token) throws SymmetricKey.NotExtractableException, InvalidKeyException, TokenException {
        if (!(key instanceof PK11SymKey)) {
            throw new InvalidKeyException("Key is not a PKCS #11 key");
        }
        return PK11KeyGenerator.nativeClone(token, key);
    }

    private static native SymmetricKey nativeClone(PK11Token var0, SymmetricKey var1) throws SymmetricKey.NotExtractableException, TokenException;

    private static native SymmetricKey generateNormal(PK11Token var0, KeyGenAlgorithm var1, int var2, int var3, boolean var4, int var5) throws TokenException;

    private static native SymmetricKey generatePBE(PK11Token var0, KeyGenAlgorithm var1, EncryptionAlgorithm var2, HMACAlgorithm var3, byte[] var4, byte[] var5, int var6) throws TokenException;

    private static native SymmetricKey generateKBKDF(PK11Token var0, PK11SymKey var1, long var2, NativeProxy var4, long var5, long var7, int var9, int var10, boolean var11, int var12) throws TokenException;
}

