/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.Serializable;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.x509.GeneralName;

public class GeneralSubtree
implements Serializable {
    private static final long serialVersionUID = -2835481424013062770L;
    private static final byte TAG_MIN = 0;
    private static final byte TAG_MAX = 1;
    private static final int MIN_DEFAULT = 0;
    private GeneralName name;
    private int minimum = 0;
    private int maximum = -1;
    private transient PrettyPrintFormat pp = new PrettyPrintFormat(":");

    public GeneralSubtree(GeneralName name, int min, int max) {
        this.name = name;
        this.minimum = min;
        this.maximum = max;
    }

    public GeneralSubtree(DerValue val) throws IOException {
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for GeneralSubtree.");
        }
        this.name = new GeneralName(val.data.getDerValue());
        while (val.data.available() != 0) {
            DerValue opt = val.data.getDerValue();
            if (opt.isContextSpecific((byte)0) && !opt.isConstructed()) {
                opt.resetTag((byte)2);
                this.minimum = opt.getInteger().toInt();
                continue;
            }
            if (opt.isContextSpecific((byte)1) && !opt.isConstructed()) {
                opt.resetTag((byte)2);
                this.maximum = opt.getInteger().toInt();
                continue;
            }
            throw new IOException("Invalid encoding of GeneralSubtree.");
        }
    }

    public String toString() {
        String s = "\n   GeneralSubtree: [\n    GeneralName: " + (this.name == null ? "" : this.name.toString()) + "\n    Minimum: " + this.minimum;
        s = this.maximum == -1 ? s + "\t    Maximum: undefined" : s + "\t    Maximum: " + this.maximum;
        s = s + "    ]\n";
        return s;
    }

    public String toPrint(int indent) {
        String s = "\n" + this.pp.indent(indent) + "GeneralSubtree: [\n" + this.pp.indent(indent + 2) + "GeneralName: " + (this.name == null ? "" : this.name.toString()) + "\n" + this.pp.indent(indent + 2) + "Minimum: " + this.minimum;
        s = this.maximum == -1 ? s + "\n" + this.pp.indent(indent + 2) + "Maximum: undefined" : s + "\n" + this.pp.indent(indent + 2) + "Maximum: " + this.maximum;
        s = s + "]\n";
        return s;
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp;
        DerOutputStream seq = new DerOutputStream();
        this.name.encode(seq);
        if (this.minimum != 0) {
            tmp = new DerOutputStream();
            tmp.putInteger(new BigInt(this.minimum));
            seq.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), tmp);
        }
        if (this.maximum != -1) {
            tmp = new DerOutputStream();
            tmp.putInteger(new BigInt(this.maximum));
            seq.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), tmp);
        }
        out.write((byte)48, seq);
    }

    public GeneralName getGeneralName() {
        return this.name;
    }

    public int getMaxValue() {
        return this.maximum;
    }

    public int getMinValue() {
        return this.minimum;
    }
}

