/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.schema.SchemaElement;
import com.netscape.jndi.ldap.schema.SchemaManager;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPMatchingRuleSchema;

public class SchemaMatchingRule
extends SchemaElement {
    private static final String APPLIES = "APPLIES";
    LDAPMatchingRuleSchema m_ldapMatchingRule;
    private static String[] m_allAttrIds = new String[]{"NUMERICOID", "NAME", "DESC", "OBSOLETE", "SYNTAX", "APPLIES"};
    LDAPConnection m_ld;

    public SchemaMatchingRule(LDAPMatchingRuleSchema ldapMatchingRule, SchemaManager schemaManager) {
        super(schemaManager);
        this.m_ldapMatchingRule = ldapMatchingRule;
        this.m_path = "AttributeDefinition/" + this.m_ldapMatchingRule.getName();
    }

    public SchemaMatchingRule(Attributes attrs, SchemaManager schemaManager) throws NamingException {
        super(schemaManager);
        this.m_ldapMatchingRule = SchemaMatchingRule.parseDefAttributes(attrs);
        this.m_path = "AttributeDefinition/" + this.m_ldapMatchingRule.getName();
    }

    static LDAPMatchingRuleSchema parseDefAttributes(Attributes attrs) throws NamingException {
        String name = null;
        String oid = null;
        String desc = null;
        String syntax = null;
        boolean obsolete = false;
        Vector<Object> applies = new Vector<Object>();
        NamingEnumeration<? extends Attribute> attrEnum = attrs.getAll();
        while (attrEnum.hasMoreElements()) {
            Attribute attr = (Attribute)attrEnum.nextElement();
            String attrName = attr.getID();
            if (attrName.equals("NAME")) {
                name = SchemaMatchingRule.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals("NUMERICOID")) {
                oid = SchemaMatchingRule.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals("SYNTAX")) {
                syntax = SchemaMatchingRule.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals("DESC")) {
                desc = SchemaMatchingRule.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals(APPLIES)) {
                NamingEnumeration<?> valEnum = attr.getAll();
                while (valEnum.hasMoreElements()) {
                    applies.addElement(valEnum.nextElement());
                }
                continue;
            }
            if (attrName.equals("OBSOLETE")) {
                obsolete = SchemaMatchingRule.parseTrueFalseValue(attr);
                continue;
            }
            throw new NamingException("Invalid schema attribute type for matching rule definition " + attrName);
        }
        LDAPMatchingRuleSchema mrule = new LDAPMatchingRuleSchema(name, oid, desc, SchemaMatchingRule.vectorToStringAry(applies), syntax);
        if (obsolete) {
            mrule.setQualifier("OBSOLETE", "");
        }
        return mrule;
    }

    Attributes extractAttributeIds(String[] attrIds) throws NamingException {
        BasicAttributes attrs = new BasicAttributes();
        String val = null;
        for (int i = 0; i < attrIds.length; ++i) {
            if (attrIds[i].equals("NUMERICOID")) {
                val = this.m_ldapMatchingRule.getID();
                if (val == null) continue;
                attrs.put(new BasicAttribute("NUMERICOID", val));
                continue;
            }
            if (attrIds[i].equals("NAME")) {
                val = this.m_ldapMatchingRule.getName();
                if (val == null) continue;
                attrs.put(new BasicAttribute("NAME", val));
                continue;
            }
            if (attrIds[i].equals("DESC")) {
                val = this.m_ldapMatchingRule.getDescription();
                if (val == null) continue;
                attrs.put(new BasicAttribute("DESC", val));
                continue;
            }
            if (attrIds[i].equals("SYNTAX")) {
                val = this.m_ldapMatchingRule.getSyntaxString();
                if (val == null) continue;
                attrs.put(new BasicAttribute("SYNTAX", val));
                continue;
            }
            if (attrIds[i].equals(APPLIES)) {
                String[] appliesToAttrs = this.m_ldapMatchingRule.getAttributes();
                if (appliesToAttrs == null || appliesToAttrs.length <= 0) continue;
                BasicAttribute applies = new BasicAttribute(APPLIES);
                for (int a = 0; a < appliesToAttrs.length; ++a) {
                    applies.add(appliesToAttrs[a]);
                }
                attrs.put(applies);
                continue;
            }
            if (attrIds[i].equals("OBSOLETE")) {
                if (this.m_ldapMatchingRule.getQualifier("OBSOLETE") == null) continue;
                attrs.put(new BasicAttribute("OBSOLETE", "true"));
                continue;
            }
            throw new NamingException("Invalid schema attribute type for matching rule definition " + attrIds[i]);
        }
        return attrs;
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        if (name.length() != 0) {
            throw new NameNotFoundException(name);
        }
        return this.extractAttributeIds(m_allAttrIds);
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        if (name.length() != 0) {
            throw new NameNotFoundException(name);
        }
        return this.extractAttributeIds(attrIds);
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.getAttributes(name.toString(), attrIds);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        if (name.length() != 0) {
            throw new NameNotFoundException(name);
        }
        Attributes modAttrs = this.extractAttributeIds(m_allAttrIds);
        this.modifySchemaElementAttrs(modAttrs, mod_op, attrs);
        LDAPMatchingRuleSchema modLdapMatchingRule = SchemaMatchingRule.parseDefAttributes(modAttrs);
        this.m_schemaMgr.modifyMatchingRule(this.m_ldapMatchingRule, modLdapMatchingRule);
        this.m_ldapMatchingRule = modLdapMatchingRule;
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        if (name.length() != 0) {
            throw new NameNotFoundException(name);
        }
        Attributes modAttrs = this.extractAttributeIds(m_allAttrIds);
        this.modifySchemaElementAttrs(modAttrs, mods);
        LDAPMatchingRuleSchema modLdapMatchingRule = SchemaMatchingRule.parseDefAttributes(modAttrs);
        this.m_schemaMgr.modifyMatchingRule(this.m_ldapMatchingRule, modLdapMatchingRule);
        this.m_ldapMatchingRule = modLdapMatchingRule;
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(name.toString(), mod_op, attrs);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(name.toString(), mods);
    }
}

