/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.common.ExceptionMapper;
import java.util.Enumeration;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMatchingRuleSchema;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSchemaElement;

class SchemaManager {
    private LDAPSchema m_schema;
    private LDAPConnection m_ld;
    private boolean m_isLoaded;
    private boolean m_isObjectClassDirty;
    private boolean m_isAttributeDirty;
    private boolean m_isMatchingRuleDirty;

    private SchemaManager() {
    }

    public SchemaManager(LDAPConnection ld) {
        this.m_ld = ld;
        this.m_isLoaded = false;
        this.m_isMatchingRuleDirty = false;
        this.m_isAttributeDirty = false;
        this.m_isObjectClassDirty = false;
    }

    void load() throws NamingException {
        try {
            this.m_schema = new LDAPSchema();
            this.m_schema.fetchSchema(this.m_ld);
            this.m_isLoaded = true;
            this.m_isMatchingRuleDirty = false;
            this.m_isAttributeDirty = false;
            this.m_isObjectClassDirty = false;
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    LDAPObjectClassSchema getObjectClass(String name) throws NamingException {
        if (!this.m_isLoaded || this.m_isObjectClassDirty) {
            this.load();
        }
        return this.m_schema.getObjectClass(name);
    }

    LDAPAttributeSchema getAttribute(String name) throws NamingException {
        if (!this.m_isLoaded || this.m_isAttributeDirty) {
            this.load();
        }
        return this.m_schema.getAttribute(name);
    }

    LDAPMatchingRuleSchema getMatchingRule(String name) throws NamingException {
        if (!this.m_isLoaded || this.m_isMatchingRuleDirty) {
            this.load();
        }
        return this.m_schema.getMatchingRule(name);
    }

    Enumeration<String> getObjectClassNames() throws NamingException {
        if (!this.m_isLoaded || this.m_isObjectClassDirty) {
            this.load();
        }
        return this.m_schema.getObjectClassNames();
    }

    Enumeration<String> getAttributeNames() throws NamingException {
        if (!this.m_isLoaded || this.m_isAttributeDirty) {
            this.load();
        }
        return this.m_schema.getAttributeNames();
    }

    Enumeration<String> getMatchingRuleNames() throws NamingException {
        if (!this.m_isLoaded || this.m_isMatchingRuleDirty) {
            this.load();
        }
        return this.m_schema.getMatchingRuleNames();
    }

    Enumeration<LDAPObjectClassSchema> getObjectClasses() throws NamingException {
        if (!this.m_isLoaded || this.m_isObjectClassDirty) {
            this.load();
        }
        return this.m_schema.getObjectClasses();
    }

    Enumeration<LDAPAttributeSchema> getAttributes() throws NamingException {
        if (!this.m_isLoaded || this.m_isAttributeDirty) {
            this.load();
        }
        return this.m_schema.getAttributes();
    }

    Enumeration<LDAPMatchingRuleSchema> getMatchingRules() throws NamingException {
        if (!this.m_isLoaded || this.m_isMatchingRuleDirty) {
            this.load();
        }
        return this.m_schema.getMatchingRules();
    }

    void createObjectClass(LDAPObjectClassSchema objclass) throws NamingException {
        try {
            objclass.add(this.m_ld);
            this.m_isObjectClassDirty = true;
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    void createAttribute(LDAPAttributeSchema attr) throws NamingException {
        try {
            attr.add(this.m_ld);
            this.m_isAttributeDirty = true;
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    void createMatchingRule(LDAPMatchingRuleSchema mrule) throws NamingException {
        try {
            mrule.add(this.m_ld);
            this.m_isMatchingRuleDirty = true;
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    void removeObjectClass(String name) throws NamingException {
        LDAPObjectClassSchema objclass = this.getObjectClass(name);
        if (objclass == null) {
            throw new NameNotFoundException(name);
        }
        try {
            objclass.remove(this.m_ld);
            this.m_isObjectClassDirty = true;
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    void removeAttribute(String name) throws NamingException {
        LDAPAttributeSchema attr = this.getAttribute(name);
        if (attr == null) {
            throw new NameNotFoundException(name);
        }
        try {
            attr.remove(this.m_ld);
            this.m_isAttributeDirty = true;
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    void removeMatchingRule(String name) throws NamingException {
        LDAPMatchingRuleSchema mrule = this.getMatchingRule(name);
        if (mrule == null) {
            throw new NameNotFoundException(name);
        }
        try {
            mrule.remove(this.m_ld);
            this.m_isMatchingRuleDirty = true;
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    void modifyObjectClass(LDAPObjectClassSchema objclass, LDAPObjectClassSchema modObjClass) throws NamingException {
        try {
            objclass.modify(this.m_ld, (LDAPSchemaElement)modObjClass);
            this.m_isObjectClassDirty = true;
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    void modifyAttribute(LDAPAttributeSchema attr, LDAPAttributeSchema modAttr) throws NamingException {
        try {
            attr.modify(this.m_ld, (LDAPSchemaElement)modAttr);
            this.m_isAttributeDirty = true;
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    void modifyMatchingRule(LDAPMatchingRuleSchema mrule, LDAPMatchingRuleSchema modMRule) throws NamingException {
        try {
            mrule.modify(this.m_ld, (LDAPSchemaElement)modMRule);
            this.m_isMatchingRuleDirty = true;
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }
}

