/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.beans;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.beans.LDAPBasePropertySupport;

public class LDAPGetProperty
extends LDAPBasePropertySupport
implements Serializable {
    private String[] _dns = null;
    private String _attribute = new String("cn");
    private transient String[] _result;
    private Vector<byte[]> _resultV = null;
    private String _sResult = null;
    private String _errorMsg = null;

    public LDAPGetProperty() {
    }

    public LDAPGetProperty(String theHost, int thePort, String theBase) {
        this.setHost(theHost);
        this.setPort(thePort);
        this.setBase(theBase);
    }

    public String getAttribute() {
        return this._attribute;
    }

    public void setAttribute(String attr) {
        this._attribute = attr;
    }

    private void notifyResult(String[] newResult) {
        String sNewResult = this.convertToString(newResult);
        this.firePropertyChange("result", this._result, newResult);
        this._sResult = sNewResult;
        this._result = newResult;
    }

    private void notifyResult(Vector<byte[]> newResult) {
        this.firePropertyChange("result", this._resultV, newResult);
        this._resultV = (Vector)newResult.clone();
    }

    private void notifyResult(String error) {
        this.firePropertyChange("error", this._errorMsg, error);
        this._errorMsg = error;
    }

    public void setDNs(PropertyChangeEvent evt) {
        Object obj = evt.getNewValue();
        if (obj != null && obj instanceof String[]) {
            String[] strings = (String[])obj;
            if (strings.length == 0) {
                return;
            }
            this._dns = new String[strings.length];
            System.arraycopy(obj, 0, this._dns, 0, strings.length);
            System.out.println("length of dns -> " + this._dns.length);
        }
    }

    public String[] getProperty(String host, int port, String base, String filter, String attribute) {
        this.setHost(host);
        this.setPort(port);
        this.setBase(base);
        this.setFilter(filter);
        this.setAttribute(attribute);
        return this.getProperty();
    }

    public void getProperty(ActionEvent x) {
        this.getProperty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getProperty() {
        int numDataEntries;
        LDAPConnection m_ldc;
        Object[] res;
        block29: {
            if (this._attribute.length() < 1 || this.getFilter().length() < 1) {
                this.printDebug("Invalid attribute name or filter");
                this.setErrorCode(1);
                this.notifyResult((String[])null);
                return null;
            }
            res = null;
            try {
                m_ldc = new LDAPConnection();
                this.printDebug("Connecting to " + this.getHost() + " " + this.getPort());
                this.connect(m_ldc, this.getHost(), this.getPort());
            }
            catch (Exception e) {
                this.printDebug("Failed to connect to " + this.getHost() + ": " + e.toString());
                this.setErrorCode(2);
                this.notifyResult((String[])null);
                return null;
            }
            if (this._dns == null) {
                if (!this.getAuthDN().equals("") && !this.getAuthPassword().equals("")) {
                    this.printDebug("Authenticating " + this.getAuthDN() + " - " + this.getAuthPassword());
                    try {
                        m_ldc.authenticate(this.getAuthDN(), this.getAuthPassword());
                    }
                    catch (Exception e) {
                        this.printDebug("Failed to authenticate to " + this.getHost() + ": " + e.toString());
                        this.setErrorCode(3);
                        this.notifyResult((String[])null);
                        return null;
                    }
                }
            } else {
                for (int i = 0; i < this._dns.length; ++i) {
                    try {
                        m_ldc.authenticate(this._dns[i], this.getAuthPassword());
                        break;
                    }
                    catch (Exception e) {
                        if (i != this._dns.length - 1) continue;
                        this.printDebug("Failed to authenticate to " + this.getHost() + ": " + e.toString());
                        this.setErrorCode(3);
                        this.notifyResult((String[])null);
                        return null;
                    }
                }
            }
            numDataEntries = 0;
            try {
                String[] attrs = new String[]{this._attribute};
                LDAPSearchResults results = m_ldc.search(this.getBase(), this.getScope(), this.getFilter(), attrs, false);
                LDAPEntry currEntry = null;
                LDAPEntry entry = null;
                while (results.hasMoreElements()) {
                    try {
                        currEntry = results.next();
                        if (numDataEntries == 0) {
                            entry = currEntry;
                        }
                        if (++numDataEntries <= 1) continue;
                        this.printDebug("More than one entry found for " + this.getFilter());
                        this.setErrorCode(5);
                        break;
                    }
                    catch (LDAPException e) {
                        if (!this.getDebug()) continue;
                        this.notifyResult(e.toString());
                    }
                }
                if (numDataEntries != true) break block29;
                this.printDebug("... " + entry.getDN());
                if (this._attribute.equalsIgnoreCase("dn")) {
                    res = new String[]{entry.getDN()};
                    this.setErrorCode(0);
                    break block29;
                }
                LDAPAttributeSet attrset = entry.getAttributeSet();
                Enumeration attrsenum = attrset.getAttributes();
                if (attrsenum.hasMoreElements()) {
                    LDAPAttribute attr = (LDAPAttribute)attrsenum.nextElement();
                    this.printDebug(attr.getName() + " = ");
                    Enumeration valuesenum = attr.getStringValues();
                    if (valuesenum != null) {
                        Vector<String> v = new Vector<String>();
                        while (valuesenum.hasMoreElements()) {
                            String val = (String)valuesenum.nextElement();
                            v.addElement(val);
                            this.printDebug("\t\t" + val);
                        }
                        res = new String[v.size()];
                        v.copyInto(res);
                        this.setErrorCode(0);
                        break block29;
                    } else {
                        Enumeration byteEnum = attr.getByteValues();
                        Vector<byte[]> v = new Vector<byte[]>();
                        while (true) {
                            if (!byteEnum.hasMoreElements()) {
                                this.setErrorCode(0);
                                this.notifyResult(v);
                                return null;
                            }
                            byte[] val = (byte[])byteEnum.nextElement();
                            v.addElement(val);
                            this.printDebug("\t\t" + val);
                        }
                    }
                }
                this.printDebug("No properties found for " + this._attribute);
                this.setErrorCode(4);
            }
            catch (Exception e) {
                if (this.getDebug()) {
                    this.printDebug("Failed to search for " + this.getFilter() + ": " + e.toString());
                }
                this.setErrorCode(4);
            }
        }
        if (numDataEntries == 0) {
            this.printDebug("No entries found for " + this.getFilter());
            this.setErrorCode(4);
        }
        try {
            if (m_ldc != null && m_ldc.isConnected()) {
                m_ldc.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyResult((String[])res);
        return res;
    }

    public static void main(String[] args) {
        if (args.length != 5) {
            System.out.println("Usage: LDAPGetProperty host port base filter attribute");
            System.exit(1);
        }
        LDAPGetProperty app = new LDAPGetProperty();
        app.setHost(args[0]);
        app.setPort(Integer.parseInt(args[1]));
        app.setBase(args[2]);
        app.setFilter(args[3]);
        app.setAttribute(args[4]);
        String[] response = app.getProperty();
        if (response != null) {
            for (int i = 0; i < response.length; ++i) {
                System.out.println("\t" + response[i]);
            }
        }
        System.exit(0);
    }
}

