MIOPEN_EXPORT miopenStatus_t miopenGetVersion(size_t* major, size_t* minor,
                                              size_t* patch) {
  return DynamicCall<decltype(miopenGetVersion), &miopenGetVersion>(
      "miopenGetVersion", major, minor, patch);
}

MIOPEN_EXPORT miopenStatus_t miopenCreate(miopenHandle_t* handle) {
  return DynamicCall<decltype(miopenCreate), &miopenCreate>("miopenCreate",
                                                            handle);
}

MIOPEN_EXPORT miopenStatus_t miopenCreateWithStream(
    miopenHandle_t* handle, miopenAcceleratorQueue_t stream) {
  return DynamicCall<decltype(miopenCreateWithStream), &miopenCreateWithStream>(
      "miopenCreateWithStream", handle, stream);
}

MIOPEN_EXPORT miopenStatus_t miopenDestroy(miopenHandle_t handle) {
  return DynamicCall<decltype(miopenDestroy), &miopenDestroy>("miopenDestroy",
                                                              handle);
}

MIOPEN_EXPORT miopenStatus_t
miopenSetStream(miopenHandle_t handle, miopenAcceleratorQueue_t streamID) {
  return DynamicCall<decltype(miopenSetStream), &miopenSetStream>(
      "miopenSetStream", handle, streamID);
}

MIOPEN_EXPORT miopenStatus_t
miopenGetStream(miopenHandle_t handle, miopenAcceleratorQueue_t* streamID) {
  return DynamicCall<decltype(miopenGetStream), &miopenGetStream>(
      "miopenGetStream", handle, streamID);
}

MIOPEN_EXPORT miopenStatus_t miopenSetAllocator(
    miopenHandle_t handle, miopenAllocatorFunction allocator,
    miopenDeallocatorFunction deallocator, void* allocatorContext) {
  return DynamicCall<decltype(miopenSetAllocator), &miopenSetAllocator>(
      "miopenSetAllocator", handle, allocator, deallocator, allocatorContext);
}

MIOPEN_EXPORT miopenStatus_t miopenGetKernelTime(miopenHandle_t handle,
                                                 float* time) {
  return DynamicCall<decltype(miopenGetKernelTime), &miopenGetKernelTime>(
      "miopenGetKernelTime", handle, time);
}

MIOPEN_EXPORT miopenStatus_t miopenEnableProfiling(miopenHandle_t handle,
                                                   bool enable) {
  return DynamicCall<decltype(miopenEnableProfiling), &miopenEnableProfiling>(
      "miopenEnableProfiling", handle, enable);
}

MIOPEN_EXPORT miopenStatus_t
miopenCreateTensorDescriptor(miopenTensorDescriptor_t* tensorDesc) {
  return DynamicCall<decltype(miopenCreateTensorDescriptor),
                     &miopenCreateTensorDescriptor>(
      "miopenCreateTensorDescriptor", tensorDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenSet4dTensorDescriptor(
    miopenTensorDescriptor_t tensorDesc, miopenDataType_t dataType, int n,
    int c, int h, int w) {
  return DynamicCall<decltype(miopenSet4dTensorDescriptor),
                     &miopenSet4dTensorDescriptor>(
      "miopenSet4dTensorDescriptor", tensorDesc, dataType, n, c, h, w);
}

MIOPEN_EXPORT miopenStatus_t miopenGet4dTensorDescriptor(
    miopenTensorDescriptor_t tensorDesc, miopenDataType_t* dataType, int* n,
    int* c, int* h, int* w, int* nStride, int* cStride, int* hStride,
    int* wStride) {
  return DynamicCall<decltype(miopenGet4dTensorDescriptor),
                     &miopenGet4dTensorDescriptor>(
      "miopenGet4dTensorDescriptor", tensorDesc, dataType, n, c, h, w, nStride,
      cStride, hStride, wStride);
}

MIOPEN_EXPORT miopenStatus_t miopenSetTensorDescriptor(
    miopenTensorDescriptor_t tensorDesc, miopenDataType_t dataType, int nbDims,
    int* dimsA, int* stridesA) {
  return DynamicCall<decltype(miopenSetTensorDescriptor),
                     &miopenSetTensorDescriptor>("miopenSetTensorDescriptor",
                                                 tensorDesc, dataType, nbDims,
                                                 dimsA, stridesA);
}

MIOPEN_EXPORT miopenStatus_t
miopenGetTensorDescriptorSize(miopenTensorDescriptor_t tensorDesc, int* size) {
  return DynamicCall<decltype(miopenGetTensorDescriptorSize),
                     &miopenGetTensorDescriptorSize>(
      "miopenGetTensorDescriptorSize", tensorDesc, size);
}

MIOPEN_EXPORT miopenStatus_t miopenGetTensorDescriptor(
    miopenTensorDescriptor_t tensorDesc, miopenDataType_t* dataType, int* dimsA,
    int* stridesA) {
  return DynamicCall<decltype(miopenGetTensorDescriptor),
                     &miopenGetTensorDescriptor>(
      "miopenGetTensorDescriptor", tensorDesc, dataType, dimsA, stridesA);
}

MIOPEN_EXPORT miopenStatus_t
miopenDestroyTensorDescriptor(miopenTensorDescriptor_t tensorDesc) {
  return DynamicCall<decltype(miopenDestroyTensorDescriptor),
                     &miopenDestroyTensorDescriptor>(
      "miopenDestroyTensorDescriptor", tensorDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenOpTensor(
    miopenHandle_t handle, miopenTensorOp_t tensorOp, const void* alpha1,
    const miopenTensorDescriptor_t aDesc, const void* A, const void* alpha2,
    const miopenTensorDescriptor_t bDesc, const void* B, const void* beta,
    const miopenTensorDescriptor_t cDesc, void* C) {
  return DynamicCall<decltype(miopenOpTensor), &miopenOpTensor>(
      "miopenOpTensor", handle, tensorOp, alpha1, aDesc, A, alpha2, bDesc, B,
      beta, cDesc, C);
}

MIOPEN_EXPORT miopenStatus_t
miopenSetTensor(miopenHandle_t handle, const miopenTensorDescriptor_t yDesc,
                void* y, const void* alpha) {
  return DynamicCall<decltype(miopenSetTensor), &miopenSetTensor>(
      "miopenSetTensor", handle, yDesc, y, alpha);
}

MIOPEN_EXPORT miopenStatus_t
miopenScaleTensor(miopenHandle_t handle, const miopenTensorDescriptor_t yDesc,
                  void* y, const void* alpha) {
  return DynamicCall<decltype(miopenScaleTensor), &miopenScaleTensor>(
      "miopenScaleTensor", handle, yDesc, y, alpha);
}

MIOPEN_EXPORT miopenStatus_t
miopenGetTensorNumBytes(miopenTensorDescriptor_t tensorDesc, size_t* numBytes) {
  return DynamicCall<decltype(miopenGetTensorNumBytes),
                     &miopenGetTensorNumBytes>("miopenGetTensorNumBytes",
                                               tensorDesc, numBytes);
}

MIOPEN_EXPORT miopenStatus_t miopenTransformTensor(
    miopenHandle_t handle, const void* alpha,
    const miopenTensorDescriptor_t xDesc, const void* x, const void* beta,
    const miopenTensorDescriptor_t yDesc, void* y) {
  return DynamicCall<decltype(miopenTransformTensor), &miopenTransformTensor>(
      "miopenTransformTensor", handle, alpha, xDesc, x, beta, yDesc, y);
}

MIOPEN_EXPORT miopenStatus_t
miopenCreateConvolutionDescriptor(miopenConvolutionDescriptor_t* convDesc) {
  return DynamicCall<decltype(miopenCreateConvolutionDescriptor),
                     &miopenCreateConvolutionDescriptor>(
      "miopenCreateConvolutionDescriptor", convDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenInitConvolutionDescriptor(
    miopenConvolutionDescriptor_t convDesc, miopenConvolutionMode_t c_mode,
    int pad_h, int pad_w, int stride_h, int stride_w, int dilation_h,
    int dilation_w) {
  return DynamicCall<decltype(miopenInitConvolutionDescriptor),
                     &miopenInitConvolutionDescriptor>(
      "miopenInitConvolutionDescriptor", convDesc, c_mode, pad_h, pad_w,
      stride_h, stride_w, dilation_h, dilation_w);
}

MIOPEN_EXPORT miopenStatus_t miopenInitConvolutionNdDescriptor(
    miopenConvolutionDescriptor_t convDesc, int spatialDim, int* padA,
    int* strideA, int* dilationA, miopenConvolutionMode_t c_mode) {
  return DynamicCall<decltype(miopenInitConvolutionNdDescriptor),
                     &miopenInitConvolutionNdDescriptor>(
      "miopenInitConvolutionNdDescriptor", convDesc, spatialDim, padA, strideA,
      dilationA, c_mode);
}

MIOPEN_EXPORT miopenStatus_t miopenGetConvolutionDescriptor(
    miopenConvolutionDescriptor_t convDesc, miopenConvolutionMode_t* c_mode,
    int* pad_h, int* pad_w, int* stride_h, int* stride_w, int* dilation_h,
    int* dilation_w) {
  return DynamicCall<decltype(miopenGetConvolutionDescriptor),
                     &miopenGetConvolutionDescriptor>(
      "miopenGetConvolutionDescriptor", convDesc, c_mode, pad_h, pad_w,
      stride_h, stride_w, dilation_h, dilation_w);
}

MIOPEN_EXPORT miopenStatus_t miopenGetConvolutionNdDescriptor(
    miopenConvolutionDescriptor_t convDesc, int requestedSpatialDim,
    int* spatialDim, int* padA, int* strideA, int* dilationA,
    miopenConvolutionMode_t* c_mode) {
  return DynamicCall<decltype(miopenGetConvolutionNdDescriptor),
                     &miopenGetConvolutionNdDescriptor>(
      "miopenGetConvolutionNdDescriptor", convDesc, requestedSpatialDim,
      spatialDim, padA, strideA, dilationA, c_mode);
}

MIOPEN_EXPORT miopenStatus_t miopenSetConvolutionGroupCount(
    miopenConvolutionDescriptor_t convDesc, int groupCount) {
  return DynamicCall<decltype(miopenSetConvolutionGroupCount),
                     &miopenSetConvolutionGroupCount>(
      "miopenSetConvolutionGroupCount", convDesc, groupCount);
}

MIOPEN_EXPORT miopenStatus_t miopenSetTransposeConvOutputPadding(
    miopenConvolutionDescriptor_t convDesc, int adj_h, int adj_w) {
  return DynamicCall<decltype(miopenSetTransposeConvOutputPadding),
                     &miopenSetTransposeConvOutputPadding>(
      "miopenSetTransposeConvOutputPadding", convDesc, adj_h, adj_w);
}

MIOPEN_EXPORT miopenStatus_t miopenSetTransposeConvNdOutputPadding(
    miopenConvolutionDescriptor_t convDesc, int spatialDim, int* adjA) {
  return DynamicCall<decltype(miopenSetTransposeConvNdOutputPadding),
                     &miopenSetTransposeConvNdOutputPadding>(
      "miopenSetTransposeConvNdOutputPadding", convDesc, spatialDim, adjA);
}

MIOPEN_EXPORT miopenStatus_t miopenGetConvolutionForwardOutputDim(
    miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t inputTensorDesc,
    const miopenTensorDescriptor_t filterDesc, int* n, int* c, int* h, int* w) {
  return DynamicCall<decltype(miopenGetConvolutionForwardOutputDim),
                     &miopenGetConvolutionForwardOutputDim>(
      "miopenGetConvolutionForwardOutputDim", convDesc, inputTensorDesc,
      filterDesc, n, c, h, w);
}

MIOPEN_EXPORT miopenStatus_t miopenGetConvolutionNdForwardOutputDim(
    miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t inputTensorDesc,
    const miopenTensorDescriptor_t filterDesc, int* nDim,
    int* outputTensorDimA) {
  return DynamicCall<decltype(miopenGetConvolutionNdForwardOutputDim),
                     &miopenGetConvolutionNdForwardOutputDim>(
      "miopenGetConvolutionNdForwardOutputDim", convDesc, inputTensorDesc,
      filterDesc, nDim, outputTensorDimA);
}

MIOPEN_EXPORT miopenStatus_t
miopenDestroyConvolutionDescriptor(miopenConvolutionDescriptor_t convDesc) {
  return DynamicCall<decltype(miopenDestroyConvolutionDescriptor),
                     &miopenDestroyConvolutionDescriptor>(
      "miopenDestroyConvolutionDescriptor", convDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionForwardGetSolutionCount(
    miopenHandle_t handle, const miopenTensorDescriptor_t wDesc,
    const miopenTensorDescriptor_t xDesc,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t yDesc, size_t* solutionCount) {
  return DynamicCall<decltype(miopenConvolutionForwardGetSolutionCount),
                     &miopenConvolutionForwardGetSolutionCount>(
      "miopenConvolutionForwardGetSolutionCount", handle, wDesc, xDesc,
      convDesc, yDesc, solutionCount);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionForwardGetSolution(
    miopenHandle_t handle, const miopenTensorDescriptor_t wDesc,
    const miopenTensorDescriptor_t xDesc,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t yDesc, const size_t maxSolutionCount,
    size_t* solutionCount, miopenConvSolution_t* solutions) {
  return DynamicCall<decltype(miopenConvolutionForwardGetSolution),
                     &miopenConvolutionForwardGetSolution>(
      "miopenConvolutionForwardGetSolution", handle, wDesc, xDesc, convDesc,
      yDesc, maxSolutionCount, solutionCount, solutions);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionForwardGetSolutionWorkspaceSize(
    miopenHandle_t handle, const miopenTensorDescriptor_t wDesc,
    const miopenTensorDescriptor_t xDesc,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t yDesc, const uint64_t solution_id,
    size_t* workSpaceSize) {
  return DynamicCall<decltype(miopenConvolutionForwardGetSolutionWorkspaceSize),
                     &miopenConvolutionForwardGetSolutionWorkspaceSize>(
      "miopenConvolutionForwardGetSolutionWorkspaceSize", handle, wDesc, xDesc,
      convDesc, yDesc, solution_id, workSpaceSize);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionForwardCompileSolution(
    miopenHandle_t handle, const miopenTensorDescriptor_t wDesc,
    const miopenTensorDescriptor_t xDesc,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t yDesc, const uint64_t solution_id) {
  return DynamicCall<decltype(miopenConvolutionForwardCompileSolution),
                     &miopenConvolutionForwardCompileSolution>(
      "miopenConvolutionForwardCompileSolution", handle, wDesc, xDesc, convDesc,
      yDesc, solution_id);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionForwardImmediate(
    miopenHandle_t handle, const miopenTensorDescriptor_t wDesc, const void* w,
    const miopenTensorDescriptor_t xDesc, const void* x,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t yDesc, void* y, void* workSpace,
    size_t workSpaceSize, const uint64_t solution_id) {
  return DynamicCall<decltype(miopenConvolutionForwardImmediate),
                     &miopenConvolutionForwardImmediate>(
      "miopenConvolutionForwardImmediate", handle, wDesc, w, xDesc, x, convDesc,
      yDesc, y, workSpace, workSpaceSize, solution_id);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionBackwardDataGetSolutionCount(
    miopenHandle_t handle, const miopenTensorDescriptor_t dyDesc,
    const miopenTensorDescriptor_t wDesc,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t dxDesc, size_t* solutionCount) {
  return DynamicCall<decltype(miopenConvolutionBackwardDataGetSolutionCount),
                     &miopenConvolutionBackwardDataGetSolutionCount>(
      "miopenConvolutionBackwardDataGetSolutionCount", handle, dyDesc, wDesc,
      convDesc, dxDesc, solutionCount);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionBackwardDataGetSolution(
    miopenHandle_t handle, const miopenTensorDescriptor_t dyDesc,
    const miopenTensorDescriptor_t wDesc,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t dxDesc, const size_t maxSolutionCount,
    size_t* solutionCount, miopenConvSolution_t* solutions) {
  return DynamicCall<decltype(miopenConvolutionBackwardDataGetSolution),
                     &miopenConvolutionBackwardDataGetSolution>(
      "miopenConvolutionBackwardDataGetSolution", handle, dyDesc, wDesc,
      convDesc, dxDesc, maxSolutionCount, solutionCount, solutions);
}

MIOPEN_EXPORT miopenStatus_t
miopenConvolutionBackwardDataGetSolutionWorkspaceSize(
    miopenHandle_t handle, const miopenTensorDescriptor_t dyDesc,
    const miopenTensorDescriptor_t wDesc,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t dxDesc, const uint64_t solution_id,
    size_t* workSpaceSize) {
  return DynamicCall<decltype(
                         miopenConvolutionBackwardDataGetSolutionWorkspaceSize),
                     &miopenConvolutionBackwardDataGetSolutionWorkspaceSize>(
      "miopenConvolutionBackwardDataGetSolutionWorkspaceSize", handle, dyDesc,
      wDesc, convDesc, dxDesc, solution_id, workSpaceSize);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionBackwardDataCompileSolution(
    miopenHandle_t handle, const miopenTensorDescriptor_t dyDesc,
    const miopenTensorDescriptor_t wDesc,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t dxDesc, const uint64_t solution_id) {
  return DynamicCall<decltype(miopenConvolutionBackwardDataCompileSolution),
                     &miopenConvolutionBackwardDataCompileSolution>(
      "miopenConvolutionBackwardDataCompileSolution", handle, dyDesc, wDesc,
      convDesc, dxDesc, solution_id);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionBackwardDataImmediate(
    miopenHandle_t handle, const miopenTensorDescriptor_t dyDesc,
    const void* dy, const miopenTensorDescriptor_t wDesc, const void* w,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t dxDesc, void* dx, void* workSpace,
    size_t workSpaceSize, const uint64_t solution_id) {
  return DynamicCall<decltype(miopenConvolutionBackwardDataImmediate),
                     &miopenConvolutionBackwardDataImmediate>(
      "miopenConvolutionBackwardDataImmediate", handle, dyDesc, dy, wDesc, w,
      convDesc, dxDesc, dx, workSpace, workSpaceSize, solution_id);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionBackwardWeightsGetSolutionCount(
    miopenHandle_t handle, const miopenTensorDescriptor_t dyDesc,
    const miopenTensorDescriptor_t xDesc,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t dwDesc, size_t* solutionCount) {
  return DynamicCall<decltype(miopenConvolutionBackwardWeightsGetSolutionCount),
                     &miopenConvolutionBackwardWeightsGetSolutionCount>(
      "miopenConvolutionBackwardWeightsGetSolutionCount", handle, dyDesc, xDesc,
      convDesc, dwDesc, solutionCount);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionBackwardWeightsGetSolution(
    miopenHandle_t handle, const miopenTensorDescriptor_t dyDesc,
    const miopenTensorDescriptor_t xDesc,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t dwDesc, const size_t maxSolutionCount,
    size_t* solutionCount, miopenConvSolution_t* solutions) {
  return DynamicCall<decltype(miopenConvolutionBackwardWeightsGetSolution),
                     &miopenConvolutionBackwardWeightsGetSolution>(
      "miopenConvolutionBackwardWeightsGetSolution", handle, dyDesc, xDesc,
      convDesc, dwDesc, maxSolutionCount, solutionCount, solutions);
}

MIOPEN_EXPORT miopenStatus_t
miopenConvolutionBackwardWeightsGetSolutionWorkspaceSize(
    miopenHandle_t handle, const miopenTensorDescriptor_t dyDesc,
    const miopenTensorDescriptor_t xDesc,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t dwDesc, const uint64_t solution_id,
    size_t* workSpaceSize) {
  return DynamicCall<
      decltype(miopenConvolutionBackwardWeightsGetSolutionWorkspaceSize),
      &miopenConvolutionBackwardWeightsGetSolutionWorkspaceSize>(
      "miopenConvolutionBackwardWeightsGetSolutionWorkspaceSize", handle,
      dyDesc, xDesc, convDesc, dwDesc, solution_id, workSpaceSize);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionBackwardWeightsCompileSolution(
    miopenHandle_t handle, const miopenTensorDescriptor_t dyDesc,
    const miopenTensorDescriptor_t xDesc,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t dwDesc, const uint64_t solution_id) {
  return DynamicCall<decltype(miopenConvolutionBackwardWeightsCompileSolution),
                     &miopenConvolutionBackwardWeightsCompileSolution>(
      "miopenConvolutionBackwardWeightsCompileSolution", handle, dyDesc, xDesc,
      convDesc, dwDesc, solution_id);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionBackwardWeightsImmediate(
    miopenHandle_t handle, const miopenTensorDescriptor_t dyDesc,
    const void* dy, const miopenTensorDescriptor_t xDesc, const void* x,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t dwDesc, void* dw, void* workSpace,
    size_t workSpaceSize, const uint64_t solution_id) {
  return DynamicCall<decltype(miopenConvolutionBackwardWeightsImmediate),
                     &miopenConvolutionBackwardWeightsImmediate>(
      "miopenConvolutionBackwardWeightsImmediate", handle, dyDesc, dy, xDesc, x,
      convDesc, dwDesc, dw, workSpace, workSpaceSize, solution_id);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionForwardGetWorkSpaceSize(
    miopenHandle_t handle, const miopenTensorDescriptor_t wDesc,
    const miopenTensorDescriptor_t xDesc,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t yDesc, size_t* workSpaceSize) {
  return DynamicCall<decltype(miopenConvolutionForwardGetWorkSpaceSize),
                     &miopenConvolutionForwardGetWorkSpaceSize>(
      "miopenConvolutionForwardGetWorkSpaceSize", handle, wDesc, xDesc,
      convDesc, yDesc, workSpaceSize);
}

MIOPEN_EXPORT miopenStatus_t miopenFindConvolutionForwardAlgorithm(
    miopenHandle_t handle, const miopenTensorDescriptor_t xDesc, const void* x,
    const miopenTensorDescriptor_t wDesc, const void* w,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t yDesc, void* y, const int requestAlgoCount,
    int* returnedAlgoCount, miopenConvAlgoPerf_t* perfResults, void* workSpace,
    size_t workSpaceSize, bool exhaustiveSearch) {
  return DynamicCall<decltype(miopenFindConvolutionForwardAlgorithm),
                     &miopenFindConvolutionForwardAlgorithm>(
      "miopenFindConvolutionForwardAlgorithm", handle, xDesc, x, wDesc, w,
      convDesc, yDesc, y, requestAlgoCount, returnedAlgoCount, perfResults,
      workSpace, workSpaceSize, exhaustiveSearch);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionForward(
    miopenHandle_t handle, const void* alpha,
    const miopenTensorDescriptor_t xDesc, const void* x,
    const miopenTensorDescriptor_t wDesc, const void* w,
    const miopenConvolutionDescriptor_t convDesc, miopenConvFwdAlgorithm_t algo,
    const void* beta, const miopenTensorDescriptor_t yDesc, void* y,
    void* workSpace, size_t workSpaceSize) {
  return DynamicCall<decltype(miopenConvolutionForward),
                     &miopenConvolutionForward>(
      "miopenConvolutionForward", handle, alpha, xDesc, x, wDesc, w, convDesc,
      algo, beta, yDesc, y, workSpace, workSpaceSize);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionForwardBias(
    miopenHandle_t handle, const void* alpha,
    const miopenTensorDescriptor_t bDesc, const void* b, const void* beta,
    const miopenTensorDescriptor_t yDesc, void* y) {
  return DynamicCall<decltype(miopenConvolutionForwardBias),
                     &miopenConvolutionForwardBias>(
      "miopenConvolutionForwardBias", handle, alpha, bDesc, b, beta, yDesc, y);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionBackwardDataGetWorkSpaceSize(
    miopenHandle_t handle, const miopenTensorDescriptor_t dyDesc,
    const miopenTensorDescriptor_t wDesc,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t dxDesc, size_t* workSpaceSize) {
  return DynamicCall<decltype(miopenConvolutionBackwardDataGetWorkSpaceSize),
                     &miopenConvolutionBackwardDataGetWorkSpaceSize>(
      "miopenConvolutionBackwardDataGetWorkSpaceSize", handle, dyDesc, wDesc,
      convDesc, dxDesc, workSpaceSize);
}

MIOPEN_EXPORT miopenStatus_t miopenFindConvolutionBackwardDataAlgorithm(
    miopenHandle_t handle, const miopenTensorDescriptor_t dyDesc,
    const void* dy, const miopenTensorDescriptor_t wDesc, const void* w,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t dxDesc, void* dx, const int requestAlgoCount,
    int* returnedAlgoCount, miopenConvAlgoPerf_t* perfResults, void* workSpace,
    size_t workSpaceSize, bool exhaustiveSearch) {
  return DynamicCall<decltype(miopenFindConvolutionBackwardDataAlgorithm),
                     &miopenFindConvolutionBackwardDataAlgorithm>(
      "miopenFindConvolutionBackwardDataAlgorithm", handle, dyDesc, dy, wDesc,
      w, convDesc, dxDesc, dx, requestAlgoCount, returnedAlgoCount, perfResults,
      workSpace, workSpaceSize, exhaustiveSearch);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionBackwardData(
    miopenHandle_t handle, const void* alpha,
    const miopenTensorDescriptor_t dyDesc, const void* dy,
    const miopenTensorDescriptor_t wDesc, const void* w,
    const miopenConvolutionDescriptor_t convDesc,
    miopenConvBwdDataAlgorithm_t algo, const void* beta,
    const miopenTensorDescriptor_t dxDesc, void* dx, void* workSpace,
    size_t workSpaceSize) {
  return DynamicCall<decltype(miopenConvolutionBackwardData),
                     &miopenConvolutionBackwardData>(
      "miopenConvolutionBackwardData", handle, alpha, dyDesc, dy, wDesc, w,
      convDesc, algo, beta, dxDesc, dx, workSpace, workSpaceSize);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionBackwardWeightsGetWorkSpaceSize(
    miopenHandle_t handle, const miopenTensorDescriptor_t dyDesc,
    const miopenTensorDescriptor_t xDesc,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t dwDesc, size_t* workSpaceSize) {
  return DynamicCall<decltype(miopenConvolutionBackwardWeightsGetWorkSpaceSize),
                     &miopenConvolutionBackwardWeightsGetWorkSpaceSize>(
      "miopenConvolutionBackwardWeightsGetWorkSpaceSize", handle, dyDesc, xDesc,
      convDesc, dwDesc, workSpaceSize);
}

MIOPEN_EXPORT miopenStatus_t miopenFindConvolutionBackwardWeightsAlgorithm(
    miopenHandle_t handle, const miopenTensorDescriptor_t dyDesc,
    const void* dy, const miopenTensorDescriptor_t xDesc, const void* x,
    const miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t dwDesc, void* dw, const int requestAlgoCount,
    int* returnedAlgoCount, miopenConvAlgoPerf_t* perfResults, void* workSpace,
    size_t workSpaceSize, bool exhaustiveSearch) {
  return DynamicCall<decltype(miopenFindConvolutionBackwardWeightsAlgorithm),
                     &miopenFindConvolutionBackwardWeightsAlgorithm>(
      "miopenFindConvolutionBackwardWeightsAlgorithm", handle, dyDesc, dy,
      xDesc, x, convDesc, dwDesc, dw, requestAlgoCount, returnedAlgoCount,
      perfResults, workSpace, workSpaceSize, exhaustiveSearch);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionBackwardWeights(
    miopenHandle_t handle, const void* alpha,
    const miopenTensorDescriptor_t dyDesc, const void* dy,
    const miopenTensorDescriptor_t xDesc, const void* x,
    const miopenConvolutionDescriptor_t convDesc,
    miopenConvBwdWeightsAlgorithm_t algo, const void* beta,
    const miopenTensorDescriptor_t dwDesc, void* dw, void* workSpace,
    size_t workSpaceSize) {
  return DynamicCall<decltype(miopenConvolutionBackwardWeights),
                     &miopenConvolutionBackwardWeights>(
      "miopenConvolutionBackwardWeights", handle, alpha, dyDesc, dy, xDesc, x,
      convDesc, algo, beta, dwDesc, dw, workSpace, workSpaceSize);
}

MIOPEN_EXPORT miopenStatus_t miopenConvolutionBackwardBias(
    miopenHandle_t handle, const void* alpha,
    const miopenTensorDescriptor_t dyDesc, const void* dy, const void* beta,
    const miopenTensorDescriptor_t dbDesc, void* db) {
  return DynamicCall<decltype(miopenConvolutionBackwardBias),
                     &miopenConvolutionBackwardBias>(
      "miopenConvolutionBackwardBias", handle, alpha, dyDesc, dy, beta, dbDesc,
      db);
}

MIOPEN_EXPORT miopenStatus_t
miopenCreatePoolingDescriptor(miopenPoolingDescriptor_t* poolDesc) {
  return DynamicCall<decltype(miopenCreatePoolingDescriptor),
                     &miopenCreatePoolingDescriptor>(
      "miopenCreatePoolingDescriptor", poolDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenSetPoolingIndexType(
    miopenPoolingDescriptor_t poolDesc, miopenIndexType_t index_type) {
  return DynamicCall<decltype(miopenSetPoolingIndexType),
                     &miopenSetPoolingIndexType>("miopenSetPoolingIndexType",
                                                 poolDesc, index_type);
}

MIOPEN_EXPORT miopenStatus_t miopenGetPoolingIndexType(
    miopenPoolingDescriptor_t poolDesc, miopenIndexType_t* index_type) {
  return DynamicCall<decltype(miopenGetPoolingIndexType),
                     &miopenGetPoolingIndexType>("miopenGetPoolingIndexType",
                                                 poolDesc, index_type);
}

MIOPEN_EXPORT miopenStatus_t miopenSetPoolingWorkSpaceIndexMode(
    miopenPoolingDescriptor_t poolDesc,
    miopenPoolingWorkspaceIndexMode_t workspace_index) {
  return DynamicCall<decltype(miopenSetPoolingWorkSpaceIndexMode),
                     &miopenSetPoolingWorkSpaceIndexMode>(
      "miopenSetPoolingWorkSpaceIndexMode", poolDesc, workspace_index);
}

MIOPEN_EXPORT miopenStatus_t miopenGetPoolingWorkSpaceIndexMode(
    miopenPoolingDescriptor_t poolDesc,
    miopenPoolingWorkspaceIndexMode_t* workspace_index) {
  return DynamicCall<decltype(miopenGetPoolingWorkSpaceIndexMode),
                     &miopenGetPoolingWorkSpaceIndexMode>(
      "miopenGetPoolingWorkSpaceIndexMode", poolDesc, workspace_index);
}

MIOPEN_EXPORT miopenStatus_t miopenSet2dPoolingDescriptor(
    miopenPoolingDescriptor_t poolDesc, miopenPoolingMode_t mode,
    int windowHeight, int windowWidth, int pad_h, int pad_w, int stride_h,
    int stride_w) {
  return DynamicCall<decltype(miopenSet2dPoolingDescriptor),
                     &miopenSet2dPoolingDescriptor>(
      "miopenSet2dPoolingDescriptor", poolDesc, mode, windowHeight, windowWidth,
      pad_h, pad_w, stride_h, stride_w);
}

MIOPEN_EXPORT miopenStatus_t miopenGet2dPoolingDescriptor(
    const miopenPoolingDescriptor_t poolDesc, miopenPoolingMode_t* mode,
    int* windowHeight, int* windowWidth, int* pad_h, int* pad_w, int* stride_h,
    int* stride_w) {
  return DynamicCall<decltype(miopenGet2dPoolingDescriptor),
                     &miopenGet2dPoolingDescriptor>(
      "miopenGet2dPoolingDescriptor", poolDesc, mode, windowHeight, windowWidth,
      pad_h, pad_w, stride_h, stride_w);
}

MIOPEN_EXPORT miopenStatus_t miopenGetPoolingForwardOutputDim(
    const miopenPoolingDescriptor_t poolDesc,
    const miopenTensorDescriptor_t tensorDesc, int* n, int* c, int* h, int* w) {
  return DynamicCall<decltype(miopenGetPoolingForwardOutputDim),
                     &miopenGetPoolingForwardOutputDim>(
      "miopenGetPoolingForwardOutputDim", poolDesc, tensorDesc, n, c, h, w);
}

MIOPEN_EXPORT miopenStatus_t miopenSetNdPoolingDescriptor(
    miopenPoolingDescriptor_t poolDesc, const miopenPoolingMode_t mode,
    int nbDims, int* windowDimA, int* padA, int* stridesA) {
  return DynamicCall<decltype(miopenSetNdPoolingDescriptor),
                     &miopenSetNdPoolingDescriptor>(
      "miopenSetNdPoolingDescriptor", poolDesc, mode, nbDims, windowDimA, padA,
      stridesA);
}

MIOPEN_EXPORT miopenStatus_t miopenGetNdPoolingDescriptor(
    const miopenPoolingDescriptor_t poolDesc, int nbDimsRequested,
    miopenPoolingMode_t* mode, int* nbDims, int* windowDimA, int* padA,
    int* stridesA) {
  return DynamicCall<decltype(miopenGetNdPoolingDescriptor),
                     &miopenGetNdPoolingDescriptor>(
      "miopenGetNdPoolingDescriptor", poolDesc, nbDimsRequested, mode, nbDims,
      windowDimA, padA, stridesA);
}

MIOPEN_EXPORT miopenStatus_t miopenGetPoolingNdForwardOutputDim(
    const miopenPoolingDescriptor_t poolDesc,
    const miopenTensorDescriptor_t tensorDesc, int dims, int* tensorDimArr) {
  return DynamicCall<decltype(miopenGetPoolingNdForwardOutputDim),
                     &miopenGetPoolingNdForwardOutputDim>(
      "miopenGetPoolingNdForwardOutputDim", poolDesc, tensorDesc, dims,
      tensorDimArr);
}

MIOPEN_EXPORT miopenStatus_t miopenPoolingGetWorkSpaceSize(
    const miopenTensorDescriptor_t yDesc, size_t* workSpaceSize) {
  return DynamicCall<decltype(miopenPoolingGetWorkSpaceSize),
                     &miopenPoolingGetWorkSpaceSize>(
      "miopenPoolingGetWorkSpaceSize", yDesc, workSpaceSize);
}

MIOPEN_EXPORT miopenStatus_t miopenPoolingGetWorkSpaceSizeV2(
    const miopenPoolingDescriptor_t poolDesc,
    const miopenTensorDescriptor_t yDesc, size_t* workSpaceSize) {
  return DynamicCall<decltype(miopenPoolingGetWorkSpaceSizeV2),
                     &miopenPoolingGetWorkSpaceSizeV2>(
      "miopenPoolingGetWorkSpaceSizeV2", poolDesc, yDesc, workSpaceSize);
}

MIOPEN_EXPORT miopenStatus_t miopenPoolingForward(
    miopenHandle_t handle, const miopenPoolingDescriptor_t poolDesc,
    const void* alpha, const miopenTensorDescriptor_t xDesc, const void* x,
    const void* beta, const miopenTensorDescriptor_t yDesc, void* y,
    bool do_backward, void* workSpace, size_t workSpaceSize) {
  return DynamicCall<decltype(miopenPoolingForward), &miopenPoolingForward>(
      "miopenPoolingForward", handle, poolDesc, alpha, xDesc, x, beta, yDesc, y,
      do_backward, workSpace, workSpaceSize);
}

MIOPEN_EXPORT miopenStatus_t miopenPoolingBackward(
    miopenHandle_t handle, const miopenPoolingDescriptor_t poolDesc,
    const void* alpha, const miopenTensorDescriptor_t yDesc, const void* y,
    const miopenTensorDescriptor_t dyDesc, const void* dy,
    const miopenTensorDescriptor_t xDesc, const void* x, const void* beta,
    const miopenTensorDescriptor_t dxDesc, void* dx, const void* workSpace) {
  return DynamicCall<decltype(miopenPoolingBackward), &miopenPoolingBackward>(
      "miopenPoolingBackward", handle, poolDesc, alpha, yDesc, y, dyDesc, dy,
      xDesc, x, beta, dxDesc, dx, workSpace);
}

MIOPEN_EXPORT miopenStatus_t
miopenDestroyPoolingDescriptor(miopenPoolingDescriptor_t poolDesc) {
  return DynamicCall<decltype(miopenDestroyPoolingDescriptor),
                     &miopenDestroyPoolingDescriptor>(
      "miopenDestroyPoolingDescriptor", poolDesc);
}

MIOPEN_EXPORT miopenStatus_t
miopenCreateLRNDescriptor(miopenLRNDescriptor_t* lrnDesc) {
  return DynamicCall<decltype(miopenCreateLRNDescriptor),
                     &miopenCreateLRNDescriptor>("miopenCreateLRNDescriptor",
                                                 lrnDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenSetLRNDescriptor(
    const miopenLRNDescriptor_t lrnDesc, miopenLRNMode_t mode,
    unsigned int lrnN, double lrnAlpha, double lrnBeta, double lrnK) {
  return DynamicCall<decltype(miopenSetLRNDescriptor), &miopenSetLRNDescriptor>(
      "miopenSetLRNDescriptor", lrnDesc, mode, lrnN, lrnAlpha, lrnBeta, lrnK);
}

MIOPEN_EXPORT miopenStatus_t miopenGetLRNDescriptor(
    const miopenLRNDescriptor_t lrnDesc, miopenLRNMode_t* mode,
    unsigned int* lrnN, double* lrnAlpha, double* lrnBeta, double* lrnK) {
  return DynamicCall<decltype(miopenGetLRNDescriptor), &miopenGetLRNDescriptor>(
      "miopenGetLRNDescriptor", lrnDesc, mode, lrnN, lrnAlpha, lrnBeta, lrnK);
}

MIOPEN_EXPORT miopenStatus_t miopenLRNGetWorkSpaceSize(
    const miopenTensorDescriptor_t yDesc, size_t* workSpaceSize) {
  return DynamicCall<decltype(miopenLRNGetWorkSpaceSize),
                     &miopenLRNGetWorkSpaceSize>("miopenLRNGetWorkSpaceSize",
                                                 yDesc, workSpaceSize);
}

MIOPEN_EXPORT miopenStatus_t miopenLRNForward(
    miopenHandle_t handle, const miopenLRNDescriptor_t lrnDesc,
    const void* alpha, const miopenTensorDescriptor_t xDesc, const void* x,
    const void* beta, const miopenTensorDescriptor_t yDesc, void* y,
    bool do_backward, void* workSpace) {
  return DynamicCall<decltype(miopenLRNForward), &miopenLRNForward>(
      "miopenLRNForward", handle, lrnDesc, alpha, xDesc, x, beta, yDesc, y,
      do_backward, workSpace);
}

MIOPEN_EXPORT miopenStatus_t miopenLRNBackward(
    miopenHandle_t handle, const miopenLRNDescriptor_t lrnDesc,
    const void* alpha, const miopenTensorDescriptor_t yDesc, const void* y,
    const miopenTensorDescriptor_t dyDesc, const void* dy,
    const miopenTensorDescriptor_t xDesc, const void* x, const void* beta,
    const miopenTensorDescriptor_t dxDesc, void* dx, const void* workSpace) {
  return DynamicCall<decltype(miopenLRNBackward), &miopenLRNBackward>(
      "miopenLRNBackward", handle, lrnDesc, alpha, yDesc, y, dyDesc, dy, xDesc,
      x, beta, dxDesc, dx, workSpace);
}

MIOPEN_EXPORT miopenStatus_t
miopenDestroyLRNDescriptor(miopenLRNDescriptor_t lrnDesc) {
  return DynamicCall<decltype(miopenDestroyLRNDescriptor),
                     &miopenDestroyLRNDescriptor>("miopenDestroyLRNDescriptor",
                                                  lrnDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenDeriveBNTensorDescriptor(
    miopenTensorDescriptor_t derivedBnDesc,
    const miopenTensorDescriptor_t xDesc, miopenBatchNormMode_t bn_mode) {
  return DynamicCall<decltype(miopenDeriveBNTensorDescriptor),
                     &miopenDeriveBNTensorDescriptor>(
      "miopenDeriveBNTensorDescriptor", derivedBnDesc, xDesc, bn_mode);
}

MIOPEN_EXPORT miopenStatus_t miopenBatchNormalizationForwardTraining(
    miopenHandle_t handle, miopenBatchNormMode_t bn_mode, void* alpha,
    void* beta, const miopenTensorDescriptor_t xDesc, const void* x,
    const miopenTensorDescriptor_t yDesc, void* y,
    const miopenTensorDescriptor_t bnScaleBiasMeanVarDesc, void* bnScale,
    void* bnBias, double expAvgFactor, void* resultRunningMean,
    void* resultRunningVariance, double epsilon, void* resultSaveMean,
    void* resultSaveInvVariance) {
  return DynamicCall<decltype(miopenBatchNormalizationForwardTraining),
                     &miopenBatchNormalizationForwardTraining>(
      "miopenBatchNormalizationForwardTraining", handle, bn_mode, alpha, beta,
      xDesc, x, yDesc, y, bnScaleBiasMeanVarDesc, bnScale, bnBias, expAvgFactor,
      resultRunningMean, resultRunningVariance, epsilon, resultSaveMean,
      resultSaveInvVariance);
}

MIOPEN_EXPORT miopenStatus_t miopenBatchNormalizationForwardInference(
    miopenHandle_t handle, miopenBatchNormMode_t bn_mode, void* alpha,
    void* beta, const miopenTensorDescriptor_t xDesc, const void* x,
    const miopenTensorDescriptor_t yDesc, void* y,
    const miopenTensorDescriptor_t bnScaleBiasMeanVarDesc, void* bnScale,
    void* bnBias, void* estimatedMean, void* estimatedVariance,
    double epsilon) {
  return DynamicCall<decltype(miopenBatchNormalizationForwardInference),
                     &miopenBatchNormalizationForwardInference>(
      "miopenBatchNormalizationForwardInference", handle, bn_mode, alpha, beta,
      xDesc, x, yDesc, y, bnScaleBiasMeanVarDesc, bnScale, bnBias,
      estimatedMean, estimatedVariance, epsilon);
}

MIOPEN_EXPORT miopenStatus_t miopenBatchNormalizationBackward(
    miopenHandle_t handle, miopenBatchNormMode_t bn_mode,
    const void* alphaDataDiff, const void* betaDataDiff,
    const void* alphaParamDiff, const void* betaParamDiff,
    const miopenTensorDescriptor_t xDesc, const void* x,
    const miopenTensorDescriptor_t dyDesc, const void* dy,
    const miopenTensorDescriptor_t dxDesc, void* dx,
    const miopenTensorDescriptor_t bnScaleBiasDiffDesc, const void* bnScale,
    void* resultBnScaleDiff, void* resultBnBiasDiff, double epsilon,
    const void* savedMean, const void* savedInvVariance) {
  return DynamicCall<decltype(miopenBatchNormalizationBackward),
                     &miopenBatchNormalizationBackward>(
      "miopenBatchNormalizationBackward", handle, bn_mode, alphaDataDiff,
      betaDataDiff, alphaParamDiff, betaParamDiff, xDesc, x, dyDesc, dy, dxDesc,
      dx, bnScaleBiasDiffDesc, bnScale, resultBnScaleDiff, resultBnBiasDiff,
      epsilon, savedMean, savedInvVariance);
}

MIOPEN_EXPORT miopenStatus_t
miopenCreateActivationDescriptor(miopenActivationDescriptor_t* activDesc) {
  return DynamicCall<decltype(miopenCreateActivationDescriptor),
                     &miopenCreateActivationDescriptor>(
      "miopenCreateActivationDescriptor", activDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenSetActivationDescriptor(
    const miopenActivationDescriptor_t activDesc, miopenActivationMode_t mode,
    double activAlpha, double activBeta, double activGamma) {
  return DynamicCall<decltype(miopenSetActivationDescriptor),
                     &miopenSetActivationDescriptor>(
      "miopenSetActivationDescriptor", activDesc, mode, activAlpha, activBeta,
      activGamma);
}

MIOPEN_EXPORT miopenStatus_t miopenGetActivationDescriptor(
    const miopenActivationDescriptor_t activDesc, miopenActivationMode_t* mode,
    double* activAlpha, double* activBeta, double* activGamma) {
  return DynamicCall<decltype(miopenGetActivationDescriptor),
                     &miopenGetActivationDescriptor>(
      "miopenGetActivationDescriptor", activDesc, mode, activAlpha, activBeta,
      activGamma);
}

MIOPEN_EXPORT miopenStatus_t miopenActivationForward(
    miopenHandle_t handle, const miopenActivationDescriptor_t activDesc,
    const void* alpha, const miopenTensorDescriptor_t xDesc, const void* x,
    const void* beta, const miopenTensorDescriptor_t yDesc, void* y) {
  return DynamicCall<decltype(miopenActivationForward),
                     &miopenActivationForward>("miopenActivationForward",
                                               handle, activDesc, alpha, xDesc,
                                               x, beta, yDesc, y);
}

MIOPEN_EXPORT miopenStatus_t miopenActivationBackward(
    miopenHandle_t handle, const miopenActivationDescriptor_t activDesc,
    const void* alpha, const miopenTensorDescriptor_t yDesc, const void* y,
    const miopenTensorDescriptor_t dyDesc, const void* dy,
    const miopenTensorDescriptor_t xDesc, const void* x, const void* beta,
    const miopenTensorDescriptor_t dxDesc, void* dx) {
  return DynamicCall<decltype(miopenActivationBackward),
                     &miopenActivationBackward>(
      "miopenActivationBackward", handle, activDesc, alpha, yDesc, y, dyDesc,
      dy, xDesc, x, beta, dxDesc, dx);
}

MIOPEN_EXPORT miopenStatus_t
miopenDestroyActivationDescriptor(miopenActivationDescriptor_t activDesc) {
  return DynamicCall<decltype(miopenDestroyActivationDescriptor),
                     &miopenDestroyActivationDescriptor>(
      "miopenDestroyActivationDescriptor", activDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenSoftmaxForward(
    miopenHandle_t handle, const void* alpha,
    const miopenTensorDescriptor_t xDesc, const void* x, const void* beta,
    const miopenTensorDescriptor_t yDesc, void* y) {
  return DynamicCall<decltype(miopenSoftmaxForward), &miopenSoftmaxForward>(
      "miopenSoftmaxForward", handle, alpha, xDesc, x, beta, yDesc, y);
}

MIOPEN_EXPORT miopenStatus_t miopenSoftmaxBackward(
    miopenHandle_t handle, const void* alpha,
    const miopenTensorDescriptor_t yDesc, const void* y,
    const miopenTensorDescriptor_t dyDesc, const void* dy, const void* beta,
    const miopenTensorDescriptor_t dxDesc, void* dx) {
  return DynamicCall<decltype(miopenSoftmaxBackward), &miopenSoftmaxBackward>(
      "miopenSoftmaxBackward", handle, alpha, yDesc, y, dyDesc, dy, beta,
      dxDesc, dx);
}

MIOPEN_EXPORT miopenStatus_t miopenSoftmaxForward_V2(
    miopenHandle_t handle, const void* alpha,
    const miopenTensorDescriptor_t xDesc, const void* x, const void* beta,
    const miopenTensorDescriptor_t yDesc, void* y,
    miopenSoftmaxAlgorithm_t algorithm, miopenSoftmaxMode_t mode) {
  return DynamicCall<decltype(miopenSoftmaxForward_V2),
                     &miopenSoftmaxForward_V2>("miopenSoftmaxForward_V2",
                                               handle, alpha, xDesc, x, beta,
                                               yDesc, y, algorithm, mode);
}

MIOPEN_EXPORT miopenStatus_t miopenSoftmaxBackward_V2(
    miopenHandle_t handle, const void* alpha,
    const miopenTensorDescriptor_t yDesc, const void* y,
    const miopenTensorDescriptor_t dyDesc, const void* dy, const void* beta,
    const miopenTensorDescriptor_t dxDesc, void* dx,
    miopenSoftmaxAlgorithm_t algorithm, miopenSoftmaxMode_t mode) {
  return DynamicCall<decltype(miopenSoftmaxBackward_V2),
                     &miopenSoftmaxBackward_V2>(
      "miopenSoftmaxBackward_V2", handle, alpha, yDesc, y, dyDesc, dy, beta,
      dxDesc, dx, algorithm, mode);
}

MIOPEN_EXPORT miopenStatus_t
miopenCreateFusionPlan(miopenFusionPlanDescriptor_t* fusePlanDesc,
                       const miopenFusionDirection_t fuseDirection,
                       const miopenTensorDescriptor_t inputDesc) {
  return DynamicCall<decltype(miopenCreateFusionPlan), &miopenCreateFusionPlan>(
      "miopenCreateFusionPlan", fusePlanDesc, fuseDirection, inputDesc);
}

MIOPEN_EXPORT miopenStatus_t
miopenDestroyFusionPlan(miopenFusionPlanDescriptor_t fusePlanDesc) {
  return DynamicCall<decltype(miopenDestroyFusionPlan),
                     &miopenDestroyFusionPlan>("miopenDestroyFusionPlan",
                                               fusePlanDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenCompileFusionPlan(
    miopenHandle_t handle, miopenFusionPlanDescriptor_t fusePlanDesc) {
  return DynamicCall<decltype(miopenCompileFusionPlan),
                     &miopenCompileFusionPlan>("miopenCompileFusionPlan",
                                               handle, fusePlanDesc);
}

MIOPEN_EXPORT miopenStatus_t
miopenFusionPlanGetOp(miopenFusionPlanDescriptor_t fusePlanDesc,
                      const int op_idx, miopenFusionOpDescriptor_t* op) {
  return DynamicCall<decltype(miopenFusionPlanGetOp), &miopenFusionPlanGetOp>(
      "miopenFusionPlanGetOp", fusePlanDesc, op_idx, op);
}

MIOPEN_EXPORT miopenStatus_t miopenFusionPlanGetWorkSpaceSize(
    miopenHandle_t handle, miopenFusionPlanDescriptor_t fusePlanDesc,
    size_t* workSpaceSize, miopenConvFwdAlgorithm_t algo) {
  return DynamicCall<decltype(miopenFusionPlanGetWorkSpaceSize),
                     &miopenFusionPlanGetWorkSpaceSize>(
      "miopenFusionPlanGetWorkSpaceSize", handle, fusePlanDesc, workSpaceSize,
      algo);
}

MIOPEN_EXPORT miopenStatus_t miopenFusionPlanConvolutionGetAlgo(
    miopenFusionPlanDescriptor_t fusePlanDesc, const int requestAlgoCount,
    int* returnedAlgoCount, miopenConvFwdAlgorithm_t* returnedAlgos) {
  return DynamicCall<decltype(miopenFusionPlanConvolutionGetAlgo),
                     &miopenFusionPlanConvolutionGetAlgo>(
      "miopenFusionPlanConvolutionGetAlgo", fusePlanDesc, requestAlgoCount,
      returnedAlgoCount, returnedAlgos);
}

MIOPEN_EXPORT miopenStatus_t miopenFusionPlanConvolutionSetAlgo(
    miopenFusionPlanDescriptor_t fusePlanDesc, miopenConvFwdAlgorithm_t algo) {
  return DynamicCall<decltype(miopenFusionPlanConvolutionSetAlgo),
                     &miopenFusionPlanConvolutionSetAlgo>(
      "miopenFusionPlanConvolutionSetAlgo", fusePlanDesc, algo);
}

MIOPEN_EXPORT miopenStatus_t miopenCreateOpConvForward(
    miopenFusionPlanDescriptor_t fusePlanDesc,
    miopenFusionOpDescriptor_t* convOp, miopenConvolutionDescriptor_t convDesc,
    const miopenTensorDescriptor_t wDesc) {
  return DynamicCall<decltype(miopenCreateOpConvForward),
                     &miopenCreateOpConvForward>(
      "miopenCreateOpConvForward", fusePlanDesc, convOp, convDesc, wDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenCreateOpActivationForward(
    miopenFusionPlanDescriptor_t fusePlanDesc,
    miopenFusionOpDescriptor_t* activFwdOp, miopenActivationMode_t mode) {
  return DynamicCall<decltype(miopenCreateOpActivationForward),
                     &miopenCreateOpActivationForward>(
      "miopenCreateOpActivationForward", fusePlanDesc, activFwdOp, mode);
}

MIOPEN_EXPORT miopenStatus_t miopenCreateOpActivationBackward(
    miopenFusionPlanDescriptor_t fusePlanDesc,
    miopenFusionOpDescriptor_t* activBwdOp, miopenActivationMode_t mode) {
  return DynamicCall<decltype(miopenCreateOpActivationBackward),
                     &miopenCreateOpActivationBackward>(
      "miopenCreateOpActivationBackward", fusePlanDesc, activBwdOp, mode);
}

MIOPEN_EXPORT miopenStatus_t miopenCreateOpBiasForward(
    miopenFusionPlanDescriptor_t fusePlanDesc,
    miopenFusionOpDescriptor_t* biasOp, const miopenTensorDescriptor_t bDesc) {
  return DynamicCall<decltype(miopenCreateOpBiasForward),
                     &miopenCreateOpBiasForward>("miopenCreateOpBiasForward",
                                                 fusePlanDesc, biasOp, bDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenCreateOpBatchNormInference(
    miopenFusionPlanDescriptor_t fusePlanDesc, miopenFusionOpDescriptor_t* bnOp,
    const miopenBatchNormMode_t bn_mode,
    const miopenTensorDescriptor_t bnScaleBiasMeanVarDesc) {
  return DynamicCall<decltype(miopenCreateOpBatchNormInference),
                     &miopenCreateOpBatchNormInference>(
      "miopenCreateOpBatchNormInference", fusePlanDesc, bnOp, bn_mode,
      bnScaleBiasMeanVarDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenCreateOpBatchNormForward(
    miopenFusionPlanDescriptor_t fusePlanDesc,
    miopenFusionOpDescriptor_t* bnFwdOp, const miopenBatchNormMode_t bn_mode,
    bool runningMeanVariance) {
  return DynamicCall<decltype(miopenCreateOpBatchNormForward),
                     &miopenCreateOpBatchNormForward>(
      "miopenCreateOpBatchNormForward", fusePlanDesc, bnFwdOp, bn_mode,
      runningMeanVariance);
}

MIOPEN_EXPORT miopenStatus_t miopenCreateOpBatchNormBackward(
    miopenFusionPlanDescriptor_t fusePlanDesc,
    miopenFusionOpDescriptor_t* bnBwdOp, const miopenBatchNormMode_t bn_mode) {
  return DynamicCall<decltype(miopenCreateOpBatchNormBackward),
                     &miopenCreateOpBatchNormBackward>(
      "miopenCreateOpBatchNormBackward", fusePlanDesc, bnBwdOp, bn_mode);
}

MIOPEN_EXPORT miopenStatus_t
miopenCreateOperatorArgs(miopenOperatorArgs_t* args) {
  return DynamicCall<decltype(miopenCreateOperatorArgs),
                     &miopenCreateOperatorArgs>("miopenCreateOperatorArgs",
                                                args);
}

MIOPEN_EXPORT miopenStatus_t
miopenDestroyOperatorArgs(miopenOperatorArgs_t args) {
  return DynamicCall<decltype(miopenDestroyOperatorArgs),
                     &miopenDestroyOperatorArgs>("miopenDestroyOperatorArgs",
                                                 args);
}

MIOPEN_EXPORT miopenStatus_t miopenSetOpArgsConvForward(
    miopenOperatorArgs_t args, const miopenFusionOpDescriptor_t convOp,
    const void* alpha, const void* beta, const void* w) {
  return DynamicCall<decltype(miopenSetOpArgsConvForward),
                     &miopenSetOpArgsConvForward>("miopenSetOpArgsConvForward",
                                                  args, convOp, alpha, beta, w);
}

MIOPEN_EXPORT miopenStatus_t miopenSetOpArgsActivForward(
    miopenOperatorArgs_t args, const miopenFusionOpDescriptor_t activFwdOp,
    const void* alpha, const void* beta, double activAlpha, double activBeta,
    double activGamma) {
  return DynamicCall<decltype(miopenSetOpArgsActivForward),
                     &miopenSetOpArgsActivForward>(
      "miopenSetOpArgsActivForward", args, activFwdOp, alpha, beta, activAlpha,
      activBeta, activGamma);
}

MIOPEN_EXPORT miopenStatus_t miopenSetOpArgsActivBackward(
    miopenOperatorArgs_t args, const miopenFusionOpDescriptor_t activBwdOp,
    const void* alpha, const void* beta, const void* y, const void* reserved,
    double activAlpha, double activBeta, double activGamma) {
  return DynamicCall<decltype(miopenSetOpArgsActivBackward),
                     &miopenSetOpArgsActivBackward>(
      "miopenSetOpArgsActivBackward", args, activBwdOp, alpha, beta, y,
      reserved, activAlpha, activBeta, activGamma);
}

MIOPEN_EXPORT miopenStatus_t miopenSetOpArgsBatchNormInference(
    miopenOperatorArgs_t args, const miopenFusionOpDescriptor_t bnOp,
    const void* alpha, const void* beta, const void* bnScale,
    const void* bnBias, const void* estimatedMean,
    const void* estimatedVariance, double epsilon) {
  return DynamicCall<decltype(miopenSetOpArgsBatchNormInference),
                     &miopenSetOpArgsBatchNormInference>(
      "miopenSetOpArgsBatchNormInference", args, bnOp, alpha, beta, bnScale,
      bnBias, estimatedMean, estimatedVariance, epsilon);
}

MIOPEN_EXPORT miopenStatus_t miopenSetOpArgsBatchNormForward(
    miopenOperatorArgs_t args, const miopenFusionOpDescriptor_t bnOp,
    const void* alpha, const void* beta, const void* bnScale,
    const void* bnBias, void* savedMean, void* savedInvVariance,
    void* runningMean, void* runningVariance, double expAvgFactor,
    double epsilon) {
  return DynamicCall<decltype(miopenSetOpArgsBatchNormForward),
                     &miopenSetOpArgsBatchNormForward>(
      "miopenSetOpArgsBatchNormForward", args, bnOp, alpha, beta, bnScale,
      bnBias, savedMean, savedInvVariance, runningMean, runningVariance,
      expAvgFactor, epsilon);
}

MIOPEN_EXPORT miopenStatus_t miopenSetOpArgsBatchNormBackward(
    miopenOperatorArgs_t args, const miopenFusionOpDescriptor_t bnOp,
    const void* alpha, const void* beta, const void* x, const void* bnScale,
    const void* bnBias, void* resultBnScaleDiff, void* resultBnBiasDiff,
    const void* savedMean, const void* savedInvVariance) {
  return DynamicCall<decltype(miopenSetOpArgsBatchNormBackward),
                     &miopenSetOpArgsBatchNormBackward>(
      "miopenSetOpArgsBatchNormBackward", args, bnOp, alpha, beta, x, bnScale,
      bnBias, resultBnScaleDiff, resultBnBiasDiff, savedMean, savedInvVariance);
}

MIOPEN_EXPORT miopenStatus_t miopenSetOpArgsBiasForward(
    miopenOperatorArgs_t args, const miopenFusionOpDescriptor_t biasOp,
    const void* alpha, const void* beta, const void* bias) {
  return DynamicCall<decltype(miopenSetOpArgsBiasForward),
                     &miopenSetOpArgsBiasForward>(
      "miopenSetOpArgsBiasForward", args, biasOp, alpha, beta, bias);
}

MIOPEN_EXPORT miopenStatus_t miopenExecuteFusionPlan(
    const miopenHandle_t handle,
    const miopenFusionPlanDescriptor_t fusePlanDesc,
    const miopenTensorDescriptor_t inputDesc, const void* input,
    const miopenTensorDescriptor_t outputDesc, void* output,
    miopenOperatorArgs_t args) {
  return DynamicCall<decltype(miopenExecuteFusionPlan),
                     &miopenExecuteFusionPlan>("miopenExecuteFusionPlan",
                                               handle, fusePlanDesc, inputDesc,
                                               input, outputDesc, output, args);
}

MIOPEN_EXPORT miopenStatus_t
miopenCreateRNNDescriptor(miopenRNNDescriptor_t* rnnDesc) {
  return DynamicCall<decltype(miopenCreateRNNDescriptor),
                     &miopenCreateRNNDescriptor>("miopenCreateRNNDescriptor",
                                                 rnnDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenGetRNNDescriptor(
    miopenRNNDescriptor_t rnnDesc, miopenRNNMode_t* rnnMode,
    miopenRNNAlgo_t* algoMode, miopenRNNInputMode_t* inputMode,
    miopenRNNDirectionMode_t* dirMode, miopenRNNBiasMode_t* biasMode,
    int* hiddenSize, int* layer) {
  return DynamicCall<decltype(miopenGetRNNDescriptor), &miopenGetRNNDescriptor>(
      "miopenGetRNNDescriptor", rnnDesc, rnnMode, algoMode, inputMode, dirMode,
      biasMode, hiddenSize, layer);
}

MIOPEN_EXPORT miopenStatus_t miopenGetRNNDescriptor_V2(
    miopenRNNDescriptor_t rnnDesc, int* hiddenSize, int* layer,
    miopenDropoutDescriptor_t* dropoutDesc, miopenRNNInputMode_t* inputMode,
    miopenRNNDirectionMode_t* dirMode, miopenRNNMode_t* rnnMode,
    miopenRNNBiasMode_t* biasMode, miopenRNNAlgo_t* algoMode,
    miopenDataType_t* dataType) {
  return DynamicCall<decltype(miopenGetRNNDescriptor_V2),
                     &miopenGetRNNDescriptor_V2>(
      "miopenGetRNNDescriptor_V2", rnnDesc, hiddenSize, layer, dropoutDesc,
      inputMode, dirMode, rnnMode, biasMode, algoMode, dataType);
}

MIOPEN_EXPORT miopenStatus_t
miopenDestroyRNNDescriptor(miopenRNNDescriptor_t rnnDesc) {
  return DynamicCall<decltype(miopenDestroyRNNDescriptor),
                     &miopenDestroyRNNDescriptor>("miopenDestroyRNNDescriptor",
                                                  rnnDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenSetRNNDescriptor(
    miopenRNNDescriptor_t rnnDesc, const int hsize, const int nlayers,
    miopenRNNInputMode_t inMode, miopenRNNDirectionMode_t direction,
    miopenRNNMode_t rnnMode, miopenRNNBiasMode_t biasMode, miopenRNNAlgo_t algo,
    miopenDataType_t dataType) {
  return DynamicCall<decltype(miopenSetRNNDescriptor), &miopenSetRNNDescriptor>(
      "miopenSetRNNDescriptor", rnnDesc, hsize, nlayers, inMode, direction,
      rnnMode, biasMode, algo, dataType);
}

MIOPEN_EXPORT miopenStatus_t miopenSetRNNDescriptor_V2(
    miopenRNNDescriptor_t rnnDesc, const int hsize, const int nlayers,
    miopenDropoutDescriptor_t dropoutDesc, miopenRNNInputMode_t inMode,
    miopenRNNDirectionMode_t direction, miopenRNNMode_t rnnMode,
    miopenRNNBiasMode_t biasMode, miopenRNNAlgo_t algo,
    miopenDataType_t dataType) {
  return DynamicCall<decltype(miopenSetRNNDescriptor_V2),
                     &miopenSetRNNDescriptor_V2>(
      "miopenSetRNNDescriptor_V2", rnnDesc, hsize, nlayers, dropoutDesc, inMode,
      direction, rnnMode, biasMode, algo, dataType);
}

MIOPEN_EXPORT miopenStatus_t miopenGetRNNWorkspaceSize(
    miopenHandle_t handle, const miopenRNNDescriptor_t rnnDesc,
    const int sequenceLen, const miopenTensorDescriptor_t* xDesc,
    size_t* numBytes) {
  return DynamicCall<decltype(miopenGetRNNWorkspaceSize),
                     &miopenGetRNNWorkspaceSize>("miopenGetRNNWorkspaceSize",
                                                 handle, rnnDesc, sequenceLen,
                                                 xDesc, numBytes);
}

MIOPEN_EXPORT miopenStatus_t miopenGetRNNTrainingReserveSize(
    miopenHandle_t handle, miopenRNNDescriptor_t rnnDesc, const int sequenceLen,
    const miopenTensorDescriptor_t* xDesc, size_t* numBytes) {
  return DynamicCall<decltype(miopenGetRNNTrainingReserveSize),
                     &miopenGetRNNTrainingReserveSize>(
      "miopenGetRNNTrainingReserveSize", handle, rnnDesc, sequenceLen, xDesc,
      numBytes);
}

MIOPEN_EXPORT miopenStatus_t miopenGetRNNParamsSize(
    miopenHandle_t handle, miopenRNNDescriptor_t rnnDesc,
    miopenTensorDescriptor_t xDesc, size_t* numBytes, miopenDataType_t dtype) {
  return DynamicCall<decltype(miopenGetRNNParamsSize), &miopenGetRNNParamsSize>(
      "miopenGetRNNParamsSize", handle, rnnDesc, xDesc, numBytes, dtype);
}

MIOPEN_EXPORT miopenStatus_t miopenGetRNNParamsDescriptor(
    miopenHandle_t handle, miopenRNNDescriptor_t rnnDesc,
    miopenTensorDescriptor_t xDesc, miopenTensorDescriptor_t wDesc,
    miopenDataType_t dtype) {
  return DynamicCall<decltype(miopenGetRNNParamsDescriptor),
                     &miopenGetRNNParamsDescriptor>(
      "miopenGetRNNParamsDescriptor", handle, rnnDesc, xDesc, wDesc, dtype);
}

MIOPEN_EXPORT miopenStatus_t miopenGetRNNInputTensorSize(
    miopenHandle_t handle, miopenRNNDescriptor_t rnnDesc, const int seqLen,
    miopenTensorDescriptor_t* xDesc, size_t* numBytes) {
  return DynamicCall<decltype(miopenGetRNNInputTensorSize),
                     &miopenGetRNNInputTensorSize>(
      "miopenGetRNNInputTensorSize", handle, rnnDesc, seqLen, xDesc, numBytes);
}

MIOPEN_EXPORT miopenStatus_t miopenGetRNNHiddenTensorSize(
    miopenHandle_t handle, miopenRNNDescriptor_t rnnDesc, const int seqLen,
    miopenTensorDescriptor_t* xDesc, size_t* numBytes) {
  return DynamicCall<decltype(miopenGetRNNHiddenTensorSize),
                     &miopenGetRNNHiddenTensorSize>(
      "miopenGetRNNHiddenTensorSize", handle, rnnDesc, seqLen, xDesc, numBytes);
}

MIOPEN_EXPORT miopenStatus_t miopenGetRNNLayerParamSize(
    miopenHandle_t handle, miopenRNNDescriptor_t rnnDesc, const int layer,
    miopenTensorDescriptor_t xDesc, const int paramID, size_t* numBytes) {
  return DynamicCall<decltype(miopenGetRNNLayerParamSize),
                     &miopenGetRNNLayerParamSize>("miopenGetRNNLayerParamSize",
                                                  handle, rnnDesc, layer, xDesc,
                                                  paramID, numBytes);
}

MIOPEN_EXPORT miopenStatus_t
miopenGetRNNLayerBiasSize(miopenHandle_t handle, miopenRNNDescriptor_t rnnDesc,
                          const int layer, const int biasID, size_t* numBytes) {
  return DynamicCall<decltype(miopenGetRNNLayerBiasSize),
                     &miopenGetRNNLayerBiasSize>(
      "miopenGetRNNLayerBiasSize", handle, rnnDesc, layer, biasID, numBytes);
}

MIOPEN_EXPORT miopenStatus_t miopenGetRNNLayerParam(
    miopenHandle_t handle, miopenRNNDescriptor_t rnnDesc, const int layer,
    miopenTensorDescriptor_t xDesc, miopenTensorDescriptor_t wDesc,
    const void* w, const int paramID, miopenTensorDescriptor_t paramDesc,
    void* layerParam) {
  return DynamicCall<decltype(miopenGetRNNLayerParam), &miopenGetRNNLayerParam>(
      "miopenGetRNNLayerParam", handle, rnnDesc, layer, xDesc, wDesc, w,
      paramID, paramDesc, layerParam);
}

MIOPEN_EXPORT miopenStatus_t miopenGetRNNLayerBias(
    miopenHandle_t handle, miopenRNNDescriptor_t rnnDesc, const int layer,
    miopenTensorDescriptor_t xDesc, miopenTensorDescriptor_t wDesc,
    const void* w, const int biasID, miopenTensorDescriptor_t biasDesc,
    void* layerBias) {
  return DynamicCall<decltype(miopenGetRNNLayerBias), &miopenGetRNNLayerBias>(
      "miopenGetRNNLayerBias", handle, rnnDesc, layer, xDesc, wDesc, w, biasID,
      biasDesc, layerBias);
}

MIOPEN_EXPORT miopenStatus_t miopenGetRNNLayerParamOffset(
    miopenRNNDescriptor_t rnnDesc, const int layer,
    miopenTensorDescriptor_t xDesc, const int paramID,
    miopenTensorDescriptor_t paramDesc, size_t* layerParamOffset) {
  return DynamicCall<decltype(miopenGetRNNLayerParamOffset),
                     &miopenGetRNNLayerParamOffset>(
      "miopenGetRNNLayerParamOffset", rnnDesc, layer, xDesc, paramID, paramDesc,
      layerParamOffset);
}

MIOPEN_EXPORT miopenStatus_t miopenGetRNNLayerBiasOffset(
    miopenRNNDescriptor_t rnnDesc, const int layer,
    miopenTensorDescriptor_t xDesc, const int biasID,
    miopenTensorDescriptor_t biasDesc, size_t* layerBiasOffset) {
  return DynamicCall<decltype(miopenGetRNNLayerBiasOffset),
                     &miopenGetRNNLayerBiasOffset>(
      "miopenGetRNNLayerBiasOffset", rnnDesc, layer, xDesc, biasID, biasDesc,
      layerBiasOffset);
}

MIOPEN_EXPORT miopenStatus_t miopenSetRNNLayerParam(
    miopenHandle_t handle, miopenRNNDescriptor_t rnnDesc, const int layer,
    miopenTensorDescriptor_t xDesc, miopenTensorDescriptor_t wDesc, void* w,
    const int paramID, miopenTensorDescriptor_t paramDesc,
    const void* layerParam) {
  return DynamicCall<decltype(miopenSetRNNLayerParam), &miopenSetRNNLayerParam>(
      "miopenSetRNNLayerParam", handle, rnnDesc, layer, xDesc, wDesc, w,
      paramID, paramDesc, layerParam);
}

MIOPEN_EXPORT miopenStatus_t miopenSetRNNLayerBias(
    miopenHandle_t handle, miopenRNNDescriptor_t rnnDesc, const int layer,
    miopenTensorDescriptor_t xDesc, miopenTensorDescriptor_t wDesc, void* w,
    const int biasID, miopenTensorDescriptor_t biasDesc,
    const void* layerBias) {
  return DynamicCall<decltype(miopenSetRNNLayerBias), &miopenSetRNNLayerBias>(
      "miopenSetRNNLayerBias", handle, rnnDesc, layer, xDesc, wDesc, w, biasID,
      biasDesc, layerBias);
}

MIOPEN_EXPORT miopenStatus_t miopenRNNForwardTraining(
    miopenHandle_t handle, const miopenRNNDescriptor_t rnnDesc,
    const int sequenceLen, const miopenTensorDescriptor_t* xDesc, const void* x,
    const miopenTensorDescriptor_t hxDesc, const void* hx,
    const miopenTensorDescriptor_t cxDesc, const void* cx,
    const miopenTensorDescriptor_t wDesc, const void* w,
    const miopenTensorDescriptor_t* yDesc, void* y,
    const miopenTensorDescriptor_t hyDesc, void* hy,
    const miopenTensorDescriptor_t cyDesc, void* cy, void* workSpace,
    size_t workSpaceNumBytes, void* reserveSpace, size_t reserveSpaceNumBytes) {
  return DynamicCall<decltype(miopenRNNForwardTraining),
                     &miopenRNNForwardTraining>(
      "miopenRNNForwardTraining", handle, rnnDesc, sequenceLen, xDesc, x,
      hxDesc, hx, cxDesc, cx, wDesc, w, yDesc, y, hyDesc, hy, cyDesc, cy,
      workSpace, workSpaceNumBytes, reserveSpace, reserveSpaceNumBytes);
}

MIOPEN_EXPORT miopenStatus_t miopenRNNBackwardData(
    miopenHandle_t handle, const miopenRNNDescriptor_t rnnDesc,
    const int sequenceLen, const miopenTensorDescriptor_t* yDesc, const void* y,
    const miopenTensorDescriptor_t* dyDesc, const void* dy,
    const miopenTensorDescriptor_t dhyDesc, const void* dhy,
    const miopenTensorDescriptor_t dcyDesc, const void* dcy,
    const miopenTensorDescriptor_t wDesc, const void* w,
    const miopenTensorDescriptor_t hxDesc, const void* hx,
    const miopenTensorDescriptor_t cxDesc, const void* cx,
    const miopenTensorDescriptor_t* dxDesc, void* dx,
    const miopenTensorDescriptor_t dhxDesc, void* dhx,
    const miopenTensorDescriptor_t dcxDesc, void* dcx, void* workSpace,
    size_t workSpaceNumBytes, void* reserveSpace, size_t reserveSpaceNumBytes) {
  return DynamicCall<decltype(miopenRNNBackwardData), &miopenRNNBackwardData>(
      "miopenRNNBackwardData", handle, rnnDesc, sequenceLen, yDesc, y, dyDesc,
      dy, dhyDesc, dhy, dcyDesc, dcy, wDesc, w, hxDesc, hx, cxDesc, cx, dxDesc,
      dx, dhxDesc, dhx, dcxDesc, dcx, workSpace, workSpaceNumBytes,
      reserveSpace, reserveSpaceNumBytes);
}

MIOPEN_EXPORT miopenStatus_t miopenRNNBackwardWeights(
    miopenHandle_t handle, const miopenRNNDescriptor_t rnnDesc,
    const int sequenceLen, const miopenTensorDescriptor_t* xDesc, const void* x,
    const miopenTensorDescriptor_t hxDesc, const void* hx,
    const miopenTensorDescriptor_t* yDesc, const void* y,
    const miopenTensorDescriptor_t dwDesc, void* dw, void* workSpace,
    size_t workSpaceNumBytes, const void* reserveSpace,
    size_t reserveSpaceNumBytes) {
  return DynamicCall<decltype(miopenRNNBackwardWeights),
                     &miopenRNNBackwardWeights>(
      "miopenRNNBackwardWeights", handle, rnnDesc, sequenceLen, xDesc, x,
      hxDesc, hx, yDesc, y, dwDesc, dw, workSpace, workSpaceNumBytes,
      reserveSpace, reserveSpaceNumBytes);
}

MIOPEN_EXPORT miopenStatus_t miopenRNNForwardInference(
    miopenHandle_t handle, miopenRNNDescriptor_t rnnDesc, const int sequenceLen,
    const miopenTensorDescriptor_t* xDesc, const void* x,
    const miopenTensorDescriptor_t hxDesc, const void* hx,
    const miopenTensorDescriptor_t cxDesc, const void* cx,
    const miopenTensorDescriptor_t wDesc, const void* w,
    const miopenTensorDescriptor_t* yDesc, void* y,
    const miopenTensorDescriptor_t hyDesc, void* hy,
    const miopenTensorDescriptor_t cyDesc, void* cy, void* workSpace,
    size_t workSpaceNumBytes) {
  return DynamicCall<decltype(miopenRNNForwardInference),
                     &miopenRNNForwardInference>(
      "miopenRNNForwardInference", handle, rnnDesc, sequenceLen, xDesc, x,
      hxDesc, hx, cxDesc, cx, wDesc, w, yDesc, y, hyDesc, hy, cyDesc, cy,
      workSpace, workSpaceNumBytes);
}

MIOPEN_EXPORT miopenStatus_t
miopenCreateCTCLossDescriptor(miopenCTCLossDescriptor_t* ctcLossDesc) {
  return DynamicCall<decltype(miopenCreateCTCLossDescriptor),
                     &miopenCreateCTCLossDescriptor>(
      "miopenCreateCTCLossDescriptor", ctcLossDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenGetCTCLossDescriptor(
    miopenCTCLossDescriptor_t ctcLossDesc, miopenDataType_t* dataType,
    int* blank_label_id, bool* apply_softmax_layer) {
  return DynamicCall<decltype(miopenGetCTCLossDescriptor),
                     &miopenGetCTCLossDescriptor>(
      "miopenGetCTCLossDescriptor", ctcLossDesc, dataType, blank_label_id,
      apply_softmax_layer);
}

MIOPEN_EXPORT miopenStatus_t
miopenDestroyCTCLossDescriptor(miopenCTCLossDescriptor_t ctcLossDesc) {
  return DynamicCall<decltype(miopenDestroyCTCLossDescriptor),
                     &miopenDestroyCTCLossDescriptor>(
      "miopenDestroyCTCLossDescriptor", ctcLossDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenSetCTCLossDescriptor(
    miopenCTCLossDescriptor_t ctcLossDesc, miopenDataType_t dataType,
    const int blank_label_id, bool apply_softmax_layer) {
  return DynamicCall<decltype(miopenSetCTCLossDescriptor),
                     &miopenSetCTCLossDescriptor>(
      "miopenSetCTCLossDescriptor", ctcLossDesc, dataType, blank_label_id,
      apply_softmax_layer);
}

MIOPEN_EXPORT miopenStatus_t miopenGetCTCLossWorkspaceSize(
    miopenHandle_t handle, const miopenTensorDescriptor_t probsDesc,
    const miopenTensorDescriptor_t gradientsDesc, const int* labels,
    const int* labelLengths, const int* inputLengths, miopenCTCLossAlgo_t algo,
    const miopenCTCLossDescriptor_t ctcLossDesc, size_t* workSpaceSize) {
  return DynamicCall<decltype(miopenGetCTCLossWorkspaceSize),
                     &miopenGetCTCLossWorkspaceSize>(
      "miopenGetCTCLossWorkspaceSize", handle, probsDesc, gradientsDesc, labels,
      labelLengths, inputLengths, algo, ctcLossDesc, workSpaceSize);
}

MIOPEN_EXPORT miopenStatus_t miopenCTCLoss(
    miopenHandle_t handle, const miopenTensorDescriptor_t probsDesc,
    const void* probs, const int* labels, const int* labelLengths,
    const int* inputLengths, void* losses,
    const miopenTensorDescriptor_t gradientsDesc, void* gradients,
    miopenCTCLossAlgo_t algo, const miopenCTCLossDescriptor_t ctcLossDesc,
    void* workSpace, size_t workSpaceSize) {
  return DynamicCall<decltype(miopenCTCLoss), &miopenCTCLoss>(
      "miopenCTCLoss", handle, probsDesc, probs, labels, labelLengths,
      inputLengths, losses, gradientsDesc, gradients, algo, ctcLossDesc,
      workSpace, workSpaceSize);
}

MIOPEN_EXPORT miopenStatus_t
miopenCreateDropoutDescriptor(miopenDropoutDescriptor_t* dropoutDesc) {
  return DynamicCall<decltype(miopenCreateDropoutDescriptor),
                     &miopenCreateDropoutDescriptor>(
      "miopenCreateDropoutDescriptor", dropoutDesc);
}

MIOPEN_EXPORT miopenStatus_t
miopenDestroyDropoutDescriptor(miopenDropoutDescriptor_t dropoutDesc) {
  return DynamicCall<decltype(miopenDestroyDropoutDescriptor),
                     &miopenDestroyDropoutDescriptor>(
      "miopenDestroyDropoutDescriptor", dropoutDesc);
}

MIOPEN_EXPORT miopenStatus_t miopenDropoutGetReserveSpaceSize(
    const miopenTensorDescriptor_t xDesc, size_t* reserveSpaceSizeInBytes) {
  return DynamicCall<decltype(miopenDropoutGetReserveSpaceSize),
                     &miopenDropoutGetReserveSpaceSize>(
      "miopenDropoutGetReserveSpaceSize", xDesc, reserveSpaceSizeInBytes);
}

MIOPEN_EXPORT miopenStatus_t
miopenDropoutGetStatesSize(miopenHandle_t handle, size_t* stateSizeInBytes) {
  return DynamicCall<decltype(miopenDropoutGetStatesSize),
                     &miopenDropoutGetStatesSize>("miopenDropoutGetStatesSize",
                                                  handle, stateSizeInBytes);
}

MIOPEN_EXPORT miopenStatus_t miopenGetDropoutDescriptor(
    miopenDropoutDescriptor_t dropoutDesc, miopenHandle_t handle,
    float* dropout, void** states, unsigned long long* seed, bool* use_mask,
    bool* state_evo, miopenRNGType_t* rng_mode) {
  return DynamicCall<decltype(miopenGetDropoutDescriptor),
                     &miopenGetDropoutDescriptor>(
      "miopenGetDropoutDescriptor", dropoutDesc, handle, dropout, states, seed,
      use_mask, state_evo, rng_mode);
}

MIOPEN_EXPORT miopenStatus_t miopenRestoreDropoutDescriptor(
    miopenDropoutDescriptor_t dropoutDesc, miopenHandle_t handle, float dropout,
    void* states, size_t stateSizeInBytes, unsigned long long seed,
    bool use_mask, bool state_evo, miopenRNGType_t rng_mode) {
  return DynamicCall<decltype(miopenRestoreDropoutDescriptor),
                     &miopenRestoreDropoutDescriptor>(
      "miopenRestoreDropoutDescriptor", dropoutDesc, handle, dropout, states,
      stateSizeInBytes, seed, use_mask, state_evo, rng_mode);
}

MIOPEN_EXPORT miopenStatus_t miopenSetDropoutDescriptor(
    miopenDropoutDescriptor_t dropoutDesc, miopenHandle_t handle, float dropout,
    void* states, size_t stateSizeInBytes, unsigned long long seed,
    bool use_mask, bool state_evo, miopenRNGType_t rng_mode) {
  return DynamicCall<decltype(miopenSetDropoutDescriptor),
                     &miopenSetDropoutDescriptor>(
      "miopenSetDropoutDescriptor", dropoutDesc, handle, dropout, states,
      stateSizeInBytes, seed, use_mask, state_evo, rng_mode);
}

MIOPEN_EXPORT miopenStatus_t miopenDropoutForward(
    miopenHandle_t handle, const miopenDropoutDescriptor_t dropoutDesc,
    const miopenTensorDescriptor_t noise_shape,
    const miopenTensorDescriptor_t xDesc, const void* x,
    const miopenTensorDescriptor_t yDesc, void* y, void* reserveSpace,
    size_t reserveSpaceSizeInBytes) {
  return DynamicCall<decltype(miopenDropoutForward), &miopenDropoutForward>(
      "miopenDropoutForward", handle, dropoutDesc, noise_shape, xDesc, x, yDesc,
      y, reserveSpace, reserveSpaceSizeInBytes);
}

MIOPEN_EXPORT miopenStatus_t miopenDropoutBackward(
    miopenHandle_t handle, const miopenDropoutDescriptor_t dropoutDesc,
    const miopenTensorDescriptor_t noise_shape,
    const miopenTensorDescriptor_t dyDesc, const void* dy,
    const miopenTensorDescriptor_t dxDesc, void* dx, void* reserveSpace,
    size_t reserveSpaceSizeInBytes) {
  return DynamicCall<decltype(miopenDropoutBackward), &miopenDropoutBackward>(
      "miopenDropoutBackward", handle, dropoutDesc, noise_shape, dyDesc, dy,
      dxDesc, dx, reserveSpace, reserveSpaceSizeInBytes);
}
