# ResNet50 Inference Benchmark in TFRT

<!--* freshness: {
  owner: 'chuanhao'
  reviewed: '2021-05-04'
} *-->

<!-- TOC -->

The goal of this test is to demonstrate that the TFRT can run a large-sized
ResNet50 model in inference mode (forward-pass only). This document describes
the setup of the ResNet50 integration test and walks through the instructions to
run it. The ResNet50 model executed in this test is same as the model used by
[MLPerf inference benchmark](https://github.com/mlperf/inference/tree/r0.5/v0.5/classification_and_detection).

The test runs ResNet50 inference on CPU for one step and checks that it
generates the expected result. It is different from the ResNet50 inference GPU
benchmark presented in the 2020 TensorFlow DevSummit.

## Test setup

This test has the following files:

*   [test_data/resnet50_graph_inference_tensors.btf](https://drive.google.com/file/d/19ltUPerqdLVDnOjjfnlPEyTFFd9P9CQ6/view?usp=sharing)
    that stores the model weights, the input and the output (generated by
    TensorFlow) in the custom [Binary Tensor Format](binary_tensor_format.md)
    (BTF).

    Since the BTF file is more than 90 MB, we can not check it into repository
    and you will need to manually download
    `resnet50_graph_inference_tensors.btf` from Google Drive
    [here](https://drive.google.com/file/d/19ltUPerqdLVDnOjjfnlPEyTFFd9P9CQ6/view?usp=sharing)
    to the directory `integrationtest/resnet/test_data/`.

*   [resnet50_graph_inference.mlir](https://github.com/tensorflow/runtime/blob/master/integrationtest/resnet/resnet50_graph_inference.mlir)
    that initializes the ResNet50 model in TFRT using the model weights stored
    in the resnet50_graph_inference_tensors.btf, runs one inference step using
    the input from the BTF file, and verifies that the output has the same
    numerical value as the output from TensorFlow.

## Test instructions

First, download `resnet50_graph_inference_tensors.btf` from Google Drive
[here](https://drive.google.com/file/d/1BTjhifDMUr7Ch4BGYdMPzRnym9Jjvgvk/view?usp=sharing)
to the directory `integrationtest/resnet/test_data/`.

Then modify `//integrationtest/resnet/BUILD` to un-comment the line that
contains `resnet50_graph_inference_tensors.btf` and remove the line that
contains `resnet50_graph_inference.mlir` in the `exclude` section.

Lastly, execute the command below to run the test.

```shell
$ bazel test //integrationtest/resnet:resnet50_graph_inference.mlir.test
```
